/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import javax.swing.table.TableModel;

/**
 * The Interface JNPadTableModel.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface JNPadTableModel extends TableModel {
  
  /**
   * Checks if is sortable.
   *
   * @param columnIndex int
   * @return boolean
   */
  boolean isSortable(int columnIndex);

  /**
   * Sets the sort by column.
   *
   * @param sortedColumnIndex int
   * @param isAscending boolean
   */
  void setSortByColumn(int sortedColumnIndex, boolean isAscending);

  /**
   * Checks if is ascending.
   *
   * @return boolean
   */
  boolean isAscending();

  /**
   * Gets the sorted column index.
   *
   * @return int
   */
  int getSortedColumnIndex();
}

