/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.util;

/**
 * The Class LinePosition.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class LinePosition {
  private int                 line;                 // n de lnea
  private int                 column;               // n de columna
  private int                 character;            // n de caracter en la lnea
  private int                 lines;                // n de lneas
  private int                 characters;           // n de caracteres en la lnea

  private final static String LINE      = "Ln: ";   //$NON-NLS-1$
  private final static String COLUMN    = "Col: ";  //$NON-NLS-1$
  private final static String CHARACTER = "Char: "; //$NON-NLS-1$

  /**
   * Instantiates a new line position.
   */
  public LinePosition() {
    this.line       = 1;
    this.column     = 1;
    this.character  = 1;
    this.lines      = 1;
    this.characters = 1;
  }

  /**
   * Instantiates a new line position.
   *
   * @param line int
   * @param column int
   * @param character int
   * @param lines int
   * @param characters int
   */
  public LinePosition(int line, int column, int character, int lines, int characters) {
    this.line       = line;
    this.column     = column;
    this.character  = character;
    this.lines      = lines;
    this.characters = characters;
  }

  /**
   * Gets the line.
   *
   * @return the line
   */
  public int getLine() {
    return line;
  }

  /**
   * Gets the column.
   *
   * @return the column
   */
  public int getColumn() {
    return column;
  }

  /**
   * Gets the character.
   *
   * @return the character
   */
  public int getCharacter() {
    return character;
  }

  /**
   * Gets the lines.
   *
   * @return the lines
   */
  public int getLines() {
    return lines;
  }

  /**
   * Gets the characters.
   *
   * @return the characters
   */
  public int getCharacters() {
    return characters;
  }

  /**
   * Sets the.
   *
   * @param p the LinePosition
   */
  public void set(LinePosition p) {
    setLine(p.getLine());
    setColumn(p.getColumn());
    setCharacter(p.getCharacter());
    setLines(p.getLines());
    setCharacters(p.getCharacters());
  }

  /**
   * Sets the line.
   *
   * @param line the new line
   */
  public void setLine(int line) {
    this.line = line;
  }

  /**
   * Sets the column.
   *
   * @param column the new column
   */
  public void setColumn(int column) {
    this.column = column;
  }

  /**
   * Sets the character.
   *
   * @param character the new character
   */
  public void setCharacter(int character) {
    this.character = character;
  }

  /**
   * Sets the lines.
   *
   * @param lines the new lines
   */
  public void setLines(int lines) {
    this.lines = lines;
  }

  /**
   * Sets the characters.
   *
   * @param characters the new characters
   */
  public void setCharacters(int characters) {
    this.characters = characters;
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return toString(line, column, character, lines, characters);
  }

  /**
   * To string.
   *
   * @param line the line
   * @param column the column
   * @param character the character
   * @param lines the lines
   * @param characters the characters
   * @return the string
   */
  public static String toString(int line, int column, int character, int lines, int characters) {
    StringBuilder sb = new StringBuilder();
    sb.append(LINE).append(line).append(" / ").append(lines).append("  ");   //$NON-NLS-1$ //$NON-NLS-2$
    sb.append(COLUMN).append(column).append("  ");                           //$NON-NLS-1$
    sb.append(CHARACTER).append(character).append(" / ").append(characters); //$NON-NLS-1$
    return sb.toString();
  }

}
