/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.util;

/**
 * The Enum LineSeparator.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public enum LineSeparator {
  /** Line Separator Windows */
  DOS("DOS", "Windows/DOS (CR+LF)", Utilities.LINE_SEPARATOR_WINDOWS), //$NON-NLS-1$//$NON-NLS-2$

  /** Line Separator Unix */
  UNIX("UNIX", "Unix (LF)", Utilities.LINE_SEPARATOR_UNIX),            //$NON-NLS-1$ //$NON-NLS-2$

  /** Line Separator Mac */
  MAC("MAC", "Mac (CR)", Utilities.LINE_SEPARATOR_MAC);                //$NON-NLS-1$ //$NON-NLS-2$

  private final String name;
  private final String longName;
  private final String lineSeparator;

  /**
   * Instantiates a new line separator.
   *
   * @param name String
   * @param longName String
   * @param lineSeparator String
   */
  private LineSeparator(final String name, final String longName, final String lineSeparator) {
    this.name          = name;
    this.longName      = longName;
    this.lineSeparator = lineSeparator;
  }

  /**
   * Gets the line separator.
   *
   * @return the line separator
   */
  public String getLineSeparator() {
    return lineSeparator;
  }

  /**
   * Gets the name.
   *
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * Gets the long name.
   *
   * @return the long name
   */
  public String getLongName() {
    return longName;
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Enum#toString()
   */
  @Override
  public String toString() {
    return name;
  }

  /**
   * Gets the default.
   *
   * @return the default
   */
  public static LineSeparator getDefault() {
    String lineSeparator = Utilities.LINE_SEPARATOR;

    if (lineSeparator.equals(Utilities.LINE_SEPARATOR_WINDOWS))
      return DOS;

    if (lineSeparator.equals(Utilities.LINE_SEPARATOR_MAC))
      return MAC;

    if (lineSeparator.equals(Utilities.LINE_SEPARATOR_UNIX))
      return UNIX;

    // --- no debera pasar ---
    if (Platform.isWindows)
      return DOS;

    if (Platform.isMac)
      return MAC;

    return UNIX;
    // ---
  }

}
