/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.tags.BASEFONT;

public final class BasefontTagRecord {
    private int[] indices;
    public int numIndices;
    private Document doc;

    public BasefontTagRecord(Document document) {
        this.doc = document;
        this.indices = null;
        this.numIndices = 0;
    }

    public synchronized int basefontSizeAt(DocStyle docStyle, int n) {
        int n2 = this.maxLessThanOrEqual(n);
        if (n2 < 0) {
            return docStyle.adjustFontSize(5);
        }
        int n3 = ((BASEFONT)this.doc.getItem(this.indices[n2])).getRawSize();
        return docStyle.adjustFontSize(n3);
    }

    public void changeTagIndex(int n, int n2) {
        this.removeTag(n);
        this.addTag(n2);
    }

    public synchronized void addTag(int n) {
        int n2;
        if (this.indices == null) {
            this.indices = new int[1];
        } else if (this.numIndices == this.indices.length) {
            n2 = this.indices.length * 2;
            int[] nArray = this.indices;
            this.indices = new int[n2];
            int n3 = 0;
            while (n3 < this.numIndices) {
                this.indices[n3] = nArray[n3];
                ++n3;
            }
        }
        n2 = this.maxLessThanOrEqual(n);
        ++n2;
        int n4 = this.numIndices - 1;
        while (n4 >= n2) {
            this.indices[n4 + 1] = this.indices[n4];
            --n4;
        }
        this.indices[n2] = n;
        ++this.numIndices;
    }

    private void removeTag(int n) {
        int n2;
        int n3 = n2 = this.maxLessThanOrEqual(n);
        while (n3 < this.numIndices - 1) {
            this.indices[n3] = this.indices[n3 + 1];
            ++n3;
        }
        --this.numIndices;
    }

    synchronized void notifyDocItemsDeleted(int n, int n2) {
        int n3 = n + n2 - 1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numIndices) {
            if (this.indices[n5] < n) {
                this.indices[n4++] = this.indices[n5];
            } else if (this.indices[n5] > n3) {
                this.indices[n4++] = this.indices[n5] - n2;
            }
            ++n5;
        }
        this.numIndices = n4;
        if (this.numIndices == 0) {
            this.indices = null;
        }
    }

    int maxLessThanOrEqual(int n) {
        int n2 = 0;
        int n3 = this.numIndices - 1;
        while (n2 < n3) {
            int n4 = (n3 + n2 + 1) / 2;
            if (this.indices[n4] <= n) {
                n2 = n4;
                continue;
            }
            n3 = n4 - 1;
        }
        if (n2 > n3 || this.indices[n3] > n) {
            return -1;
        }
        return n3;
    }
}

