/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.util.Hashtable;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.FormatState;
import sunw.html.Attributes;

public class Align {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_TEXTTOP = 1;
    public static final int ALIGN_MIDDLE = 2;
    public static final int ALIGN_ABSMIDDLE = 3;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_BOTTOM = 5;
    public static final int ALIGN_ABSBOTTOM = 6;
    public static final int ALIGN_LEFT = 7;
    public static final int ALIGN_RIGHT = 8;
    public static final int ALIGN_CENTER = 9;
    public static final int TOP_MASK = 1;
    public static final int TEXTTOP_MASK = 2;
    public static final int MIDDLE_MASK = 4;
    public static final int ABSMIDDLE_MASK = 8;
    public static final int BASELINE_MASK = 16;
    public static final int BOTTOM_MASK = 32;
    public static final int ABSBOTTOM_MASK = 64;
    public static final int LEFT_MASK = 128;
    public static final int RIGHT_MASK = 256;
    public static final int CENTER_MASK = 512;
    private static Hashtable alignHash = new Hashtable(11);

    public static int getAlign(Attributes attributes) {
        return Align.getAlign(attributes, "align");
    }

    public static int getAlign(Attributes attributes, String string) {
        return Align.getAlign(attributes, string, 5);
    }

    public static int getAlign(Attributes attributes, String string, int n) {
        Number number;
        String string2;
        if (attributes != null && (string2 = attributes.get(string)) != null && (number = (Number)alignHash.get(string2.toLowerCase())) != null) {
            return number.intValue();
        }
        return n;
    }

    public static int getFormat(Attributes attributes, String string, int n) {
        Number number;
        String string2;
        if (attributes != null && (string2 = attributes.get(string)) != null && (number = (Number)alignHash.get(string2.toLowerCase())) != null) {
            switch (number.intValue()) {
                case 7: {
                    return 0;
                }
                case 9: {
                    return 3;
                }
                case 8: {
                    return 1;
                }
            }
        }
        return n;
    }

    public static int getCheckedAlign(Attributes attributes, String string, int n, int n2) {
        int n3 = Align.getAlign(attributes, string, n2);
        if ((1 << n3 & n) == 0) {
            return -1;
        }
        return n3;
    }

    public static int yOffset(DocLine docLine, DocStyle docStyle, int n, int n2) {
        switch (n) {
            case 0: {
                return docLine.baseline - docLine.lnascent;
            }
            case 1: {
                return docLine.baseline - docLine.textAscent;
            }
            case 2: {
                return docLine.baseline - n2 / 2;
            }
            case 3: {
                return (docLine.height - n2) / 2;
            }
            case 4: 
            case 5: {
                return docLine.baseline - n2;
            }
            case 6: {
                return docLine.baseline + docLine.lndescent - n2;
            }
        }
        return 0;
    }

    public static int getAscent(FormatState formatState, int n, int n2) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return formatState.style.ascent;
            }
            case 2: {
                return n2 / 2;
            }
            case 3: {
                return n2 / 2 + formatState.style.ascent / 2;
            }
            case 4: 
            case 5: {
                return n2;
            }
            case 6: {
                return n2 - formatState.descent;
            }
        }
        return n2;
    }

    public static int getDescent(FormatState formatState, int n, int n2) {
        switch (n) {
            case 0: {
                return n2;
            }
            case 1: {
                return n2 - formatState.style.ascent;
            }
            case 2: {
                return n2 / 2;
            }
            case 3: {
                return n2 / 2 - formatState.style.ascent / 2;
            }
            case 4: 
            case 5: {
                return 0;
            }
            case 6: {
                return formatState.descent;
            }
        }
        return 0;
    }

    static {
        alignHash.put("top", new Integer(0));
        alignHash.put("texttop", new Integer(1));
        alignHash.put("middle", new Integer(2));
        alignHash.put("absmiddle", new Integer(3));
        alignHash.put("baseline", new Integer(4));
        alignHash.put("bottom", new Integer(5));
        alignHash.put("absbottom", new Integer(6));
        alignHash.put("left", new Integer(7));
        alignHash.put("right", new Integer(8));
        alignHash.put("center", new Integer(9));
    }
}

