/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4;
import innoval.mail.Imap4Cmd;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Message;
import java.util.Vector;

public class Imap4Folder {
    static final int READ_WRITE = 0;
    static final int READ_ONLY = 1;
    private Imap4 imap = null;
    private String separator = null;
    private String path = null;
    private String name = null;
    private boolean readonly = false;
    private boolean open = false;
    private Vector child = new Vector();
    private int msgs = 0;
    private int recent = 0;
    private int unseen = 0;

    public Imap4Folder(Imap4 imap) {
        this.imap = imap;
        this.path = new String("");
        this.name = new String("");
    }

    public Imap4Folder(Imap4 imap, String path, String name) {
        this.imap = imap;
        this.path = path.length() == 1 ? new String("") : new String(path);
        this.path = new String(this.path.replace('\"', ' ').trim());
        this.name = new String(name.replace('\"', ' ').trim());
    }

    public Imap4Folder(Imap4 imap, String rec) {
        int spot = -1;
        int spot1 = -1;
        this.imap = imap;
        this.name = new String("<unknown>");
        this.path = new String("");
        if (rec.toUpperCase().startsWith("* LIST ")) {
            spot = rec.toLowerCase().indexOf("nil");
            if (spot >= 0) {
                spot = rec.indexOf(32, spot);
                this.name = new String(rec.substring(spot + 1).trim());
                this.path = new String("");
            } else {
                spot = rec.indexOf("\"");
                if (spot >= 0) {
                    spot1 = rec.indexOf("\"", spot + 1);
                }
                if (spot > 0 && spot1 > 0) {
                    this.separator = new String(rec.substring(spot + 1, spot1));
                    spot = (rec = new String(rec.substring(spot1 + 1).trim())).lastIndexOf(this.separator);
                    if (spot > 0) {
                        this.path = new String(rec.substring(0, spot += this.separator.length()));
                        rec = new String(rec.substring(spot));
                    } else {
                        this.path = new String("");
                    }
                    this.name = new String(rec);
                } else {
                    spot = rec.trim().lastIndexOf(32);
                    if (spot > 0) {
                        this.path = new String("");
                        this.name = new String(rec.substring(spot).trim());
                    }
                }
            }
        }
        this.path = new String(this.path.replace('\"', ' ').trim());
        this.name = new String(this.name.replace('\"', ' ').trim());
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setPath(String path) {
        this.path = new String(path);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = new String(name);
    }

    public String getWholeName() {
        return new String(String.valueOf(this.path).concat(String.valueOf(this.name)));
    }

    public int getMessageCount() {
        return this.msgs;
    }

    public int getNewCount() {
        return this.recent;
    }

    public int getUnseenStart() {
        return this.unseen;
    }

    public boolean open() throws Imap4Exception {
        return this.open(0);
    }

    public boolean open(int type) throws Imap4Exception {
        boolean ret_code = true;
        Imap4Cmd cmd = null;
        Object text = null;
        this.imap.setText(String.valueOf(String.valueOf("Opening folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        cmd = type == 0 ? this.imap.issueCmd(String.valueOf(String.valueOf("SELECT \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\""))) : this.imap.issueCmd(String.valueOf(String.valueOf("EXAMINE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\"")));
        if (cmd.getResult() == 1) {
            for (int i = 0; i < cmd.getSize(); ++i) {
                this.parseOpenRecord(cmd.get(i));
            }
        } else {
            throw new Imap4Exception(cmd.getResponse());
        }
        this.open = true;
        ret_code = true;
        this.imap.setText("Folder is open.");
        return ret_code;
    }

    private void parseOpenRecord(String text) {
        if ((text = new String(text.trim().toUpperCase())).endsWith("EXISTS")) {
            text = new String(text.substring(2).trim());
            text = new String(text.substring(0, text.length() - 6).trim());
            try {
                this.msgs = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (text.endsWith("RECENT")) {
            text = new String(text.substring(2).trim());
            text = new String(text.substring(0, text.length() - 6).trim());
            try {
                this.recent = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (text.indexOf("[UNSEEN ") > 0) {
            int spot = text.indexOf("[UNSEEN ");
            if ((spot = (text = new String(text.substring(spot + 8))).indexOf(93)) > 0) {
                text = new String(text.substring(0, spot).trim());
                try {
                    this.unseen = Integer.valueOf(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean close() throws Imap4Exception {
        boolean ret_code = true;
        Imap4Cmd cmd = null;
        this.imap.setText(String.valueOf(String.valueOf("Closing folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        cmd = this.imap.issueCmd("CLOSE");
        if (cmd.getResult() != 1) {
            throw new Imap4Exception(cmd.getResponse());
        }
        this.open = false;
        ret_code = true;
        this.imap.setText("Folder was closed.");
        return ret_code;
    }

    public Imap4Message[] getMessages() throws Imap4Exception {
        Imap4Message[] msg = new Imap4Message[this.msgs];
        this.imap.setText(String.valueOf(String.valueOf("Retrieving messages for folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        for (int i = 0; i < this.msgs; ++i) {
            this.imap.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(i + 1))).concat(String.valueOf(" of "))).concat(String.valueOf(this.msgs))).concat(String.valueOf("]...")));
            msg[i] = this.getMessage(i + 1);
        }
        this.imap.setText("Message retrieval completed.");
        return msg;
    }

    public Imap4Message getMessage(int num) throws Imap4Exception {
        Imap4Message msg = null;
        Imap4Cmd cmd = null;
        if (num > 0 && num <= this.msgs) {
            cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf("FETCH ").concat(String.valueOf(num))).concat(String.valueOf(" (RFC822.SIZE "))).concat(String.valueOf("UID RFC822.HEADER INTERNALDATE)")));
            if (cmd.getResult() == 1) {
                msg = new Imap4Message(this.imap);
                for (int i = 0; i < cmd.getSize(); ++i) {
                    msg.parseHeader(cmd.get(i));
                }
            } else {
                throw new Imap4Exception(cmd.getResponse());
            }
        }
        return msg;
    }

    public boolean removeMessages() throws Imap4Exception {
        boolean ret_code = false;
        Imap4Cmd cmd = null;
        this.imap.setText(String.valueOf(String.valueOf("Removing messages from folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        cmd = this.imap.issueCmd("EXPUNGE");
        if (cmd.getResult() != 1) {
            this.imap.setText("Message removal failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        ret_code = true;
        this.imap.setText("Messages were removed.");
        return ret_code;
    }

    public Imap4Folder createFolder(String name) throws Imap4Exception {
        Imap4Folder folder = null;
        Imap4Cmd cmd = null;
        this.imap.setText(String.valueOf(String.valueOf("Creating folder [").concat(String.valueOf(name))).concat(String.valueOf("]...")));
        try {
            cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf("CREATE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf(this.imap.getSeparator()))).concat(String.valueOf("\"")));
        }
        catch (Imap4Exception imap4Exception) {
            // empty catch block
        }
        cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf("CREATE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf(this.imap.getSeparator()))).concat(String.valueOf(name))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.imap.setText("Folder creation failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        folder = new Imap4Folder(this.imap, String.valueOf(this.getWholeName()).concat(String.valueOf(this.imap.getSeparator())), name);
        this.imap.setText(String.valueOf(String.valueOf("Folder [").concat(String.valueOf(name))).concat(String.valueOf("] was created successfully.")));
        return folder;
    }

    public Imap4Folder[] getFolders() throws Imap4Exception {
        Imap4Folder[] folder = null;
        if (this.imap.getSeparator() != null) {
            this.imap.setText(String.valueOf(String.valueOf("Reading the list of [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("] subfolders...")));
            Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf("LIST \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\" \""))).concat(String.valueOf(this.imap.getSeparator()))).concat(String.valueOf("%\"")));
            if (cmd.getResult() == 1) {
                int cnt = 0;
                folder = new Imap4Folder[cmd.getSize()];
                for (int i = 0; i < cmd.getSize(); ++i) {
                    if (!cmd.get(i).toUpperCase().startsWith("* LIST ")) continue;
                    folder[cnt++] = new Imap4Folder(this.imap, cmd.get(i));
                }
                Imap4Folder.sortFolders(folder);
            } else {
                throw new Imap4Exception(cmd.getResponse());
            }
        }
        return folder;
    }

    public void delete() throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Deleting folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf("DELETE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.open = false;
            this.imap.setText("Folder delete failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    public void rename(String name) throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Renaming folder [").concat(String.valueOf(this.getName()))).concat(String.valueOf(" to "))).concat(String.valueOf(name))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("RENAME \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\" \""))).concat(String.valueOf(this.getPath()))).concat(String.valueOf(name))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.imap.setText("Rename failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        this.setName(name);
    }

    public void subscribe() throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Subscribing folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf("SUBSCRIBE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.imap.setText("Subscribe failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    public void unsubscribe() throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Unsubscribing folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf("UNSUBSCRIBE \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.imap.setText("Unsubscribe failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    public void append(String[] text) throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Appending to folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        StringBuffer sb = new StringBuffer(1024);
        for (int i = 0; i < text.length; ++i) {
            sb.append(String.valueOf(text[i]).concat(String.valueOf("\r\n")));
        }
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf("APPEND \"").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("\"\r\n"))).concat(String.valueOf(sb.toString())));
        if (cmd.getResult() != 1) {
            this.imap.setText("Message Append failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    public void copyMessages(int[] sel, Imap4Folder nfolder) throws Imap4Exception {
        if (sel.length == 1) {
            this.imap.setText(String.valueOf(String.valueOf("Copying [1] message to folder [").concat(String.valueOf(nfolder.getWholeName()))).concat(String.valueOf("]...")));
        } else {
            this.imap.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Copying [").concat(String.valueOf(sel.length))).concat(String.valueOf("] messages to folder ["))).concat(String.valueOf(nfolder.getWholeName()))).concat(String.valueOf("]...")));
        }
        StringBuffer sb = new StringBuffer(1024);
        for (int i = 0; i < sel.length; ++i) {
            if (i == 0) {
                sb.append(String.valueOf("").concat(String.valueOf(sel[i])));
                continue;
            }
            sb.append(String.valueOf(":").concat(String.valueOf(sel[i])));
        }
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf("COPY ").concat(String.valueOf(sb.toString()))).concat(String.valueOf(" \""))).concat(String.valueOf(nfolder.getWholeName()))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            this.imap.setText("Message copy failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        this.imap.setText("Message copy was successful.");
    }

    public static void sortFolders(Imap4Folder[] folder) {
        if (folder != null && folder.length > 1) {
            for (int i = folder.length - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    Imap4Folder obj1 = folder[j];
                    Imap4Folder obj2 = folder[j + 1];
                    if (obj1.getWholeName().compareTo(obj2.getWholeName()) <= 0) continue;
                    folder[j] = obj2;
                    folder[j + 1] = obj1;
                }
            }
        }
    }

    public int[] getNewMessages() throws Imap4Exception {
        int[] msgs = null;
        this.imap.setText(String.valueOf(String.valueOf("Retrieving new messages from folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd("SEARCH RECENT");
        if (cmd.getResult() != 1) {
            this.imap.setText("Retrieve failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        msgs = this.parseMsgIndexes(cmd);
        this.imap.setText("Retrieve succeeded.");
        return msgs;
    }

    public int[] getUnseenMessages() throws Imap4Exception {
        int[] msgs = null;
        this.imap.setText(String.valueOf(String.valueOf("Retrieving unseen messages from folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd("SEARCH NOT SEEN");
        if (cmd.getResult() != 1) {
            this.imap.setText("Retrieve failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        msgs = this.parseMsgIndexes(cmd);
        this.imap.setText("Retrieve succeeded.");
        return msgs;
    }

    public int[] search(String text) throws Imap4Exception {
        int[] msgs = null;
        this.imap.setText(String.valueOf(String.valueOf("Searching folder [").concat(String.valueOf(this.getWholeName()))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.imap.issueCmd(String.valueOf("SEARCH ").concat(String.valueOf(text)));
        if (cmd.getResult() != 1) {
            this.imap.setText("Search failed.");
            throw new Imap4Exception(cmd.getResponse());
        }
        msgs = this.parseMsgIndexes(cmd);
        this.imap.setText("Search succeeded.");
        return msgs;
    }

    private int[] parseMsgIndexes(Imap4Cmd cmd) {
        Vector<Integer> vector = new Vector<Integer>();
        String val = null;
        String text = null;
        int spot = 0;
        for (int i = 0; i < cmd.getSize(); ++i) {
            text = cmd.get(i);
            if (!text.toUpperCase().startsWith("* SEARCH")) continue;
            text = new String(text.substring(9).trim());
            do {
                if ((spot = text.indexOf(32)) > 0) {
                    val = new String(text.substring(0, spot).trim());
                    text = new String(text.substring(spot + 1).trim());
                } else {
                    val = new String(text);
                }
                try {
                    vector.addElement(Integer.valueOf(val));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (spot > 0);
        }
        int[] msgs = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            msgs[i] = (Integer)vector.elementAt(i);
        }
        return msgs;
    }

    public void parseFolderLine(String sep, String text) {
        int spot = text.lastIndexOf(40);
        String flags = "";
        String subfolder = null;
        if (spot >= 0) {
            flags = new String(text.substring(spot));
            text = new String(text.substring(0, spot).trim());
        }
        if ((spot = text.indexOf(sep)) >= 0) {
            subfolder = new String(text.substring(spot + sep.length()));
            text = new String(text.substring(0, spot));
        }
        Imap4Folder folder = this.findChild(sep, text);
        if (subfolder != null) {
            folder.parseFolderLine(sep, String.valueOf(String.valueOf(subfolder).concat(String.valueOf(" "))).concat(String.valueOf(flags)));
        } else {
            this.parseFlags(flags);
        }
    }

    public Imap4Folder findChild(String sep, String childname) {
        Imap4Folder folder = null;
        for (int i = 0; i < this.child.size(); ++i) {
            if (!((Imap4Folder)this.child.elementAt(i)).getName().equals(childname)) continue;
            folder = (Imap4Folder)this.child.elementAt(i);
            break;
        }
        if (folder == null) {
            String pth = this.getWholeName();
            if (pth.length() != 0) {
                pth = new String(String.valueOf(pth).concat(String.valueOf(sep)));
            }
            folder = new Imap4Folder(this.imap, String.valueOf(String.valueOf(String.valueOf(String.valueOf("* LIST \"").concat(String.valueOf(sep))).concat(String.valueOf("\" "))).concat(String.valueOf(pth))).concat(String.valueOf(childname)));
            this.child.addElement(folder);
        }
        return folder;
    }

    private void parseFlags(String flags) {
        if ((flags = new String(flags.toUpperCase())).indexOf("NOSELECT") >= 0) {
            this.readonly = true;
        }
    }

    public int getChildrenCount() {
        return this.child.size();
    }

    public Imap4Folder getChild(int i) {
        Imap4Folder folder = null;
        if (i >= 0 && i < this.child.size()) {
            folder = (Imap4Folder)this.child.elementAt(i);
        }
        return folder;
    }
}

