/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.CharsetEncode;
import innoval.mailer.Headers;
import innoval.mailer.MimeFile;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileReader;
import innoval.mailer.PopFileWriter;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.jstreet;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class MimeEncode {
    private jstreet Jstreet;
    private File filein;
    private File fileout;
    private Headers headers;
    private String error = null;
    private String encoding = new String("");
    private String charset = new String("");
    private String charsetchars = new String("");
    private String boundary = new String("pIo0sNt1rNo2aOd3mVa4iAl5eLr");
    private Vector hdrVector = new Vector();
    private Vector mimeVector = new Vector();
    private Vector bodyVector = new Vector();
    private Vector addrVector = new Vector();

    MimeEncode(jstreet Jstreet) {
        this.Jstreet = Jstreet;
    }

    public String getError() {
        return this.error;
    }

    public boolean encodeFile(File filein, File fileout) {
        boolean ret_code = true;
        PopFileReader in = new PopFileReader();
        PopFileWriter out = new PopFileWriter();
        this.filein = filein;
        this.fileout = fileout;
        if (in.open(filein)) {
            if (!out.open(fileout)) {
                ret_code = false;
                this.error = new String(String.valueOf(String.valueOf("Error opening output file [").concat(String.valueOf(fileout.getAbsolutePath()))).concat(String.valueOf("]")));
            }
        } else {
            ret_code = false;
            this.error = new String(String.valueOf(String.valueOf("Error opening input file [").concat(String.valueOf(filein.getAbsolutePath()))).concat(String.valueOf("]")));
        }
        if (ret_code) {
            ret_code = this.readHeaders(in);
        }
        if (ret_code) {
            ret_code = this.checkHeaderLines();
        }
        if (ret_code) {
            ret_code = this.formatBody(in);
        }
        if (ret_code) {
            this.encoding = new String(this.headers.getHeaderValue("X-Text-Encoding"));
            this.charset = new String(this.headers.getHeaderValue("X-Charset"));
        }
        if (in.isOpen()) {
            in.close();
        }
        if (ret_code) {
            ret_code = this.mimeVector.size() == 0 ? this.finishNoMime(out) : this.finishWithMime(out);
        } else {
            System.out.println(this.error);
        }
        if (out.isOpen()) {
            out.close();
        }
        return ret_code;
    }

    public boolean readHeaders(PopFileReader in) {
        boolean ret_code = true;
        boolean stillHeaders = true;
        String headerLine = "";
        String line = "";
        boolean headerIndex = false;
        boolean remaining = false;
        this.headers = new Headers();
        this.headers.init();
        while (stillHeaders) {
            line = in.lineIn();
            if (line.trim().length() > 0) {
                switch (line.charAt(0)) {
                    case '\t': 
                    case ' ': {
                        headerLine = String.valueOf(String.valueOf(headerLine).concat(String.valueOf(" "))).concat(String.valueOf(line.trim()));
                        break;
                    }
                    default: {
                        if (headerLine.length() > 0) {
                            this.headers.parse(headerLine, 0);
                        }
                        headerLine = line.trim();
                        break;
                    }
                }
                continue;
            }
            if (headerLine.length() > 0) {
                this.headers.parse(headerLine, 0);
            }
            stillHeaders = false;
        }
        return ret_code;
    }

    public boolean isAddressTag(String line) {
        boolean ret_code = false;
        if (line.equalsIgnoreCase("from") || line.equalsIgnoreCase("to") || line.equalsIgnoreCase("cc") || line.equalsIgnoreCase("bcc") || line.equalsIgnoreCase("reply-to") || line.equalsIgnoreCase("return-receipt-to") || line.equalsIgnoreCase("acknowledge-to")) {
            ret_code = true;
        }
        return ret_code;
    }

    public File processFileNotFound(File file) {
        MsgBox msgbox = new MsgBox((Container)this.Jstreet, String.valueOf(String.valueOf("The specified attachment file [").concat(String.valueOf(file.getAbsolutePath()))).concat(String.valueOf("] was not found.  Would you like to specify another?")), 3);
        if (msgbox.ret_code == 0) {
            FileDialog filedialog = new FileDialog((Frame)this.Jstreet, "Find an Attachment", 0);
            filedialog.setDirectory(file.getPath());
            filedialog.setFile(file.getName());
            filedialog.show();
            if (filedialog.getFile() != null) {
                file = new File(filedialog.getDirectory(), filedialog.getFile());
            }
        }
        return file;
    }

    public static String removeHighChars(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) <= '\u007f') continue;
            text = new String(String.valueOf(String.valueOf(text.substring(0, i)).concat(String.valueOf("_"))).concat(String.valueOf(text.substring(i + 1))));
        }
        return text;
    }

    public String repairString(String text) {
        int tchar = 0;
        int lastchar = 0;
        boolean quotes = false;
        String out = "";
        for (int i = 0; i < text.length(); ++i) {
            tchar = text.charAt(i);
            switch (tchar) {
                case 34: {
                    quotes = !quotes;
                    break;
                }
                case 9: {
                    if (quotes) break;
                    tchar = 32;
                }
            }
            if (quotes || tchar != 32 || lastchar != 32) {
                out = new String(String.valueOf(out).concat(String.valueOf((char)tchar)));
            }
            lastchar = tchar;
        }
        return out;
    }

    public static int verify(String string, String ref, String opt, int start) {
        int spot = 0;
        int out = 0;
        char op = '\u0000';
        if (opt != null && opt.length() > 0) {
            op = opt.toLowerCase().charAt(0);
        }
        for (int i = start; i < string.length(); ++i) {
            spot = ref.indexOf(string.charAt(i));
            if (spot >= 0 && op == 'm') {
                out = i + 1;
                break;
            }
            if (spot >= 0 || op == 'm') continue;
            out = i + 1;
            break;
        }
        return spot;
    }

    public static String translate(String text, String look, String ref) {
        boolean spot = false;
        for (int i = 0; i < look.length(); ++i) {
            if (i >= ref.length()) continue;
            text = new String(text.replace(look.charAt(i), ref.charAt(i)));
        }
        return text;
    }

    public String QuotePrint(String chars, String line) {
        int spot = 0;
        boolean quit = false;
        while (!quit) {
            if ((spot = MimeEncode.verify(line, chars, "M", spot)) == 0) {
                quit = true;
                continue;
            }
            line = new String(String.valueOf(String.valueOf(String.valueOf(line.substring(0, spot)).concat(String.valueOf('='))).concat(String.valueOf(Integer.toHexString(line.charAt(spot))))).concat(String.valueOf(line.substring(spot + 1))));
            spot += 2;
        }
        return line;
    }

    public String strip(String text, String tchar) {
        while (text.startsWith(tchar)) {
            text = new String(text.substring(tchar.length()));
        }
        while (text.endsWith(tchar)) {
            text = new String(text.substring(0, text.length() - tchar.length()));
        }
        return text;
    }

    private boolean checkHeaderLines() {
        boolean ret_code = true;
        boolean text = false;
        File file = null;
        int spot = 0;
        int ind = 0;
        MimeFile mfile = null;
        String line = null;
        String tag = null;
        String tfile = null;
        String remain = null;
        for (int i = 0; i < this.headers.size(0); ++i) {
            line = new String(this.headers.get(0, i));
            tag = line.substring(0, line.indexOf(58));
            remain = line.length() > line.indexOf(58) + 2 ? line.substring(line.indexOf(58) + 2).trim() : new String("");
            if (tag.equalsIgnoreCase("x-attachments")) {
                do {
                    if ((spot = remain.indexOf(9)) >= 0) {
                        tfile = new String(remain.substring(0, spot));
                        remain = new String(remain.substring(spot + 1));
                    } else {
                        tfile = new String(remain);
                    }
                    text = false;
                    ind = tfile.indexOf("<TEXT>");
                    if (ind > 0) {
                        text = true;
                        tfile = new String(tfile.substring(0, ind).trim());
                    }
                    file = new File(tfile);
                    if (text && file.length() > (long)500000) {
                        text = false;
                    }
                    if (!file.exists()) {
                        file = this.processFileNotFound(file);
                    }
                    mfile = new MimeFile(file);
                    mfile.setText(text);
                    if (!file.exists()) continue;
                    this.mimeVector.addElement(mfile);
                } while (spot >= 0);
                continue;
            }
            this.hdrVector.addElement(line);
        }
        if (this.mimeVector.size() == 0) {
            ret_code = false;
        }
        return ret_code;
    }

    public void setCharacterSet() {
        if (this.charset.equalsIgnoreCase("iso-8859-1")) {
            this.charsetchars = new String("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb     \u00c1\u00c2\u00c0\u00a9    \u00a2\u00a5       \u00e3\u00c3       \u00a4\u00f0\u00d0\u00ca\u00cb\u00c8 \u00cd\u00ce\u00cf    \u00a6\u00cc \u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5\u00fe\u00de\u00da\u00db\u00d9\u00fd\u00dd\u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-2")) {
            this.charsetchars = new String("\u00c7\u00fc\u00e9\u00e2\u00e4  \u00e7 \u00eb  \u00ee \u00c4 \u00c9  \u00f4\u00f6    \u00d6\u00dc   \u00d7 \u00e1\u00ed\u00f3\u00fa                 \u00c1\u00c2                        \u00a4\u00f0\u00d0 \u00cb  \u00cd\u00ce        \u00d3\u00df\u00d4      \u00da  \u00fd\u00dd \u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8     \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-3")) {
            this.charsetchars = new String("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0 \u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4 \u00c9  \u00f4\u00f6\u00f2\u00fb\u00f9 \u00d6\u00dc \u00a3 \u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1     \u00bd         \u00c1\u00c2\u00c0                       \u00a4  \u00ca\u00cb\u00c8\u00b9\u00cd\u00ce\u00cf     \u00cc \u00d3\u00df\u00d4\u00d2  \u00b5  \u00da\u00db\u00d9   \u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8\u00b7 \u00b3\u00b2 \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-4")) {
            this.charsetchars = new String(" \u00fc\u00e9\u00e2\u00e4 \u00e5  \u00eb  \u00ee \u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6 \u00fb  \u00d6\u00dc\u00f8 \u00d8\u00d7 \u00e1\u00ed \u00fa                 \u00c1\u00c2               \u00e3\u00c3       \u00a4 \u00d0 \u00cb  \u00cd\u00ce         \u00df\u00d4 \u00f5\u00d5   \u00da\u00db   \u00af\u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8     \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-5")) {
            this.charsetchars = new String("         \u00f1 \u00f7                  \u00e5                                                    \u00a1    \u00a7                       \u00ad    \u00fd         \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-6")) {
            this.charsetchars = new String("                                                                               \u00a4                               \u00ee\u00ad              \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-7")) {
            this.charsetchars = new String("                            \u00a3             \u00ac\u00bd  \u00ab\u00bb        \u00a9                               \u00da    \u00a6   \u00e2    \u00ec       \u00af \u00ad\u00b1   \u00a7  \u00b0\u00a8\u00b7 \u00b3\u00b2 \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-8")) {
            this.charsetchars = new String("                            \u00a3 \u00aa          \u00ae\u00ac\u00bd\u00bc \u00ab\u00bb        \u00a9    \u00a2\u00a5                \u00a4     \u00e1       \u00a6        \u00b5       \u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00ba\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-9")) {
            this.charsetchars = new String("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb     \u00c1\u00c2\u00c0\u00a9    \u00a2\u00a5       \u00e3\u00c3       \u00a4  \u00ca\u00cb\u00c8\u00fd\u00cd\u00ce\u00cf    \u00a6\u00cc \u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5  \u00da\u00db\u00d9  \u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        } else if (this.charset.equalsIgnoreCase("iso-8859-10")) {
            this.charsetchars = new String(" \u00fc\u00e9\u00e2\u00e4 \u00e5  \u00eb \u00ef\u00ee \u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6 \u00fb  \u00d6\u00dc\u00f8 \u00d8  \u00e1\u00ed\u00f3\u00fa                 \u00c1\u00c2               \u00e3\u00c3        \u00f0\u00a9 \u00cb  \u00cd\u00ce\u00cf       \u00d3\u00df\u00d4 \u00f5\u00d5 \u00fe\u00de\u00da\u00db \u00fd\u00dd  \u00ad    \u00a7  \u00b0 \u00b7    \u00a0");
        } else if (this.charset.equalsIgnoreCase("koi8-r")) {
            this.charsetchars = new String("         \u00a3                    \u00c8                 \u0090\u0091\u0092\u0081\u0087   \u00bf\u00b5\u00a1\u00a8\u00ae  \u0083\u0084\u0089\u0088\u0086\u0080\u008a  \u00ab\u00a5\u00bb\u00b8\u00b1\u00a0\u00be    \u00b3     \u0085\u0082\u008d\u008c  \u008b                      \u009f \u009c \u009e  \u009d\u0094\u009a");
        }
    }

    public boolean formatBody(PopFileReader in) {
        String line = "";
        boolean ret_code = true;
        boolean spot = false;
        boolean spot1 = false;
        this.setCharacterSet();
        this.bodyVector.removeAllElements();
        while (line != null) {
            line = in.lineIn();
            if (line == null) continue;
            this.bodyVector.addElement(new String(line));
        }
        if (this.bodyVector.size() == 0) {
            this.bodyVector.addElement(new String(""));
        }
        return ret_code;
    }

    public boolean finishNoMime(PopFileWriter out) {
        boolean ret_code = true;
        for (int i = 0; i < this.hdrVector.size(); ++i) {
            out.lineOut(String.valueOf((String)this.hdrVector.elementAt(i)).concat(String.valueOf("\n")));
        }
        if (this.encoding.trim().length() > 0) {
            out.lineOut("MIME-Version: 1.0\n");
            out.lineOut(String.valueOf(String.valueOf("Content-type: text/plain; charset=").concat(String.valueOf(this.charset))).concat(String.valueOf("\n")));
            out.lineOut(String.valueOf(String.valueOf("Content-transfer-encoding: ").concat(String.valueOf(this.encoding))).concat(String.valueOf("\n")));
        }
        out.lineOut("\n");
        for (int i = 0; i < this.bodyVector.size(); ++i) {
            out.lineOut(String.valueOf((String)this.bodyVector.elementAt(i)).concat(String.valueOf("\n")));
        }
        return ret_code;
    }

    public boolean finishWithMime(PopFileWriter out) {
        boolean ret_code = true;
        String line = null;
        for (int i = 0; i < this.hdrVector.size(); ++i) {
            out.lineOut(String.valueOf((String)this.hdrVector.elementAt(i)).concat(String.valueOf("\n")));
        }
        out.lineOut("MIME-Version: 1.0\n");
        for (int i = 0; i < this.bodyVector.size(); ++i) {
            line = (String)this.bodyVector.elementAt(i);
            if (line.indexOf(String.valueOf("--").concat(String.valueOf(this.boundary))) < 0) continue;
            this.boundary = line.charAt(this.boundary.length() + 2) == 'x' ? new String(String.valueOf(this.boundary).concat(String.valueOf('X'))) : new String(String.valueOf(this.boundary).concat(String.valueOf('x')));
        }
        out.lineOut(String.valueOf(String.valueOf("Content-type: multipart/mixed; boundary=").concat(String.valueOf(this.boundary))).concat(String.valueOf("\n")));
        if (Integer.valueOf(this.Jstreet.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.ENCODESTYLE, "0")) == 2) {
            out.lineOut("Content-transfer-encoding: 8bit\n");
        }
        out.lineOut("\n");
        out.lineOut("This is a multipart message in MIME format.  If you can read this\n");
        out.lineOut("paragraph, your mail program probably does not support MIME messages,\n");
        out.lineOut("and you may not be able to receive the contents of this message in\n");
        out.lineOut("the format intended by the sender.\n");
        out.lineOut(String.valueOf(String.valueOf("\n--").concat(String.valueOf(this.boundary))).concat(String.valueOf("\n")));
        if (this.encoding.trim().length() > 0) {
            out.lineOut(String.valueOf(String.valueOf("Content-type: text/plain; charset=").concat(String.valueOf(this.charset))).concat(String.valueOf("\n")));
            out.lineOut(String.valueOf(String.valueOf("Content-transfer-encoding: ").concat(String.valueOf(this.encoding))).concat(String.valueOf("\n")));
        }
        out.lineOut("\n");
        for (int i = 0; i < this.bodyVector.size(); ++i) {
            out.lineOut(String.valueOf((String)this.bodyVector.elementAt(i)).concat(String.valueOf("\n")));
        }
        out.lineOut(String.valueOf(String.valueOf("\n--").concat(String.valueOf(this.boundary))).concat(String.valueOf("\n")));
        for (int i = 0; i < this.mimeVector.size(); ++i) {
            MimeFile mfile = (MimeFile)this.mimeVector.elementAt(i);
            if (mfile.isText()) {
                this.textPlain(mfile, out, mfile.getFile());
            } else {
                out.lineOut(String.valueOf(String.valueOf("Content-type: application/octet-stream; name=").concat(String.valueOf(mfile.getContentFileName()))).concat(String.valueOf("\n")));
                out.lineOut("Content-transfer-encoding: base64\n");
                out.lineOut(String.valueOf(String.valueOf("Content-disposition: attachment; filename=").concat(String.valueOf(mfile.getContentFileName()))).concat(String.valueOf("\n")));
                out.lineOut("\n");
                this.base64Full(out, mfile.getFile());
            }
            if (i == this.mimeVector.size() - 1) {
                this.boundary = new String(String.valueOf(this.boundary).concat(String.valueOf("--")));
            }
            out.lineOut(String.valueOf(String.valueOf("\n--").concat(String.valueOf(this.boundary))).concat(String.valueOf("\n")));
        }
        return ret_code;
    }

    public void base64Full(PopFileWriter out, File file) {
        String base64chars = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        String fstring = "";
        byte[] readin = new byte[3];
        FileInputStream in = null;
        int read = 0;
        int tchar = 0;
        if (file.exists()) {
            try {
                in = new FileInputStream(file);
                do {
                    if ((read = in.read(readin, 0, 3)) <= 0) continue;
                    tchar = readin[0] >>> 2;
                    fstring = new String(String.valueOf(fstring).concat(String.valueOf(base64chars.charAt(tchar &= 0x3F))));
                    if (read == 1) {
                        readin[1] = 32;
                    }
                    tchar = readin[0] << 4 & 0x30 | readin[1] >>> 4 & 0xF;
                    fstring = new String(String.valueOf(fstring).concat(String.valueOf(base64chars.charAt(tchar &= 0x3F))));
                    if (read > 1) {
                        if (read == 2) {
                            readin[2] = 32;
                        }
                        tchar = readin[1] << 2 & 0xFC | readin[2] >>> 6 & 3;
                        fstring = new String(String.valueOf(fstring).concat(String.valueOf(base64chars.charAt(tchar &= 0x3F))));
                    }
                    if (read > 2) {
                        tchar = readin[2] & 0x3F;
                        fstring = new String(String.valueOf(fstring).concat(String.valueOf(base64chars.charAt(tchar))));
                    }
                    if (fstring.length() <= 75) continue;
                    out.lineOut(String.valueOf(fstring.substring(0, 76)).concat(String.valueOf("\n")));
                    fstring = new String(fstring.substring(76));
                } while (read > 0);
                in.close();
            }
            catch (IOException e) {
                System.out.println(String.valueOf("Error: ").concat(String.valueOf(e)));
            }
        }
        while (fstring.length() % 4 != 0) {
            fstring = new String(String.valueOf(fstring).concat(String.valueOf('=')));
        }
        if (fstring.length() != 0) {
            out.lineOut(String.valueOf(fstring).concat(String.valueOf("\n")));
        }
    }

    public void textPlain(MimeFile mfile, PopFileWriter out, File file) {
        PopFileReader in = new PopFileReader();
        String text = "";
        Vector<String> vector = new Vector<String>();
        if (file.exists() && in.open(file)) {
            while (text != null) {
                text = in.lineIn();
                if (text == null) continue;
                vector.addElement(String.valueOf(text).concat(String.valueOf("\n")));
            }
            in.close();
        }
        CharsetEncode encode = new CharsetEncode(this.Jstreet);
        encode.encodeVector(vector);
        String charset = encode.getCharset();
        String encoding = encode.getEncoding();
        out.lineOut(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Content-type: text/plain; name=").concat(String.valueOf(mfile.getContentFileName()))).concat(String.valueOf("; charset="))).concat(String.valueOf(charset))).concat(String.valueOf("\n")));
        if (encoding.length() > 0) {
            out.lineOut(String.valueOf(String.valueOf("Content-transfer-encoding: ").concat(String.valueOf(encoding))).concat(String.valueOf("\n")));
        }
        out.lineOut(String.valueOf(String.valueOf("Content-disposition: attachment; filename=").concat(String.valueOf(mfile.getContentFileName()))).concat(String.valueOf("\n")));
        out.lineOut("\n");
        for (int i = 0; i < vector.size(); ++i) {
            out.lineOut((String)vector.elementAt(i));
        }
    }
}

