/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderIndexItem;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteWin;
import innoval.mailer.NoteWinLoadVText;
import innoval.mailer.NoteWinText;
import innoval.mailer.NoteWinVFolder;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.jstreet;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;

public class NoteWinVText
extends TextArea
implements MouseListener,
KeyListener {
    private VirtualFolderList parent;
    private BufferedInputStream in;
    private File popfile = null;
    private jstreet Jstreet;
    private NoteWinLoadVText notewinload;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private int bottomCnt = 0;
    private boolean formatState = true;
    private boolean decodeState = true;

    NoteWinVText(VirtualFolderList frame, jstreet Jstreet) {
        this.formatState = false;
        this.initWindow(frame, Jstreet);
    }

    NoteWinVText(VirtualFolderList frame, jstreet Jstreet, boolean formatState) {
        super(new String(""), 1, 1, 1);
        this.formatState = formatState;
        this.initWindow(frame, Jstreet);
    }

    private void initWindow(VirtualFolderList frame, jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.parent = frame;
        this.notewinload = null;
        this.addKeyListener(this);
        this.addMouseListener(this);
        NoteWinText.setupFont(this.formatState, this.fontSize, this);
    }

    public void setHeaderState(int val, Label text) {
        this.headerState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val) {
        this.fontSize = val;
        NoteWinText.setupFont(this.formatState, this.fontSize, this);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFormatState(boolean val, Label text) {
        this.formatState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getFormatState() {
        return this.formatState;
    }

    public void setDecodeState(boolean val, Label text) {
        this.decodeState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public File getFile() {
        return this.popfile;
    }

    public String getPopFile() {
        String pname = "";
        if (this.popfile != null) {
            pname = new String(this.popfile.getName());
        }
        return pname;
    }

    public void mouseClicked(MouseEvent e) {
        String text;
        if (e.getClickCount() == 2 && NoteWinText.isUrl(text = this.getSelectedText())) {
            this.Jstreet.runBrowser(text);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.popfile != null && e.getModifiers() == 4) {
            this.parent.viewPopup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            if (this.goToNextPage()) return;
        }
        int cmd = NoteWin.determineCommand(e, this.Jstreet.textarea.getKeyCmd());
        if (cmd < 0) return;
        this.parent.executeNoteCommand(cmd);
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean goToNextPage() {
        boolean ret_code = true;
        int max = 0;
        int val = 0;
        int left = max - val;
        int page = 0;
        if (left <= page) {
            if (this.bottomCnt > 0 || max <= page) {
                this.bottomCnt = 0;
                ret_code = false;
            } else {
                ++this.bottomCnt;
            }
        } else {
            this.bottomCnt = 0;
        }
        return ret_code;
    }

    public void clear() {
        this.stopLoading();
        this.setVisible(false);
        this.setText("");
        this.setVisible(true);
        NoteWinVFolder.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        this.popfile = null;
    }

    public void updateTitle(String title) {
    }

    public void stopLoading() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
    }

    public void load(File file, Label text) {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.popfile = file;
        this.notewinload = new NoteWinLoadVText(this, text);
        this.notewinload.start();
    }

    public void reload() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.notewinload = new NoteWinLoadVText(this, null);
        this.notewinload.start();
    }

    public synchronized void loadNote(NoteWinLoadVText thread) {
        PopFileProcedure pop = null;
        FolderIndexItem item = null;
        thread.setText("Loading message...");
        this.setVisible(false);
        NoteWinVFolder.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        ++this.reloads;
        if (this.reloads % 5 == 0) {
            System.gc();
        }
        if (!thread.getStop()) {
            pop = new PopFileProcedure();
            thread.setPopFileProcedure(pop);
            pop.setAttachDir(this.parent.getAttachDir());
            pop.setHtml(false);
            pop.setHeaderState(this.headerState);
            pop.setDecode(this.decodeState);
            pop.setFormat(this.formatState);
            pop.setHtmlFontSize(this.fontSize);
        }
        if (!thread.getStop()) {
            item = this.parent.getSelectedMessage();
            if (item != null && item.getNotes().length() > 0) {
                pop.setStickyNotes(true);
            } else {
                pop.setStickyNotes(false);
            }
        }
        if (!thread.getStop() && this.popfile != null) {
            if (this.popfile.exists()) {
                pop.readFile(this.Jstreet, this.popfile.getAbsolutePath());
                if (item != null && !thread.getStop() && pop.countAttachments() > 0 && !item.getAttach()) {
                    item.setAttach(true);
                    this.parent.notelist.setDirty();
                    this.parent.notelist.refreshCurrentMessage();
                }
            } else {
                MsgBox msgBox = new MsgBox(this.parent, String.valueOf(String.valueOf("The selected message file [").concat(String.valueOf(this.popfile.getAbsolutePath()))).concat(String.valueOf("] was not found.")));
            }
        }
        if (!thread.getStop()) {
            this.parent.attachbar.setup(this.parent.getAttachDir());
        }
        if (!thread.getStop()) {
            if (this.popfile.exists()) {
                this.setText(pop.getPopText());
            } else {
                this.setText("");
            }
            try {
                this.setCaretPosition(0);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
            this.setVisible(true);
        }
        this.parent.validateMessageWindow();
        if (thread.getStop()) {
            this.clear();
        }
        this.notewinload = null;
        pop = null;
        thread.setText("");
        this.requestFocus();
    }

    public int removeChar(byte[] text, int bytes, char tchar) {
        int cnt = 0;
        for (int i = 0; i < bytes; ++i) {
            if (text[i] == (byte)tchar) continue;
            text[cnt++] = text[i];
        }
        for (int i = cnt; i < bytes; ++i) {
            text[i] = 0;
        }
        return cnt;
    }
}

