/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class RegisterCode
extends Dialog
implements KeyListener,
ActionListener {
    static final int ADD_VALUE = 38176275;
    static final int MULT_VALUE = 454;
    private String lic;
    private Frame parent;
    private Button okButton;
    private Button cancelButton;
    private TextField licField;

    RegisterCode(Frame parent) {
        super(parent, "Register This Software", true);
        this.parent = parent;
        this.initDialog();
        this.show();
    }

    private void initDialog() {
        Label label = null;
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 100, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        label = new Label("License Number", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.licField = new TextField("", 8);
        this.licField.setColumns(8);
        this.licField.addKeyListener(this);
        this.add(this.licField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.licField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Register Later");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, null);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.validLicNumber(this.licField.getText().trim())) {
                this.lic = new String(this.licField.getText().trim());
                this.close();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    private boolean validLicNumber(String text) {
        boolean ret_code = false;
        if ((text = this.cleanString(text)).length() > 0) {
            if (text.length() > 8) {
                text = new String(text.substring(text.length() - 8));
            }
            double chk = 0.0;
            try {
                chk = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            chk = (chk - (double)38176275) / (double)454;
            text = new String(String.valueOf("").concat(String.valueOf(chk)));
            if (text.indexOf(46) < 0 || this.allZeros(text.substring(text.indexOf(46) + 1))) {
                ret_code = true;
            } else {
                MsgBox msg = new MsgBox(this.parent, "The specified value is not a valid license number.");
                this.licField.requestFocus();
            }
        } else {
            MsgBox msg = new MsgBox(this.parent, "Please enter a license number.");
            this.licField.requestFocus();
        }
        return ret_code;
    }

    private boolean allZeros(String text) {
        boolean ret_code = true;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '0') continue;
            ret_code = false;
        }
        return ret_code;
    }

    public String cleanString(String text) {
        int spot = 0;
        text = new String(text.replace('-', ' ').trim());
        do {
            if ((spot = text.indexOf(32)) <= 0) continue;
            text = new String(String.valueOf(text.substring(0, spot)).concat(String.valueOf(text.substring(spot + 1))));
        } while (spot > 0);
        return text;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void close() {
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getLic() {
        return this.lic;
    }
}

