/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.AddressBook;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class SelectAddressBook
extends Dialog
implements KeyListener,
ActionListener {
    private jstreet Jstreet;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button deleteButton;
    private String bookName;
    private List list;
    private Vector bvector = null;

    SelectAddressBook(Frame frame, jstreet Jstreet) {
        super(frame, "Open an Address Book", true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.bvector = new Vector();
        AddrBook.loadAddressBookVector(this.bvector, Jstreet);
        this.setupDialog();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{150, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 150, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new List();
        this.list.addActionListener(this);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 7;
        grid.setConstraints(this.list, con);
        for (int i = 0; i < this.bvector.size(); ++i) {
            this.list.add(((AddressBook)this.bvector.elementAt(i)).getTitle());
        }
        if (this.list.getItemCount() > 0) {
            this.list.select(0);
        }
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        grid.setConstraints(this.cancelButton, con);
        this.deleteButton = new Button("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.addKeyListener(this);
        this.add(this.deleteButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.deleteButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
        this.show();
    }

    public String getName() {
        return this.bookName;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton || e.getSource() == this.list) {
            int item = this.list.getSelectedIndex();
            if (item >= 0) {
                this.bookName = new String(((AddressBook)this.bvector.elementAt(item)).getFileName());
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "No address book is selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.deleteButton) {
            int item = this.list.getSelectedIndex();
            if (item >= 0) {
                MsgBox msg = new MsgBox((Container)this.frame, "Delete the selected address book?", 3);
                if (msg.ret_code == 0) {
                    File file = new File(((AddressBook)this.bvector.elementAt(item)).getFileName());
                    if (file.exists()) {
                        file.delete();
                    }
                    this.bvector.removeElementAt(item);
                    this.list.remove(item);
                }
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "No address book is selected.");
            }
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

