/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AutoRefresh;
import innoval.mailer.ConnectSocketThread;
import innoval.mailer.FolderItem;
import innoval.mailer.Last15;
import innoval.mailer.MsgBox;
import innoval.mailer.NewsPost;
import innoval.mailer.PopFilter;
import innoval.mailer.PostSmtpMessages;
import innoval.mailer.Profile;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class Smtp {
    private jstreet parent;
    private boolean active;
    private boolean quit = false;
    private Profile profile;
    private NewsPost post = null;
    private FolderItem outbasket;
    private FolderItem trash;
    private String server1;
    private String server2;
    private int connectTime = 60;
    private int port1 = 25;
    private int port2 = 25;
    private File currentPopfile;
    private PostSmtpMessages postsmtpMessages;
    private SendItem senditem;
    private Socket socket;
    private Label text;
    private BufferedReader in;
    private DataOutputStream out;

    Smtp(jstreet parent, Profile profile, FolderItem outbasket, FolderItem trash) {
        this.parent = parent;
        this.profile = profile;
        this.outbasket = outbasket;
        this.trash = trash;
        this.text = parent.text;
        this.server1 = profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPSERVER1, "");
        String val = profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPPORT1, "25");
        if (this.isNumeric(val)) {
            this.port1 = Integer.valueOf(val);
        }
        this.server2 = profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPSERVER2, "");
        val = profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPPORT2, "25");
        if (this.isNumeric(val)) {
            this.port2 = Integer.valueOf(val);
        }
        try {
            this.connectTime = Integer.valueOf(profile.ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
        this.active = true;
    }

    public boolean isNumeric(String val) {
        boolean ret_code = true;
        String check = "0123456789.";
        if (val.trim().length() > 0) {
            String text = val.trim();
            for (int i = 0; i < text.length(); ++i) {
                if (check.indexOf(text.charAt(i)) >= 0) continue;
                ret_code = false;
                break;
            }
        } else {
            ret_code = false;
        }
        return ret_code;
    }

    public void send(File popfile) {
        this.currentPopfile = popfile;
        this.postsmtpMessages = new PostSmtpMessages(this);
        this.postsmtpMessages.start();
    }

    public void sendMessages() {
        boolean ret_code = true;
        boolean go = false;
        boolean connect = false;
        String[] names = new String[1];
        Vector addr = null;
        File popfile = null;
        int num = 0;
        jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDEXIT);
        if (!this.quit) {
            if (this.currentPopfile != null) {
                names[0] = new String(this.currentPopfile.getName());
            } else {
                names = this.outbasket.getPath().list(new PopFilter());
            }
            for (int i = 0; i < names.length; ++i) {
                num = i + 1;
                this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Sending message [").concat(String.valueOf(num))).concat(String.valueOf(" of "))).concat(String.valueOf(names.length))).concat(String.valueOf("]...")));
                if (!this.quit) {
                    popfile = new File(this.outbasket.getPath(), names[i]);
                    this.senditem = new SendItem(this.parent, popfile, this.outbasket, this.trash);
                    this.senditem.setTextWindow(this.text);
                    addr = this.senditem.getAddresses();
                    go = true;
                    if (addr.size() > 0) {
                        if (!connect) {
                            connect = this.connect();
                        }
                        if (connect) {
                            if (!this.uploadMessage(this.senditem, popfile)) {
                                ret_code = false;
                                go = false;
                            }
                        } else {
                            this.quit = true;
                        }
                    }
                    if (!this.quit && go && this.senditem.isNewsItem()) {
                        this.post = new NewsPost(this.parent, this.senditem, popfile);
                        ret_code = this.post.uploadMessage();
                        this.post = null;
                    }
                }
                if (this.quit || !ret_code) break;
                this.senditem.fileMessage();
            }
            if (connect) {
                this.disconnect();
            }
            if (this.quit) {
                this.text.setText("Message upload was halted.");
            } else if (ret_code) {
                if (names.length == 1) {
                    this.text.setText("Your message was sent successfully.");
                } else {
                    this.text.setText("Your messages were sent successfully.");
                }
            } else if (names.length == 1) {
                this.text.setText("Errors occurred sending your message.");
            } else {
                this.text.setText("Errors occurred sending your messages.");
            }
        }
        this.active = false;
        jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDFEXIT);
        this.parent.SendComplete();
    }

    public boolean active() {
        return this.active;
    }

    public void breakSend() {
        if (this.postsmtpMessages != null) {
            this.text.setText("Issuing halt request to the send process...");
            this.quit = true;
            if (this.senditem != null) {
                this.senditem.setQuit(true);
            }
            if (this.post != null) {
                this.post.setQuit(true);
            }
            this.postsmtpMessages = null;
        }
    }

    public boolean connect() {
        boolean ret_code = false;
        ret_code = this.tryConnect(this.server1, this.port1);
        if (!ret_code && !this.quit && this.server2.length() > 0) {
            ret_code = this.tryConnect(this.server2, this.port2);
        }
        return ret_code;
    }

    public void disconnect() {
        if (!this.quit) {
            String string = this.issueSmtpCommand("quit");
        } else {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean tryConnect(String server, int port) {
        boolean ret_code;
        block5: {
            ret_code = false;
            this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Connecting to server...").concat(String.valueOf(server))).concat(String.valueOf(" ["))).concat(String.valueOf(port))).concat(String.valueOf("]")));
            try {
                this.socket = this.connectSocket(this.text, server, port);
                if (this.socket != null) {
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    String inchar = this.getSmtpResponse();
                    if (inchar.startsWith("220")) {
                        this.out = new DataOutputStream(this.socket.getOutputStream());
                        InetAddress addr = this.socket.getLocalAddress();
                        this.issueSmtpCommand(String.valueOf("HELO ").concat(String.valueOf(addr.getHostName())));
                        this.text.setText("Connection established...");
                        ret_code = true;
                    } else {
                        MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Unexpected response from SMTP server: ").concat(String.valueOf(inchar)));
                    }
                }
            }
            catch (IOException e) {
                MsgBox box = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
            }
            if (ret_code) break block5;
            this.text.setText("Error connecting to SMTP server.");
        }
        return ret_code;
    }

    public Socket connectSocket(Label text, String server, int port) {
        Socket socket = null;
        ConnectSocketThread thread = new ConnectSocketThread(this.parent, server, port);
        String oldText = text.getText();
        try {
            thread.start();
            for (int i = this.connectTime; i > 0; --i) {
                thread.join(1000L);
                text.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                if (!thread.isAlive() || this.quit) break;
            }
            text.setText(oldText);
            if (thread.isAlive()) {
                thread.stop();
                if (!this.quit) {
                    MsgBox msgBox = new MsgBox(this.parent, String.valueOf(String.valueOf("Connection attempt timed out after ").concat(String.valueOf(this.connectTime))).concat(String.valueOf(" seconds.")));
                }
            }
            socket = thread.getSocket();
        }
        catch (InterruptedException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return socket;
    }

    public String getSmtpResponse() {
        String inchar = new String("");
        try {
            inchar = this.in.readLine();
            while (inchar != null && inchar.length() > 3 && inchar.charAt(3) == '-') {
                inchar = this.in.readLine();
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return inchar;
    }

    public String issueSmtpCommand(String text) {
        int errcnt = 0;
        String inchar = new String("");
        int tchar = 0;
        try {
            do {
                this.out.writeBytes(String.valueOf(text).concat(String.valueOf("\r\n")));
                inchar = this.getSmtpResponse();
                try {
                    tchar = inchar != null && inchar.length() > 0 ? (int)inchar.charAt(0) : 0;
                }
                catch (StringIndexOutOfBoundsException e) {
                    tchar = 0;
                }
                if (tchar != 52) continue;
                ++errcnt;
            } while (errcnt < 3 && tchar == 52);
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return inchar;
    }

    public boolean uploadMessage(SendItem senditem, File popfile) {
        if (senditem.addrapproach == 0) {
            return this.uploadSingleMessage(senditem, popfile);
        }
        return this.uploadMultipleMessage(senditem, popfile);
    }

    private boolean uploadMultipleMessage(SendItem senditem, File popfile) {
        boolean ret_code = true;
        String inchar = "";
        Vector addr = senditem.getAddresses();
        String oldText = this.text.getText();
        if (addr.size() > 1) {
            this.text.setText(String.valueOf(oldText).concat(String.valueOf("Sending to addressees 1 at a time.")));
            AutoRefresh.Sleep(1000L);
        }
        for (int i = 0; i < addr.size(); ++i) {
            MsgBox msgBox;
            this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf("Working on addressee ["))).concat(String.valueOf(i + 1))).concat(String.valueOf(" of "))).concat(String.valueOf(addr.size()))).concat(String.valueOf("] "))).concat(String.valueOf((String)addr.elementAt(i))));
            if (!this.quit) {
                String from = senditem.getFrom();
                if (from.length() == 0) {
                    from = senditem.getReply();
                }
                if (!(inchar = this.issueSmtpCommand(String.valueOf("MAIL FROM: ").concat(String.valueOf(this.removeName(from))))).startsWith("250") && !inchar.startsWith("251")) {
                    ret_code = false;
                    msgBox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
                }
            }
            if (!this.quit && ret_code && !(inchar = this.issueSmtpCommand(String.valueOf("RCPT TO: ").concat(String.valueOf(this.removeName((String)addr.elementAt(i)))))).startsWith("250") && !inchar.startsWith("251")) {
                ret_code = false;
                MsgBox msgbox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
                break;
            }
            if (!this.quit && ret_code && !(inchar = this.issueSmtpCommand("DATA")).startsWith("354")) {
                ret_code = false;
            }
            if (!this.quit && ret_code) {
                senditem.setAddress((String)addr.elementAt(i));
                ret_code = senditem.uploadMessage(this.out, popfile, false, true, false);
                if (!this.quit && ret_code) {
                    inchar = this.issueSmtpCommand(".");
                    if (inchar.startsWith("250") || inchar.startsWith("251")) continue;
                    ret_code = false;
                    msgBox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
                    continue;
                }
                if (ret_code) continue;
                msgBox = new MsgBox(this.parent, "SMTP Error uploading message text.");
                continue;
            }
            if (ret_code) continue;
            msgBox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
        }
        return ret_code;
    }

    private boolean uploadSingleMessage(SendItem senditem, File popfile) {
        boolean ret_code = true;
        String inchar = "";
        String oldText = this.text.getText();
        Vector addr = senditem.getAddresses();
        if (addr.size() > 1) {
            this.text.setText(String.valueOf(oldText).concat(String.valueOf("Sending message to all addressees.")));
            AutoRefresh.Sleep(1000L);
        }
        if (!this.quit) {
            String from = senditem.getFrom();
            if (from.length() == 0) {
                from = senditem.getReply();
            }
            this.text.setText(String.valueOf(oldText).concat(String.valueOf("Addressing message.")));
            inchar = this.issueSmtpCommand(String.valueOf("MAIL FROM: ").concat(String.valueOf(this.removeName(from))));
            if (!inchar.startsWith("250") && !inchar.startsWith("251")) {
                ret_code = false;
            }
        }
        if (!this.quit && ret_code) {
            this.text.setText(String.valueOf(oldText).concat(String.valueOf("Adding recipients.")));
            String person = null;
            for (int i = 0; i < addr.size(); ++i) {
                person = (String)addr.elementAt(i);
                this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf("Adding recipient ["))).concat(String.valueOf(i + 1))).concat(String.valueOf(" of "))).concat(String.valueOf(addr.size()))).concat(String.valueOf("] "))).concat(String.valueOf(person)));
                inchar = this.issueSmtpCommand(String.valueOf("RCPT TO: ").concat(String.valueOf(this.removeName(person))));
                if (inchar.startsWith("250") || inchar.startsWith("251")) continue;
                ret_code = false;
                break;
            }
        }
        if (!this.quit && ret_code && !(inchar = this.issueSmtpCommand("DATA")).startsWith("354")) {
            ret_code = false;
        }
        if (!this.quit && ret_code) {
            this.text.setText(String.valueOf(oldText).concat(String.valueOf("Sending message text.")));
            ret_code = senditem.uploadMessage(this.out, popfile, false, true, false);
            if (!this.quit && ret_code) {
                this.text.setText(String.valueOf(oldText).concat(String.valueOf("Completing message.")));
                inchar = this.issueSmtpCommand(".");
                if (!inchar.startsWith("250") && !inchar.startsWith("251")) {
                    ret_code = false;
                    MsgBox msgbox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
                } else {
                    this.text.setText(String.valueOf(oldText).concat(String.valueOf("Message completed.")));
                }
            } else if (!ret_code) {
                MsgBox msgBox = new MsgBox(this.parent, "SMTP Error uploading message text.");
            }
        } else if (!ret_code) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("SMTP Error: ").concat(String.valueOf(inchar)));
        }
        return ret_code;
    }

    public String removeName(String text) {
        String tchar = null;
        String pchar = null;
        String tname = null;
        String ttext = null;
        String taddr = null;
        String addr = new String("");
        int spot = 0;
        Vector vector = Last15.parseAddresses(text);
        for (int i = 0; i < vector.size(); ++i) {
            ttext = (String)vector.elementAt(i);
            if (ttext.toLowerCase().startsWith("to:") || ttext.toLowerCase().startsWith("cc:") || ttext.toLowerCase().startsWith("bcc:") || ttext.toLowerCase().startsWith("news:")) {
                spot = ttext.indexOf(58);
                ttext = new String(ttext.substring(spot + 2).trim());
            }
            if ((spot = ttext.indexOf(40)) >= 0) {
                tchar = new String(ttext.substring(spot));
                ttext = new String(ttext.substring(0, spot));
                spot = tchar.indexOf(41);
                if (spot >= 0) {
                    pchar = new String(tchar.substring(spot + 1));
                    tname = new String(String.valueOf(ttext).concat(String.valueOf(pchar)));
                } else {
                    tname = new String(ttext);
                }
                taddr = new String(tname);
                ttext = new String(taddr);
            }
            if ((spot = ttext.indexOf(60)) >= 0) {
                tchar = new String(ttext.substring(spot + 1));
                if ((spot = tchar.indexOf(62)) >= 0) {
                    tchar = new String(tchar.substring(0, spot));
                }
                taddr = new String(tchar);
            } else {
                taddr = new String(ttext);
            }
            if (addr.length() > 0) {
                addr = new String(String.valueOf(addr).concat(String.valueOf(",")));
            }
            addr = new String(String.valueOf(String.valueOf(String.valueOf(addr).concat(String.valueOf("<"))).concat(String.valueOf(taddr))).concat(String.valueOf(">")));
        }
        return addr;
    }

    public static byte[] toByteArray(String text) {
        char[] chars = text.toCharArray();
        byte[] bytes = new byte[chars.length];
        char val = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            val = chars[i];
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }
}

