/*
 * Decompiled with CFR 0.152.
 */
package jspell.spellchecker;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;

public class j_util {
    public static byte i;
    public static byte curchar;
    public static byte decompChar;
    public static byte accumulator;
    public static byte aCurbit;
    public static byte wCurbit;
    public static int inLen;
    public static String out;
    public static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final char[] SoundexTable;

    public static void centerDialog(Dialog d, Frame f) {
        Dimension screen = f.getToolkit().getScreenSize();
        int dWidth = d.getSize().width;
        int dHeight = d.getSize().height;
        int xPos = f.getLocation().x + f.getSize().width / 2 - dWidth / 2;
        int yPos = f.getLocation().y + f.getSize().height / 2 - dHeight / 2;
        if (xPos < 0) {
            xPos = 10;
        }
        if (yPos < 0) {
            yPos = 10;
        }
        if (xPos + dWidth > screen.width) {
            xPos = screen.width - dWidth - 10;
        }
        if (yPos + dHeight > screen.height) {
            yPos = screen.height - dHeight - 10;
        }
        ((Component)d).setBounds(xPos, yPos, dWidth, dHeight);
    }

    public static String compWord(String in) {
        out = "";
        accumulator = 0;
        aCurbit = (byte)7;
        in = in.toUpperCase();
        inLen = in.length();
        for (i = 0; i < inLen; i = (byte)(i + 1)) {
            curchar = (byte)in.charAt(i);
            if (curchar < 65 || curchar > 90) {
                return "";
            }
            curchar = (byte)(curchar - 64);
            for (wCurbit = (byte)4; wCurbit >= 0; wCurbit = (byte)(wCurbit - 1)) {
                if (aCurbit < 0) {
                    out = String.valueOf(out).concat(String.valueOf((char)accumulator));
                    accumulator = 0;
                    aCurbit = (byte)7;
                }
                accumulator = (byte)(accumulator + ((int)Math.pow(2.0, aCurbit) * ((int)Math.pow(2.0, wCurbit) & curchar) >>> wCurbit));
                aCurbit = (byte)(aCurbit - 1);
            }
        }
        if (accumulator != 0) {
            out = String.valueOf(out).concat(String.valueOf((char)accumulator));
        }
        return out;
    }

    public static String decompWord(String in) {
        out = "";
        accumulator = 0;
        aCurbit = (byte)4;
        inLen = in.length();
        for (i = 0; i < inLen; i = (byte)(i + 1)) {
            decompChar = (byte)in.charAt(i);
            for (wCurbit = (byte)7; wCurbit >= 0; wCurbit = (byte)(wCurbit - 1)) {
                if (aCurbit < 0 && accumulator != 0) {
                    out = String.valueOf(out).concat(String.valueOf((char)(accumulator + 64)));
                    accumulator = 0;
                    aCurbit = (byte)4;
                }
                accumulator = (byte)(accumulator + ((int)Math.pow(2.0, aCurbit) * ((int)Math.pow(2.0, wCurbit) & decompChar) >>> wCurbit));
                aCurbit = (byte)(aCurbit - 1);
            }
        }
        if (accumulator != 0) {
            out = String.valueOf(out).concat(String.valueOf((char)(accumulator + 64)));
        }
        return out;
    }

    public static double soundexsim(String x, String y) {
        return j_util.eqscore(j_util.soundex(x, false), j_util.soundex(y, false));
    }

    public static double eqscore(String x, String y) {
        return j_util.eqscore(x, y, 'E');
    }

    public static double eqscore(String x, String y, char weightmode) {
        double score = 0.0;
        if ((x = x.toUpperCase().trim()).equals(y = y.toUpperCase().trim())) {
            score = 1.0;
        } else if (x.equals("") || y.equals("")) {
            score = 0.0;
        } else {
            double tweight = 0.0;
            double weight = 0.0;
            int matches = 0;
            int inserts = 0;
            int transposes = 0;
            if (x.length() > y.length()) {
                String temp = new String(x);
                x = y;
                y = temp;
                temp = null;
            }
            StringBuffer xbuf = new StringBuffer(x);
            StringBuffer ybuf = new StringBuffer(y);
            int xlen = xbuf.length();
            int ylen = ybuf.length();
            tweight = j_util.addseries(ylen);
            for (int i = 0; i < xlen; ++i) {
                if (weightmode == 'F') {
                    weight = (double)(ylen - i) / tweight;
                } else if (weightmode == 'E') {
                    weight = 1.0 / (double)ylen;
                }
                if (xbuf.charAt(i) == ybuf.charAt(i)) {
                    ++matches;
                    score += weight;
                    continue;
                }
                if (xlen - 1 > i && xlen != ylen && xbuf.charAt(i) == ybuf.charAt(i + 1) && xbuf.charAt(i + 1) != ybuf.charAt(i + 1)) {
                    ++inserts;
                    xbuf.insert(i, ybuf.charAt(i + 1));
                    ++xlen;
                    continue;
                }
                if (xlen - 1 <= i || xbuf.charAt(i + 1) != ybuf.charAt(i) && ybuf.charAt(i + 1) != xbuf.charAt(i)) continue;
                if (xbuf.charAt(i + 1) == ybuf.charAt(i) && ybuf.charAt(i + 1) == xbuf.charAt(i)) {
                    score += weight / (double)2;
                }
                ++transposes;
                char temp = xbuf.charAt(i);
                xbuf.setCharAt(i, xbuf.charAt(i + 1));
                xbuf.setCharAt(i + 1, temp);
            }
        }
        return score;
    }

    public static double factorial(int n) {
        return n > 1 ? (double)n * j_util.factorial(n - 1) : 1.0;
    }

    public static double addseries(int n) {
        return n > 1 ? (double)n + j_util.addseries(n - 1) : 1.0;
    }

    public static String soundex(String in) {
        return j_util.soundex(in, true);
    }

    public static String soundex(String in, boolean padcode) {
        int spot;
        char curchar;
        int count = 0;
        char prevcode = ' ';
        StringBuffer code = new StringBuffer("    ");
        String toconvert = in.toUpperCase();
        for (int i = 0; i < toconvert.length() && count < 4 && Character.isLetter(curchar = toconvert.charAt(i)) && (spot = alphabet.indexOf(curchar)) >= 0; ++i) {
            char thiscode = SoundexTable[alphabet.indexOf(curchar)];
            if (count == 0) {
                code.setCharAt(count, curchar);
                ++count;
                prevcode = ' ';
                continue;
            }
            if (thiscode != prevcode && thiscode != '0') {
                code.setCharAt(count, thiscode);
                ++count;
            }
            prevcode = thiscode;
        }
        if (padcode) {
            while (count < 4) {
                code.setCharAt(count, '0');
                ++count;
            }
        }
        return code.toString();
    }

    public static void main(String[] args) {
        int similarity = (int)(j_util.eqscore(args[0], args[1]) * (double)100);
        int soundexsim = (int)(j_util.soundexsim(args[0], args[1]) * (double)100);
        int avgsim = (similarity + soundexsim) / 2;
        System.out.println(String.valueOf("   Plain Similarity: ").concat(String.valueOf(similarity)));
        System.out.println(String.valueOf("Phonetic Similarity: ").concat(String.valueOf(soundexsim)));
        System.out.println(String.valueOf(" Average Similarity: ").concat(String.valueOf(avgsim)));
    }

    static {
        SoundexTable = new char[]{'0', '1', '2', '3', '0', '1', '2', '0', '0', '2', '2', '4', '5', '5', '0', '1', '2', '6', '2', '3', '0', '1', '0', '2', '0', '2'};
    }
}

