/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceBoard;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceProperties;
import com.jthomas.javafaces.FaceScrollablePanel;
import com.jthomas.javafaces.FaceServer;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.MailList;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.util.Debug;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class FaceFrame
extends Frame {
    private FaceScrollablePanel _ScrollPanel;
    private Panel _FacePanel;
    private FaceStatusLabel _Status;
    private MenuBar _MBar;
    private JavaFaces _JavaFaces;
    private FaceOptions _Options;
    private FaceProperties _Properties;
    private FaceBoard _FaceBoard;
    private boolean _NoMailIcon;
    private int _Width;
    private int _WidthOld;
    private int _HeightOld;
    private int _Height;
    private Point _Location;
    private CheckboxMenuItem _Audio;
    private CheckboxMenuItem _Statusbox;
    private CheckboxMenuItem _Debugbox;
    private MenuItem[] _ServerMenuItems;
    private MenuItem _DelayLongOn;
    private MenuItem _DelayLongOff;
    private MailList _MailList;

    FaceFrame(FaceBoard faceboard) {
        super("JavaFaces");
        this._FaceBoard = faceboard;
        this._Options = FaceOptions.getRef();
        this._Properties = FaceProperties.getRef();
        this._JavaFaces = JavaFaces.getRef();
        this._Status = new FaceStatusLabel();
        this.addWindowListener(new 1());
        this.addComponentListener(new 2());
        this.setup();
    }

    public void setup() {
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(250, 60);
        this._MBar = new MenuBar();
        this.InitializeMenus(this._MBar);
        this.setMenuBar(this._MBar);
        this.add("Center", this._FaceBoard);
        FaceStatusLabel.setStatusFlag(true);
        this._Status.setVisible(true);
        this.add("South", this._Status);
        int x = Integer.parseInt(this._Properties.getProperty("FaceFrameX", "10"));
        int y = Integer.parseInt(this._Properties.getProperty("FaceFrameY", "10"));
        ((Component)this).setLocation(x, y);
        this._Location = this.getLocation();
        Dimension d = this.getMinimumSize();
        ((Component)this).setSize(d);
        this.pack();
        d = this.getMinimumSize();
        ((Component)this).setSize(d);
        this.show();
        this._HeightOld = d.height;
        this._WidthOld = d.width;
    }

    void handleMove() {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        Debug.out("FaceFrame.handleMove():  at " + location);
        if (!location.equals(this._Location)) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Debug.out(screen);
            if (location.x >= screen.width || location.x + size.width < 0 || location.y >= screen.height || location.y + size.height < 0) {
                return;
            }
            ((Hashtable)this._Properties).put("FaceFrameX", String.valueOf(location.x));
            ((Hashtable)this._Properties).put("FaceFrameY", String.valueOf(location.y));
            this._Properties.save();
            Debug.out("Properties updated to " + location);
            this._Location = location;
        }
    }

    void handleResize() {
        Dimension size = this.getSize();
        Debug.out("FaceFrame.handleResize(): " + size);
        Graphics g = this._FaceBoard.getGraphics();
        this._FaceBoard.paint(g);
        this.validate();
    }

    public synchronized void xxpaint(Graphics g) {
        Dimension d = this.getSize();
        int width = d.width;
        int height = d.height;
        if (width == 0 || width == this._WidthOld) {
            super.paint(g);
            return;
        }
        this._FaceBoard.paint(g);
        this.validate();
    }

    public void setCursorBusy(boolean busy) {
        if (busy) {
            this._FaceBoard.setCursor(new Cursor(3));
        } else {
            this._FaceBoard.setCursor(new Cursor(0));
        }
    }

    private void InitializeMenus(MenuBar mbar) {
        MenuItem mi = null;
        Menu m = new Menu("File");
        Menu serverMenu = new Menu("Servers");
        int n = FaceServer.getCount();
        if (n > 1) {
            this._ServerMenuItems = new MenuItem[n];
            int i = 0;
            while (i < n) {
                String name = FaceServer.getList()[i].getName();
                this._ServerMenuItems[i] = new MenuItem(name);
                serverMenu.add(this._ServerMenuItems[i]);
                int servernumber = i;
                this._ServerMenuItems[i].addActionListener(new 3(servernumber));
                ++i;
            }
        } else {
            serverMenu.setEnabled(false);
        }
        m.add(serverMenu);
        mi = new MenuItem("Check for new Mail");
        m.add(mi);
        mi.addActionListener(new 4());
        mi = new MenuItem("Verify Icon Selection");
        m.add(mi);
        mi.addActionListener(new 5());
        mi = new MenuItem("Reset");
        m.add(mi);
        mi.addActionListener(new 6());
        m.addSeparator();
        mi = new MenuItem("Exit");
        m.add(mi);
        mi.addActionListener(new 7());
        mbar.add(m);
        m = new Menu("Options");
        mi = new MenuItem("Refresh");
        m.add(mi);
        mi.addActionListener(new 8());
        this._Audio = new CheckboxMenuItem("Audio");
        this._Audio.setState(this._Options.get("AudioSupport", "false").equals("true"));
        m.add(this._Audio);
        this._Audio.addItemListener(new 9());
        this._Statusbox = new CheckboxMenuItem("Status Message");
        this._Statusbox.setState(this._Options.getBoolean("StatusMsg", true));
        m.add(this._Statusbox);
        this._Statusbox.addItemListener(new 10());
        int delaylong = this._Options.getInt("DelayTimeLong", 0);
        int delay = this._Options.getInt("DelayTime", 300);
        if (delaylong != 0) {
            this._DelayLongOn = new MenuItem("Delay " + delaylong / 60 + " Minutes");
            m.add(this._DelayLongOn);
            this._DelayLongOff = new MenuItem("Delay " + delay / 60 + " Minutes");
            m.add(this._DelayLongOff);
            this._DelayLongOff.setEnabled(false);
            this._DelayLongOn.addActionListener(new 11());
            this._DelayLongOff.addActionListener(new 12());
        }
        this._Debugbox = new CheckboxMenuItem("Debug");
        this._Debugbox.setState(Debug.isDebugOn());
        m.add(this._Debugbox);
        this._Debugbox.addItemListener(new 13());
        mbar.add(m);
        m = new Menu("View");
        MenuItem listMail = new MenuItem("ListMail");
        m.add(listMail);
        listMail.addActionListener(new 14());
        MenuItem debugDisplay = new MenuItem("DebugInfo");
        m.add(debugDisplay);
        debugDisplay.addActionListener(new 15());
        mbar.add(m);
        Menu cache = new Menu("Cache");
        mi = new MenuItem("Cache Expire");
        cache.add(mi);
        mi.addActionListener(new 16());
        mi = new MenuItem("Cache Clear");
        cache.add(mi);
        mi.addActionListener(new 17());
        mi = new MenuItem("Cache List");
        cache.add(mi);
        mi.addActionListener(new 18());
        mi = new MenuItem("Cache Verify");
        cache.add(mi);
        mi.addActionListener(new 19());
        m.add(cache);
        m = new Menu("Help");
        mi = new MenuItem("Help");
        m.add(mi);
        mi.addActionListener(new 20());
        m.addSeparator();
        mi = new MenuItem("About");
        m.add(mi);
        mi.addActionListener(new 21());
        mbar.setHelpMenu(m);
    }

    public Dimension getMinimumSize() {
        Insets in = this.getInsets();
        Dimension fb = this._FaceBoard.getMinimumSize();
        Dimension st = this._Status.getMinimumSize();
        int width = in.left + in.right + fb.width;
        int height = in.top + in.bottom + fb.height + st.height;
        Debug.out("FaceFrame.getMinimumSize: " + width + "x" + height);
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        if (in.bottom < 0) {
            return new Insets(in.top, in.left, 4, in.right);
        }
        return in;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Debug.out("Window Closing Event");
            JavaFaces.getRef()._FlagQuitMail = true;
            JavaFaces.getRef()._FlagWakeup = true;
            FaceFrame.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent e) {
            Debug.out("Component moved Event:" + e);
            FaceFrame.this.handleMove();
        }

        public void componentResized(ComponentEvent e) {
            Debug.out("Component resized Event:" + e);
            FaceFrame.this.handleResize();
        }

        /* synthetic */ 2() {
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ int val$servernumber;

        public void actionPerformed(ActionEvent e) {
            JavaFaces.getRef().setServer(this.val$servernumber);
        }

        /* synthetic */ 3(int val$servernumber) {
            this.val$servernumber = val$servernumber;
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JavaFaces.getRef()._FlagCheckMail = true;
            JavaFaces.getRef()._FlagWakeup = true;
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FaceFrame.this._JavaFaces.getResolverRef().checkAddress();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JavaFaces.getRef()._FlagResetMail = true;
            JavaFaces.getRef()._FlagCheckMail = true;
            JavaFaces.getRef()._FlagWakeup = true;
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JavaFaces.getRef()._FlagQuitMail = true;
            JavaFaces.getRef()._FlagWakeup = true;
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JavaFaces.getRef().refreshOptions();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            JavaFaces.getRef()._FlagAudio = FaceFrame.this._Audio.getState();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            FaceFrame.this._Options.put("StatusMsg", FaceFrame.this._Statusbox.getState() ? "true" : "false");
            FaceStatusLabel.setStatusFlag(FaceFrame.this._Statusbox.getState());
            FaceFrame.this.validate();
            FaceFrame.this.pack();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int d = FaceFrame.this._Options.getInt("DelayTimeLong", 600);
            JavaFaces.getRef().setDelay(d);
            FaceFrame.this._DelayLongOff.setEnabled(true);
            FaceFrame.this._DelayLongOn.setEnabled(false);
            JavaFaces.getRef()._FlagWakeup = true;
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int d = FaceFrame.this._Options.getInt("DelayTime", 300);
            JavaFaces.getRef().setDelay(d);
            FaceFrame.this._DelayLongOn.setEnabled(true);
            FaceFrame.this._DelayLongOff.setEnabled(false);
            JavaFaces.getRef()._FlagWakeup = true;
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            boolean state = FaceFrame.this._Debugbox.getState();
            System.out.println("Set Debug = " + state);
            Debug.setDebugOn(state);
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (FaceFrame.this._MailList != null) {
                FaceFrame.this._MailList.dispose();
            }
            FaceFrame.this._MailList = new MailList(FaceFrame.this._FaceBoard.getAllMailmsgs());
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JavaFaces.displayDebugInfo();
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FaceFrame.this._JavaFaces.fireFaceEvent(10);
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FaceFrame.this._JavaFaces.fireFaceEvent(11);
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FaceFrame.this._JavaFaces.fireFaceEvent(12);
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FaceFrame.this._JavaFaces.fireFaceEvent(13);
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String urlstr = FaceOptions.getRef().get("HelpURL");
            String out = "Use your Web browser to view:\n  " + urlstr;
            MsgDialog.create(FaceFrame.this, out, false);
        }

        /* synthetic */ 20() {
        }
    }

    private final class 21
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String v = JavaFaces.version();
            String out = "JavaFaces:\n Version " + v + "\n" + " by John Thomas\n" + "    jthomas@cruzio.com\n" + "    http://www.cruzio.com/~jthomas";
            MsgDialog.create(FaceFrame.this, out, false);
        }

        /* synthetic */ 21() {
        }
    }
}

