/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    static boolean debugThread = true;
    static boolean debugOn;
    static boolean debugOut;
    static String debugFileName;
    public static PrintWriter debugFile;

    public static void setDebugOn(boolean OnOff) {
        debugOut = OnOff;
        debugOn = debugOut || debugFile != null;
    }

    public static void setDebugThreadOn(boolean OnOff) {
        debugThread = OnOff;
    }

    public static boolean isDebugOn() {
        return debugOn;
    }

    public static void setDebugFile(String filename) {
        if (debugFile != null && debugFileName.equals(filename)) {
            return;
        }
        if (filename == null) {
            debugFileName = null;
            debugFile = null;
        } else {
            debugFileName = filename;
            try {
                debugFile = new PrintWriter(new FileOutputStream(filename));
            }
            catch (IOException iOException) {
                debugFile = null;
                System.err.println("Unable to setup Debug output file");
            }
        }
        debugOn = debugOut || debugFile != null;
    }

    public static synchronized void out(Object debugobj) {
        if (debugOn) {
            String strobj;
            if (debugobj instanceof Throwable) {
                Debug.out(((Throwable)debugobj).getMessage(), (Throwable)debugobj);
                return;
            }
            if (debugobj == null) {
                strobj = "Object=null";
            } else if (debugobj instanceof String) {
                strobj = (String)debugobj;
            } else {
                String type = debugobj.getClass().getName();
                strobj = String.valueOf(type) + "=" + debugobj.toString();
            }
            String t = debugThread ? String.valueOf(Thread.currentThread().getName()) + ": " + strobj : strobj;
            if (debugOut) {
                System.err.println(t);
            }
            if (debugFile != null) {
                debugFile.println(t);
                debugFile.flush();
            }
        }
    }

    public static void out(boolean primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(char primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(byte primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(short primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(int primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(long primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(float primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static void out(double primitive) {
        Debug.out(String.valueOf(primitive));
    }

    public static synchronized void out(String debugmsg, Throwable e) {
        String t = debugThread ? String.valueOf(Thread.currentThread().getName()) + ": " + debugmsg : debugmsg;
        if (debugOut) {
            System.err.println(t);
            e.printStackTrace();
        }
        if (debugFile != null) {
            debugFile.println(t);
            e.printStackTrace(debugFile);
            debugFile.flush();
        }
    }

    public static void printStackTrace(String debugmsg) {
        if (debugOn) {
            String t = "";
            try {
                throw new Exception(debugmsg);
            }
            catch (Exception e) {
                Debug.out(debugmsg, e);
            }
        }
    }

    public static void assert(boolean asserted) {
        if (!debugOn || asserted) {
            return;
        }
        throw new RuntimeException("Assertion Failed");
    }

    public static void assert(boolean asserted, String debugmsg) {
        if (!debugOn || asserted) {
            return;
        }
        throw new RuntimeException("Assertion Failed: " + debugmsg);
    }

    public static void main(String[] argv) {
        Debug.setDebugOn(true);
        Debug.out("Testing the Debug class");
        Debug.setDebugFile("debug.txt");
        Debug.out("Test Debug output to File");
        Debug.printStackTrace("test StackTrace");
        try {
            String test = "test";
            test = test.substring(5);
        }
        catch (Exception e) {
            Debug.out("Catch expected StringIndexOutOfBounds");
            Debug.out(e);
        }
        Thread tobj = null;
        Debug.out(tobj);
        tobj = new Thread();
        Debug.out(tobj);
        Debug.setDebugOn(false);
        Debug.setDebugFile(null);
        Debug.out("Should not show up");
        Debug.setDebugOn(true);
        int testit = 5;
        Debug.out(testit);
        Debug.assert(testit == 5);
        Debug.assert(testit == 6, "testit=" + testit);
        Debug.out("We should fail with an \"Assert Failure\" on the next stmt");
        Debug.assert(testit == 6);
    }

    static {
        debugFileName = null;
        debugFile = null;
    }
}

