/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.util;

import com.jthomas.util.Debug;

public class Queue {
    private int _NextOut;
    private int _NextIn;
    private Object[] _Slots;
    private Thread _WaitingForGet;
    private Thread _WaitingForPut;

    public Queue() {
        this(20);
    }

    public Queue(int capacity) {
        this._Slots = new Object[capacity];
    }

    public synchronized Object get() {
        Object obj = null;
        try {
            while (this._Slots[this._NextOut] == null) {
                this._WaitingForGet = Thread.currentThread();
                Debug.out("Queue.get() - Wait until item is in queue");
                this.wait();
            }
            this._WaitingForGet = null;
            obj = this._Slots[this._NextOut];
            this._Slots[this._NextOut] = null;
            ++this._NextOut;
            if (this._NextOut == this._Slots.length) {
                this._NextOut = 0;
            }
            this.notifyAll();
        }
        catch (Exception e) {
            Debug.out("Queue.get() Failure", e);
            System.exit(4);
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void put(Object obj) {
        try {
            if (obj == null) {
                Debug.out(this.toString());
                if (this._WaitingForPut != null) {
                    Debug.out("Waiting for put(): " + this._WaitingForPut.getName());
                }
                if (this._WaitingForGet == null) return;
                Debug.out("Waiting for get(): " + this._WaitingForGet.getName());
                return;
            }
            while (true) {
                if (this._Slots[this._NextIn] == null) {
                    this._WaitingForPut = null;
                    this._Slots[this._NextIn] = obj;
                    ++this._NextIn;
                    if (this._NextIn == this._Slots.length) {
                        this._NextIn = 0;
                    }
                    this.notifyAll();
                    return;
                }
                Debug.out("Queue Full!: " + this.toString());
                this._WaitingForPut = Thread.currentThread();
                this.wait();
            }
        }
        catch (Exception e) {
            Debug.out("Queue.put() Failure", e);
            System.exit(4);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(String.valueOf(this.getClass().getName()) + ":");
        sb.append("  NextOut = " + this._NextOut + "  NextIn = " + this._NextIn + "\n");
        int i = 0;
        while (i < this._Slots.length) {
            if (this._Slots[i] != null) {
                sb.append("    " + i + "  " + this._Slots[i] + "\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

