/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import java.util.Vector;
import starwave.util.regexp.Regexp;
import starwave.util.regexp.State;

class Alternatives
extends Regexp {
    Vector alts = new Vector(2);

    Alternatives(Regexp prev) {
        super(prev);
    }

    void addAlt(Regexp alt) {
        this.alts.addElement(alt);
    }

    int firstCharacter() {
        int limit = this.alts.size();
        int firstc = -1;
        int i = 0;
        while (i < limit) {
            Regexp reg = (Regexp)this.alts.elementAt(i);
            int c = reg.firstCharacter();
            if (firstc == -1) {
                firstc = c;
            } else if (c != firstc) {
                return -1;
            }
            ++i;
        }
        return firstc;
    }

    Regexp advance(State state) {
        int offset = state.offset;
        int limit = this.alts.size();
        int i = 0;
        while (i < limit) {
            Regexp reg = (Regexp)this.alts.elementAt(i);
            if (reg.match(state)) {
                return Regexp.success;
            }
            state.offset = offset;
            ++i;
        }
        return null;
    }

    public boolean canStar() {
        return false;
    }

    public String toStringThis() {
        StringBuffer buf = new StringBuffer();
        int limit = this.alts.size();
        int i = 0;
        while (i < limit) {
            buf.append(this.alts.elementAt(i).toString());
            if (i < limit - 1) {
                buf.append("|");
            }
            ++i;
        }
        return buf.toString();
    }
}

