/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CodeWizard
extends JFrame {
    Assembler o;
    String initial = "";
    String[] array = new String[100];
    int undo = 0;
    private JButton jButton;
    private JButton jButtonCopy;
    private JButton jButtonRedo;
    private JButton jButtonUndo;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxDataType;
    private JComboBox jComboBoxRegPair;
    private JComboBox jComboBoxRegister1;
    private JComboBox jComboBoxRegister2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelData;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaCode;
    private JTextField jTextFieldData;
    private JTree jTree;

    public CodeWizard() {
        this.initComponents();
        this.hideNseek(0, 0, 0, 0);
    }

    public CodeWizard(Assembler o) {
        this.o = o;
        this.initComponents();
        this.hideNseek(0, 0, 0, 0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree = new ZebraJTree();
        this.jComboBoxRegister1 = new JComboBox();
        this.jComboBoxRegPair = new JComboBox();
        this.jTextFieldData = new JTextField();
        this.jLabelData = new JLabel();
        this.jComboBoxDataType = new JComboBox();
        this.jComboBoxRegister2 = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaCode = new JTextArea();
        this.jButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButtonUndo = new JButton();
        this.jButtonRedo = new JButton();
        this.jButtonCopy = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Code Wizard");
        this.setAlwaysOnTop(true);
        this.setBounds(new Rectangle(100, 100, 0, 0));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CodeWizard.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jTree.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(153, 0, 0)));
        this.jTree.setFont(new Font("Arial", 1, 11));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Code Classification");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("Data Transfer Operation");
        DefaultMutableTreeNode treeNode3 = new DefaultMutableTreeNode("Load Data");
        DefaultMutableTreeNode treeNode4 = new DefaultMutableTreeNode("Register         \u2190   Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator  \u2190   Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator  \u2190   Data (from memory address directly)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator  \u2190   Data (from memory address pointed by Reg Pair H-L)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator  \u2190   Data (from memory address pointed by Reg. Pair)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Register Pair \u2190   Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Reg. pair H-L  \u2190   Data (from memory address directly)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Stack Pointer (SP)  \u2190  Reg. pair H-L");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Program Counter (PC)  \u2190   Reg. pair H-L");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Store Data");
        treeNode4 = new DefaultMutableTreeNode("Accumulator(Data)  \u2192 Memory (at address specified directly)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator(Data)  \u2192 Memory (at address pointed by Reg Pair H-L)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator(Data)  \u2192 Memory (at address pointed by Reg. Pair)");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Reg. pair H-L(Data) \u2192 Memory (at address specified directly)");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Move Data");
        treeNode4 = new DefaultMutableTreeNode("Register \u2190  Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Stack");
        treeNode4 = new DefaultMutableTreeNode("Push");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Pop");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Exchange");
        treeNode4 = new DefaultMutableTreeNode("H-L   \u2190\u2192  D-E");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("H-L   \u2190\u2192  Stack Top Pointer");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Arithmetic Operation");
        treeNode3 = new DefaultMutableTreeNode("Addition");
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator + Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator + Carry + Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator + Register");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator + Carry + Register");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Register Pair(H-L) = Register Pair(H-L) + Register Pair");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Subtraction");
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator - Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator - Borrow/Carry - Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator - Register");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator - Borrow/Carry - Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Increment");
        treeNode4 = new DefaultMutableTreeNode("Increment Register");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Increment Register Pair");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Decrement");
        treeNode4 = new DefaultMutableTreeNode("Decrement Register");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Decrement Register Pair");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Binary to BCD");
        treeNode4 = new DefaultMutableTreeNode("Decimal Adjust Accumulator");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Logical Operation");
        treeNode3 = new DefaultMutableTreeNode("And");
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator & Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator & Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Or");
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator | Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator | Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Xor");
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator ^ Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator = Accumulator ^ Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Rotate");
        treeNode4 = new DefaultMutableTreeNode("Rotate Accumulator Left with carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Rotate Accumulator Left without carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Rotate Accumulator Right with carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Rotate Accumulator Right without carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Compare");
        treeNode4 = new DefaultMutableTreeNode("Accumulator -  Data");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Accumulator -  Register");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Complement");
        treeNode4 = new DefaultMutableTreeNode("Complement Accumulator");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Complement Carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Carry");
        treeNode4 = new DefaultMutableTreeNode("Set Carry [C=1]");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Complement Carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Branching Operation");
        treeNode3 = new DefaultMutableTreeNode("Jump to a location");
        treeNode4 = new DefaultMutableTreeNode("Jump");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Positive");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Negative");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on not Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Parity Even");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Parity Odd");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on Carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Jump on no Carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Call a subroutine");
        treeNode4 = new DefaultMutableTreeNode("Call");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Positive");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Negative");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on not Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Parity Even");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Parity Odd");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on Carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Call on no Carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Return from a subroutine");
        treeNode4 = new DefaultMutableTreeNode("Return");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Positive");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Negative");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on not Zero");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Parity Even");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Parity Odd");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on Carry");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Return on no Carry");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Restart(One line call instruction)");
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0000");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0008");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0010");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0018");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0020");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0028");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0030");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("Restart from memory loaction 0038");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Change Program Counter");
        treeNode4 = new DefaultMutableTreeNode("Program Counter (PC)  \u2190   Reg. pair H-L");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Change Stack Pointer");
        treeNode4 = new DefaultMutableTreeNode("Stack Pointer (SP)  \u2190  Reg. pair H-L");
        treeNode3.add(treeNode4);
        treeNode4 = new DefaultMutableTreeNode("H-L   \u2190\u2192  Stack Top Pointer");
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("I/O Operation");
        treeNode3 = new DefaultMutableTreeNode("Accumulator  \u2190  Input data");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Accumulator   \u2192 Output data");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Interrupt Operation");
        treeNode3 = new DefaultMutableTreeNode("Halt Operation");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Enable Interrupt");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Disable Interrupt");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Read Interrupt Mask");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("Set Interrupt Mask");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("No Operation");
        treeNode1.add(treeNode2);
        this.jTree.setModel(new DefaultTreeModel(treeNode1));
        this.jTree.setName("jTree");
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CodeWizard.this.jTreeMouseClicked(evt);
            }
        });
        this.jTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CodeWizard.this.jTreeKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree);
        this.jComboBoxRegister1.setModel(new DefaultComboBoxModel<String>(new String[]{"Accumulator", "Register B", "Register C", "Register D", "Register E", "Register H", "Register L", "Memory(M)"}));
        this.jComboBoxRegister1.setName("jComboBoxRegister1");
        this.jComboBoxRegister1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jComboBoxRegister1ActionPerformed(evt);
            }
        });
        this.jComboBoxRegPair.setModel(new DefaultComboBoxModel<String>(new String[]{"Register Pair B - C", "Register Pair D - E", "Register Pair H - L", "Stack Pointer"}));
        this.jComboBoxRegPair.setName("jComboBoxRegPair");
        this.jComboBoxRegPair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jComboBoxRegPairActionPerformed(evt);
            }
        });
        this.jTextFieldData.setHorizontalAlignment(0);
        this.jTextFieldData.setFocusCycleRoot(true);
        this.jTextFieldData.setName("jTextFieldData");
        this.jTextFieldData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jTextFieldDataActionPerformed(evt);
            }
        });
        this.jTextFieldData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CodeWizard.this.jTextFieldDataKeyReleased(evt);
            }
        });
        this.jLabelData.setText("Data : ");
        this.jLabelData.setName("jLabelData");
        this.jComboBoxDataType.setModel(new DefaultComboBoxModel<String>(new String[]{"Binary", "Decimal", "Hexadecimal", "ASCII"}));
        this.jComboBoxDataType.setSelectedIndex(2);
        this.jComboBoxDataType.setName("jComboBoxDataType");
        this.jComboBoxDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jComboBoxDataTypeActionPerformed(evt);
            }
        });
        this.jComboBoxRegister2.setModel(new DefaultComboBoxModel<String>(new String[]{"Accumulator", "Register B", "Register C", "Register D", "Register E", "Register H", "Register L", "Memory(M)"}));
        this.jComboBoxRegister2.setName("jComboBoxRegister2");
        this.jComboBoxRegister2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jComboBoxRegister2ActionPerformed(evt);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaCode.setBackground(new Color(255, 255, 204));
        this.jTextAreaCode.setColumns(6);
        this.jTextAreaCode.setFont(new Font("Monospaced", 1, 13));
        this.jTextAreaCode.setRows(5);
        this.jTextAreaCode.setName("jTextAreaCode");
        this.jTextAreaCode.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                CodeWizard.this.jTextAreaCodeCaretUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextAreaCode);
        this.jButton.setText("OK");
        this.jButton.setName("jButton");
        this.jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(153, 0, 204));
        this.jLabel1.setText("         Rough Work");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setForeground(new Color(153, 102, 0));
        this.jLabel2.setText("Code Guide ");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setFont(new Font("Arial", 1, 11));
        this.jLabel3.setForeground(new Color(153, 153, 153));
        this.jLabel3.setText("N.B: Copy Rough work to the main workspace.");
        this.jLabel3.setName("jLabel3");
        this.jCheckBox1.setText("Append");
        this.jCheckBox1.setName("jCheckBox1");
        this.jButtonUndo.setText("Undo");
        this.jButtonUndo.setName("jButtonUndo");
        this.jButtonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jButtonRedo.setText("Redo");
        this.jButtonRedo.setName("jButtonRedo");
        this.jButtonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText("Copy");
        this.jButtonCopy.setName("jButtonCopy");
        this.jButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWizard.this.jButtonCopyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.jLabelData, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldData, -2, 60, -2).addGap(5, 5, 5).addComponent(this.jComboBoxDataType, -2, 100, -2).addGap(4, 4, 4).addComponent(this.jComboBoxRegister1, 0, 92, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxRegister2, 0, 114, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jComboBoxRegPair, -2, 129, -2)).addComponent(this.jScrollPane1, -1, 553, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.jButton, -2, 127, -2).addGap(178, 178, 178))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonUndo).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRedo).addComponent(this.jButtonCopy))).addComponent(this.jScrollPane2, -2, 141, -2)).addContainerGap()).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addGap(212, 212, 212).addComponent(this.jLabel2).addGap(369, 369, 369)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(456, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1, -1, 422, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 422, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelData).addComponent(this.jTextFieldData, -2, -1, -2).addComponent(this.jComboBoxDataType, -2, -1, -2).addComponent(this.jComboBoxRegister1, -2, -1, -2).addComponent(this.jComboBoxRegister2, -2, -1, -2).addComponent(this.jComboBoxRegPair, -2, -1, -2).addComponent(this.jCheckBox1).addComponent(this.jButtonCopy)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonUndo).addComponent(this.jButtonRedo).addComponent(this.jButton, -2, 23, -2))).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jLabel3, -2, 14, -2))).addContainerGap()));
        this.pack();
    }

    private void jTreeMouseClicked(MouseEvent evt) {
        try {
            String s = this.jTree.getAnchorSelectionPath().getLastPathComponent().toString();
            this.initial = this.jTextAreaCode.getText();
            this.decodeFunction(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCopyActionPerformed(null);
    }

    private void jButtonActionPerformed(ActionEvent evt) {
        this.jButtonCopyActionPerformed(null);
        this.dispose();
    }

    private void jComboBoxRegister1ActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.setText(this.initial);
        this.jTreeMouseClicked(null);
    }

    private void jComboBoxRegister2ActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.setText(this.initial);
        this.jTreeMouseClicked(null);
    }

    private void jComboBoxRegPairActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.setText(this.initial);
        this.jTreeMouseClicked(null);
    }

    private void jTextFieldDataKeyReleased(KeyEvent evt) {
        this.jTextFieldDataActionPerformed(null);
    }

    private void jComboBoxDataTypeActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.setText(this.initial);
        this.jTreeMouseClicked(null);
    }

    private void jTreeKeyReleased(KeyEvent evt) {
        this.jTreeMouseClicked(null);
    }

    private void jTextFieldDataActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.setText(this.initial);
        this.jTreeMouseClicked(null);
        this.jTextFieldData.transferFocusDownCycle();
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        --this.undo;
        if (this.undo > 0) {
            this.jTextAreaCode.setText(this.array[this.undo]);
        }
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        this.jTextAreaCode.selectAll();
        this.jTextAreaCode.copy();
    }

    private void jTextAreaCodeCaretUpdate(CaretEvent evt) {
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        ++this.undo;
        if (this.undo < this.array.length) {
            this.jTextAreaCode.setText(this.array[this.undo]);
        }
    }

    public void hideNseek(int a, int b, int c, int d) {
        this.jComboBoxRegister1.setVisible(false);
        this.jComboBoxRegister2.setVisible(false);
        this.jComboBoxRegPair.setVisible(false);
        this.jLabelData.setVisible(false);
        this.jTextFieldData.setVisible(false);
        this.jComboBoxDataType.setVisible(false);
        if (a == 1) {
            this.jComboBoxRegister1.setVisible(true);
        }
        if (b == 1) {
            this.jComboBoxRegister2.setVisible(true);
        }
        if (c == 1) {
            this.jComboBoxRegPair.setVisible(true);
        }
        if (d == 1) {
            this.jLabelData.setVisible(true);
            this.jTextFieldData.setVisible(true);
            this.jComboBoxDataType.setVisible(true);
        }
    }

    public String reg1() {
        int n = this.jComboBoxRegister1.getSelectedIndex();
        String[] s = new String[]{"A", "B", "C", "D", "E", "H", "L", "M"};
        return s[n];
    }

    public String reg2() {
        int n = this.jComboBoxRegister2.getSelectedIndex();
        String[] s = new String[]{"A", "B", "C", "D", "E", "H", "L", "M"};
        return s[n];
    }

    public String regPair() {
        int n = this.jComboBoxRegPair.getSelectedIndex();
        String[] s = new String[]{"B", "D", "H", "SP"};
        return s[n];
    }

    public String data4digit() {
        int n = this.jComboBoxDataType.getSelectedIndex();
        int no = 0;
        String s = this.jTextFieldData.getText();
        try {
            no = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            s = this.o.engine.Bin2Hex(s);
            this.jTextFieldData.setText(this.o.engine.Hex2Bin(s));
        } else if (n == 1) {
            s = this.o.engine.Dec2Hex(no);
            this.jTextFieldData.setText(String.valueOf(this.o.engine.Hex2Dec(s)));
        } else if (n == 3) {
            s = this.o.engine.Ascii2Hex(s);
            this.jTextFieldData.setText(this.o.engine.Hex2Ascii(s));
        } else if (n == 2) {
            this.jTextFieldData.setText(this.o.engine.HexAutoCorrect4digit(s));
        }
        return this.o.engine.HexAutoCorrect4digit(s);
    }

    public String data2digit() {
        int n = this.jComboBoxDataType.getSelectedIndex();
        int no = 0;
        String s = this.jTextFieldData.getText();
        try {
            no = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            s = this.o.engine.Bin2Hex(s);
            this.jTextFieldData.setText(this.o.engine.Hex2Bin(s));
        } else if (n == 1) {
            s = this.o.engine.Dec2Hex(no);
            this.jTextFieldData.setText(String.valueOf(this.o.engine.Hex2Dec(s)));
        } else if (n == 3) {
            s = this.o.engine.HexAutoCorrect2digit(this.o.engine.Ascii2Hex(s));
            this.jTextFieldData.setText(this.o.engine.Hex2Ascii(s));
        } else if (n == 2) {
            this.jTextFieldData.setText(this.o.engine.HexAutoCorrect2digit(s));
        }
        return this.o.engine.HexAutoCorrect2digit(s);
    }

    public void append(String t) {
        if (this.jCheckBox1.isSelected()) {
            this.jTextAreaCode.append("\n" + t);
        } else {
            this.jTextAreaCode.setText(t);
        }
        if (this.undo < this.array.length) {
            this.array[this.undo] = this.jTextAreaCode.getText();
        }
        ++this.undo;
    }

    public String funcDataTransfer(String s) {
        String t = "";
        if (s.equals("Register         \u2190   Data")) {
            t = "MVI " + this.reg1() + "," + this.data2digit();
            this.hideNseek(1, 0, 0, 1);
        } else if (s.equals("Accumulator  \u2190   Data")) {
            t = "MVI A," + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator  \u2190   Data (from memory address directly)")) {
            t = "LDA " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator  \u2190   Data (from memory address pointed by Reg Pair H-L)")) {
            t = "MOV A,M";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Accumulator  \u2190   Data (from memory address pointed by Reg. Pair)")) {
            t = "LDAX " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Register Pair \u2190   Data")) {
            t = "LXI " + this.regPair() + "," + this.data4digit();
            this.hideNseek(0, 0, 1, 1);
        } else if (s.equals("Reg. pair H-L  \u2190   Data (from memory address directly)")) {
            t = "LHLD " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Stack Pointer (SP)  \u2190  Reg. pair H-L")) {
            t = "SPHL";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Program Counter (PC)  \u2190   Reg. pair H-L")) {
            t = "PCHL";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Accumulator(Data)  \u2192 Memory (at address specified directly)")) {
            t = "STA " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator(Data)  \u2192 Memory (at address pointed by Reg Pair H-L)")) {
            t = "MOV M,A";
        } else if (s.equals("Accumulator(Data)  \u2192 Memory (at address pointed by Reg. Pair)")) {
            t = "STAX " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Reg. pair H-L(Data) \u2192 Memory (at address specified directly)")) {
            t = "SHLD " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Register \u2190  Register")) {
            t = "MOV " + this.reg1() + "," + this.reg2();
            this.hideNseek(1, 1, 0, 0);
        } else if (s.equals("Push")) {
            t = "PUSH " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Pop")) {
            t = "POP " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("H-L   \u2190\u2192  D-E")) {
            t = "XCHG";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("H-L   \u2190\u2192  Stack Top Pointer")) {
            t = "XTHL";
            this.hideNseek(0, 0, 0, 0);
        }
        return t;
    }

    public String funcArithmetic(String s) {
        String t = "";
        if (s.equals("Accumulator = Accumulator + Data")) {
            t = "ADI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator + Carry + Data")) {
            t = "ACI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator + Register")) {
            t = "ADD " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Accumulator = Accumulator + Carry + Register")) {
            t = "ADC " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Register Pair(H-L) = Register Pair(H-L) + Register Pair")) {
            t = "DAD " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Accumulator = Accumulator - Data")) {
            t = "SUI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator - Borrow/Carry - Data")) {
            t = "SBI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator - Register")) {
            t = "SUB " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Accumulator = Accumulator - Borrow/Carry - Register")) {
            t = "SBB " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Increment Register")) {
            t = "INR " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Increment Register Pair")) {
            t = "INX " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Decrement Register")) {
            t = "DCR " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Decrement Register Pair")) {
            t = "DCX " + this.regPair();
            this.hideNseek(0, 0, 1, 0);
        } else if (s.equals("Decimal Adjust Accumulator")) {
            t = "DAA";
        }
        return t;
    }

    public String funcLogic(String s) {
        String t = "";
        if (s.equals("Accumulator = Accumulator & Data")) {
            t = "ANI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator & Register")) {
            t = "ANA " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Accumulator = Accumulator | Data")) {
            t = "ORI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator | Register")) {
            t = "ORA " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Accumulator = Accumulator ^ Data")) {
            t = "XRI " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator = Accumulator ^ Register")) {
            t = "XRA " + this.reg1();
            this.hideNseek(1, 0, 0, 0);
        } else if (s.equals("Rotate Accumulator Left with carry")) {
            t = "RAR";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Rotate Accumulator Left without carry")) {
            t = "RRC";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Rotate Accumulator Right with carry")) {
            t = "RAL";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Rotate Accumulator Right without carry")) {
            t = "RLC";
            this.hideNseek(0, 0, 0, 0);
        } else if (!s.equals("Rotate Accumulator Right without carry")) {
            if (s.equals("Accumulator -  Data")) {
                t = "CPI " + this.data2digit();
                this.hideNseek(0, 0, 0, 1);
            } else if (s.equals("Accumulator -  Register")) {
                t = "CMP " + this.reg1();
                this.hideNseek(1, 0, 0, 0);
            } else if (s.equals("Complement Accumulator")) {
                t = "CMA";
                this.hideNseek(0, 0, 0, 0);
            } else if (s.equals("Complement Carry")) {
                t = "CMC";
                this.hideNseek(0, 0, 0, 0);
            } else if (s.equals("Set Carry [C=1]")) {
                t = "STC";
                this.hideNseek(0, 0, 0, 0);
            }
        }
        return t;
    }

    public String funcBranching(String s) {
        String t = "";
        if (s.equals("Jump")) {
            t = "JMP " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Positive")) {
            t = "JP " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Negative")) {
            t = "JM " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Zero")) {
            t = "JZ " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on not Zero")) {
            t = "JNZ " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Parity Even")) {
            t = "JPE " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Parity Odd")) {
            t = "JPO " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on Carry")) {
            t = "JC " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Jump on no Carry")) {
            t = "JNC " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call")) {
            t = "CALL " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Positive")) {
            t = "CP " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Negative")) {
            t = "CM " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Zero")) {
            t = "CZ " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on not Zero")) {
            t = "CNZ " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Parity Even")) {
            t = "CPE " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Parity Odd")) {
            t = "CPO " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on Carry")) {
            t = "CC " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Call on no Carry")) {
            t = "CNC " + this.data4digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Return")) {
            t = "RET";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Positive")) {
            t = "RP";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Negative")) {
            t = "RM";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Zero")) {
            t = "RZ";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on not Zero")) {
            t = "RNZ";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Parity Even")) {
            t = "RPE";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Parity Odd")) {
            t = "RPO";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on Carry")) {
            t = "RC";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Return on no Carry")) {
            t = "RNC";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0000")) {
            t = "RST 0";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0008")) {
            t = "RST 1";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0010")) {
            t = "RST 2";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0018")) {
            t = "RST 3";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0020")) {
            t = "RST 4";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0028")) {
            t = "RST 5";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0030")) {
            t = "RST 6";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Restart from memory loaction 0038")) {
            t = "RST 7";
            this.hideNseek(0, 0, 0, 0);
        }
        return t;
    }

    public String funcIO(String s) {
        String t = "";
        if (s.equals("Accumulator  \u2190  Input data")) {
            t = "IN " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        } else if (s.equals("Accumulator   \u2192 Output data")) {
            t = "OUT " + this.data2digit();
            this.hideNseek(0, 0, 0, 1);
        }
        return t;
    }

    public String funcInterrupt(String s) {
        String t = "";
        if (s.equals("Halt Operation")) {
            t = "HLT";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Enable Interrupt")) {
            t = "EI";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Disable Interrupt")) {
            t = "DI";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Read Interrupt Mask")) {
            t = "RIM";
            this.hideNseek(0, 0, 0, 0);
        } else if (s.equals("Set Interrupt Mask")) {
            t = "SIM";
            this.hideNseek(0, 0, 0, 0);
        }
        return t;
    }

    public String funcNOP(String s) {
        String t = "";
        if (s.equals("No Operation")) {
            t = "NOP";
            this.hideNseek(0, 0, 0, 0);
        }
        return t;
    }

    public void decodeFunction(String s) {
        String t = "";
        t = this.funcDataTransfer(s);
        if (t.equals("")) {
            t = this.funcArithmetic(s);
        }
        if (t.equals("")) {
            t = this.funcLogic(s);
        }
        if (t.equals("")) {
            t = this.funcBranching(s);
        }
        if (t.equals("")) {
            t = this.funcIO(s);
        }
        if (t.equals("")) {
            t = this.funcInterrupt(s);
        }
        if (t.equals("")) {
            t = this.funcNOP(s);
        }
        if (!t.equals("")) {
            this.append(t);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CodeWizard(new Assembler()).setVisible(true);
            }
        });
    }
}

