/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileChooser
extends JFrame {
    public static int objectNo = 0;
    public String path = "";
    Assembler o;
    FileFilter fileFilter;
    private JFileChooser jFileChooser1;

    public FileChooser() {
        System.out.println(objectNo);
        if (++objectNo == 1) {
            this.initComponents();
        }
        this.jFileChooser1.setApproveButtonText("Open");
    }

    public FileChooser(String s, Assembler o) {
        ++objectNo;
        o.setEnabled(false);
        this.initComponents();
        File file = new File(o.path);
        this.jFileChooser1.setSelectedFile(file);
        this.jFileChooser1.setApproveButtonText(s);
        this.setTitle(s);
        this.jFileChooser1.setApproveButtonMnemonic(s.charAt(0));
        if (s.charAt(5) == 'M') {
            this.fileFilter = new FileNameExtensionFilter("8085 Assembler Language Simulation module(.asm)", "asm");
        } else if (s.charAt(5) == 'H') {
            this.fileFilter = new FileNameExtensionFilter("Hexcode(.hex)", "hex");
        }
        this.jFileChooser1.setFileFilter(this.fileFilter);
        this.jFileChooser1.setFileHidingEnabled(false);
        this.o = o;
        objectNo = 0;
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setBounds(new Rectangle(300, 200, 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileChooser.this.formWindowClosing(evt);
            }
        });
        this.jFileChooser1.setName("jFileChooser1");
        this.jFileChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooser.this.jFileChooser1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jFileChooser1, -1, 572, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jFileChooser1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jFileChooser1ActionPerformed(ActionEvent evt) {
        this.o.setEnabled(true);
        if (evt.getActionCommand().equalsIgnoreCase("CancelSelection")) {
            this.dispose();
            if (this.o.closeStateCall) {
                new Popup(this.o).terminate("Are you sure you want to exit without saving changes ? ");
            }
        }
        if (evt.getActionCommand().equalsIgnoreCase("ApproveSelection")) {
            this.o.path = this.path = this.jFileChooser1.getSelectedFile().toString();
            this.o.setTitle("8085 Simulator - " + this.o.path);
            if (this.jFileChooser1.getApproveButtonText().equalsIgnoreCase("Load Mnemonics")) {
                String s = "";
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(this.path));
                    while ((line = in.readLine()) != null) {
                        s = s + line + "\n";
                    }
                    this.o.jTextAreaAssemblyLanguageEditor.setText(s);
                    this.o.textEditor.colorEditor();
                    in.close();
                }
                catch (Exception e) {
                    Popup.show("Failed to load the file.");
                }
            } else if (this.jFileChooser1.getApproveButtonText().equalsIgnoreCase("Save Mnemonics")) {
                try {
                    this.path = this.path.replace(".asm", "");
                }
                catch (Exception s) {
                    // empty catch block
                }
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.path + ".asm")));
                    out.print(this.o.jTextAreaAssemblyLanguageEditor.getText());
                    out.close();
                }
                catch (Exception e) {
                    Popup.show("Unable to save the file.");
                }
            } else if (this.jFileChooser1.getApproveButtonText().equalsIgnoreCase("Load Hexcode")) {
                try {
                    if (!this.path.contains(".")) {
                        this.path = this.path + ".hex";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String s = "";
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(this.path));
                    while ((line = in.readLine()) != null) {
                        s = s + line + "\n";
                    }
                    this.o.jTextAreaDisassembler.setText(s);
                    in.close();
                }
                catch (Exception e) {
                    Popup.show("Failed to load the file.");
                }
            } else if (this.jFileChooser1.getApproveButtonText().equalsIgnoreCase("Save Hexcode")) {
                try {
                    this.path = this.path.replace(".hex", "");
                }
                catch (Exception s) {
                    // empty catch block
                }
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.path + ".hex")));
                    out.print(this.o.disassembler.saveDisassembler());
                    out.close();
                }
                catch (Exception e) {
                    Popup.show("Unable to save the file.");
                }
            }
            this.o.jTextAreaAssemblyLanguageEditor.select(0, 0);
            this.dispose();
            if (this.o.closeStateCall) {
                System.exit(0);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.o.setEnabled(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooser f = new FileChooser();
                f.setVisible(true);
            }
        });
    }
}

