/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

class TimingPaint
extends JPanel {
    Graphics g;
    int end = 500;
    int io = 0;
    int s1 = 0;
    int s0 = 0;
    Assembler o;
    int x;
    int addressDec;
    String code;

    public TimingPaint(Assembler o) {
        this.o = o;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(Color.BLACK);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(Color.WHITE);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, 100000, 520);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.g = g;
        super.paintComponent(g);
        this.end = 500;
        this.x = 70 - this.o.timingDiagramX * 20;
        this.nameRows(this.x - 70);
        int addressDec = this.addressDec;
        int i = 0;
        while (i < this.code.length()) {
            this.cycleDecoder(this.code.charAt(i), this.o.engine.Dec2Hex(addressDec), this.o.engine.Dec2Hex2digit(this.o.matrix.memory[addressDec]));
            ++i;
            ++addressDec;
        }
    }

    private void opcodeFetchTable(int x) {
        this.g.drawLine(x + 0, 10, x + 400, 10);
        this.g.drawString("OPCODE FETCH CYCLE", x + 127, 25);
        this.g.drawLine(x + 0, 30, x + 400, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawString("T4", x + 345, 45);
        this.g.drawLine(x + 0, 50, x + 400, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 30, x + 300, this.end);
        this.g.drawLine(x + 400, 10, x + 400, this.end);
        this.g.drawLine(x + 0, this.end, x + 400, this.end);
    }

    private void memoryReadTable(int x) {
        this.g.drawLine(x + 0, 10, x + 300, 10);
        this.g.drawString("MEMORY READ CYCLE", x + 80, 25);
        this.g.drawLine(x + 0, 30, x + 300, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawLine(x + 0, 50, x + 300, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 10, x + 300, this.end);
        this.g.drawLine(x + 0, this.end, x + 300, this.end);
    }

    private void memoryWriteTable(int x) {
        this.g.drawLine(x + 0, 10, x + 300, 10);
        this.g.drawString("MEMORY WRITE CYCLE", x + 80, 25);
        this.g.drawLine(x + 0, 30, x + 300, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawLine(x + 0, 50, x + 300, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 10, x + 300, this.end);
        this.g.drawLine(x + 0, this.end, x + 300, this.end);
    }

    private void ioReadTable(int x) {
        this.g.drawLine(x + 0, 10, x + 300, 10);
        this.g.drawString("I/O READ CYCLE", x + 105, 25);
        this.g.drawLine(x + 0, 30, x + 300, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawLine(x + 0, 50, x + 300, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 10, x + 300, this.end);
        this.g.drawLine(x + 0, this.end, x + 300, this.end);
    }

    private void ioWriteTable(int x) {
        this.g.drawLine(x + 0, 10, x + 300, 10);
        this.g.drawString("I/O WRITE CYCLE", x + 100, 25);
        this.g.drawLine(x + 0, 30, x + 300, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawLine(x + 0, 50, x + 300, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 10, x + 300, this.end);
        this.g.drawLine(x + 0, this.end, x + 300, this.end);
    }

    private void opcodeFetchTable6state(int x) {
        this.g.drawLine(x + 0, 10, x + 600, 10);
        this.g.drawString("OPCODE FETCH CYCLE WITH 6 T-STATES", x + 180, 25);
        this.g.drawLine(x + 0, 30, x + 600, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawString("T2", x + 145, 45);
        this.g.drawString("T3", x + 245, 45);
        this.g.drawString("T4", x + 345, 45);
        this.g.drawString("T5", x + 445, 45);
        this.g.drawString("T6", x + 545, 45);
        this.g.drawLine(x + 0, 50, x + 600, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 30, x + 100, this.end);
        this.g.drawLine(x + 200, 30, x + 200, this.end);
        this.g.drawLine(x + 300, 30, x + 300, this.end);
        this.g.drawLine(x + 400, 30, x + 400, this.end);
        this.g.drawLine(x + 500, 30, x + 500, this.end);
        this.g.drawLine(x + 600, 10, x + 600, this.end);
        this.g.drawLine(x + 0, this.end, x + 600, this.end);
    }

    private void busIdleTable(int x) {
        this.g.drawLine(x + 0, 10, x + 100, 10);
        this.g.drawString("BUS IDLE CYCLE", x + 2, 25);
        this.g.drawLine(x + 0, 30, x + 100, 30);
        this.g.drawString("T1", x + 45, 45);
        this.g.drawLine(x + 0, 50, x + 100, 50);
        this.g.drawLine(x + 0, 10, x + 0, this.end);
        this.g.drawLine(x + 100, 10, x + 100, this.end);
        this.g.drawLine(x + 0, this.end, x + 100, this.end);
    }

    private void nameRows(int x) {
        boolean y = false;
        this.g.drawString("CLK", 25 + x, 80);
        this.g.drawString("A15-A8", 15 + x, 140);
        this.g.drawString("AD7-AD0", 5 + x, 180);
        this.g.drawString("ALE", 35 + x, 230);
        this.g.drawLine(46 + x, 288, 54 + x, 288);
        this.g.drawString("IO / M", 25 + x, 300);
        this.g.drawString("S1", 40 + x, 335);
        this.g.drawString("S0", 40 + x, 375);
        this.g.drawLine(41 + x, 438, 55 + x, 438);
        this.g.drawString("RD", 40 + x, 450);
        this.g.drawLine(40 + x, 478, 58 + x, 478);
        this.g.drawString("WR", 40 + x, 490);
    }

    private void clock(int x, int tstate) {
        int y = -35;
        this.g.setColor(Color.green);
        int i = 0;
        while (i < tstate) {
            this.g.drawLine(x + 0, y + 100, x + 10, y + 120);
            this.g.drawLine(x + 10, y + 120, x + 50, y + 120);
            this.g.drawLine(x + 50, y + 120, x + 60, y + 100);
            this.g.drawLine(x + 60, y + 100, x + 100, y + 100);
            ++i;
            x += 100;
        }
        this.g.setColor(Color.WHITE);
    }

    private void A15A8(int x, int tstate) {
        int y = 125;
        this.g.setColor(Color.yellow);
        this.g.drawLine(x, y, x + 5, y);
        this.g.drawLine(x, y + 20, x + 5, y + 20);
        this.g.drawLine(x + 10, y, x + 300, y);
        this.g.drawLine(x + 10, y + 20, x + 300, y + 20);
        this.g.drawLine(x + 5, y, x + 10, y + 20);
        this.g.drawLine(x + 10, y, x + 5, y + 20);
        if (tstate == 4) {
            this.g.drawLine(x += 300, y, x + 5, y);
            this.g.drawLine(x, y + 20, x + 5, y + 20);
            this.g.drawLine(x + 10, y, x + 100, y);
            this.g.drawLine(x + 10, y + 20, x + 100, y + 20);
            this.g.drawLine(x + 5, y, x + 10, y + 20);
            this.g.drawLine(x + 10, y, x + 5, y + 20);
            x -= 300;
        } else if (tstate == 6) {
            this.g.drawLine(x += 300, y, x + 5, y);
            this.g.drawLine(x, y + 20, x + 5, y + 20);
            this.g.drawLine(x + 10, y, x + 300, y);
            this.g.drawLine(x + 10, y + 20, x + 300, y + 20);
            this.g.drawLine(x + 5, y, x + 10, y + 20);
            this.g.drawLine(x + 10, y, x + 5, y + 20);
            x -= 300;
            this.g.setColor(Color.white);
        }
    }

    private void AD7AD0(int x, int tstate) {
        int i;
        this.g.setColor(new Color(255, 255, 170));
        int y = 165;
        if (tstate == 4) {
            this.g.drawLine(x, y, x + 5, y);
            this.g.drawLine(x, y + 20, x + 5, y + 20);
            this.g.drawLine(x + 10, y, x + 5, y + 20);
            this.g.drawLine(x + 5, y, x + 10, y + 20);
        } else {
            for (i = 0; i < 5; i += 4) {
                this.g.drawLine(x + i, y + 10, x + i, y + 10);
            }
            this.g.drawLine(x + 10, y, x + 5, y + 10);
            this.g.drawLine(x + 5, y + 10, x + 10, y + 20);
        }
        this.g.drawLine(x + 10, y, x + 100, y);
        this.g.drawLine(x + 10, y + 20, x + 100, y + 20);
        this.g.drawLine(x + 100, y, x + 105, y + 10);
        this.g.drawLine(x + 105, y + 10, x + 100, y + 20);
        for (i = 0; i < 45; i += 6) {
            this.g.drawLine(x + 105 + i, y + 10, x + 107 + i, y + 10);
        }
        this.g.drawLine(x + 150, y + 10, x + 155, y + 20);
        this.g.drawLine(x + 155, y, x + 150, y + 10);
        this.g.drawLine(x + 155, y, x + 255, y);
        this.g.drawLine(x + 155, y + 20, x + 255, y + 20);
        this.g.drawLine(x + 255, y, x + 260, y + 10);
        this.g.drawLine(x + 260, y + 10, x + 255, y + 20);
        int up = 195;
        if (tstate == 4) {
            up = 295;
        } else if (tstate == 6) {
            up = 495;
        }
        for (int i2 = 155; i2 < up; i2 += 6) {
            this.g.drawLine(x + 105 + i2, y + 10, x + 107 + i2, y + 10);
        }
        this.g.setColor(Color.white);
    }

    private void ALE(int x, int tstate) {
        int y = 235;
        this.g.setColor(Color.blue);
        this.g.drawLine(x, y, x + 5, y - 20);
        this.g.drawLine(x + 5, y - 20, x + 50, y - 20);
        this.g.drawLine(x + 50, y - 20, x + 55, y);
        this.g.drawLine(x + 55, y, x + 300, y);
        if (tstate == 4) {
            this.g.drawLine(x + 300, y, x + 400, y);
        } else if (tstate == 6) {
            this.g.drawLine(x + 300, y, x + 600, y);
        }
        this.g.setColor(Color.white);
    }

    private void controlSignal(int x, int y, int toggle, int tstate) {
        this.g.setColor(Color.red);
        if (toggle == 1) {
            this.g.drawLine(x, y, x + 100, y);
            this.g.drawLine(x + 100, y, x + 120, y);
            this.g.drawLine(x + 120, y, x + 125, y + 20);
            this.g.drawLine(x + 125, y + 20, x + 275, y + 20);
            this.g.drawLine(x + 275, y + 20, x + 280, y);
            this.g.drawLine(x + 280, y, x + 300, y);
        } else {
            this.g.drawLine(x, y, x + 300, y);
        }
        if (tstate == 4) {
            this.g.drawLine(x + 300, y, x + 400, y);
        } else if (tstate == 6) {
            this.g.drawLine(x + 300, y, x + 600, y);
        }
        this.g.setColor(Color.WHITE);
    }

    private void signalActiveHigh(int x, int y, int toggle, int tstate) {
        int i;
        this.g.setColor(Color.MAGENTA);
        if (toggle == 1) {
            i = 1;
            this.g.drawLine(x, y, x + 5, y);
            this.g.drawLine(x + 5, y, x + 10, y - 20);
            this.g.drawLine(x + 10, y -= 20, x + 100, y);
        } else if (toggle == 0) {
            i = 1;
            this.g.drawLine(x, y -= 20, x + 5, y);
            this.g.drawLine(x + 5, y, x + 10, y + 20);
            this.g.drawLine(x + 10, y += 20, x + 100, y);
        } else if (toggle == 4) {
            for (i = 0; i < tstate; ++i) {
                this.g.drawLine(x + 100 * i, y - 20, x + 100 * (i + 1), y - 20);
            }
        }
        while (i < tstate) {
            this.g.drawLine(x + 100 * i, y, x + 100 * (i + 1), y);
            ++i;
        }
        this.g.setColor(Color.white);
    }

    private void signalActiveLow(int x, int y, int toggle, int tstate) {
        this.g.setColor(Color.MAGENTA);
        int i = 0;
        if (toggle == 0) {
            i = 1;
            this.g.drawLine(x, y, x + 5, y);
            this.g.drawLine(x + 5, y, x + 10, y - 20);
            this.g.drawLine(x + 10, y -= 20, x + 100, y);
        } else if (toggle == 1) {
            i = 1;
            this.g.drawLine(x, y -= 20, x + 5, y);
            this.g.drawLine(x + 5, y, x + 10, y + 20);
            this.g.drawLine(x + 10, y += 20, x + 100, y);
        }
        while (i < tstate) {
            this.g.drawLine(x + 100 * i, y, x + 100 * (i + 1), y);
            ++i;
        }
        this.g.setColor(Color.WHITE);
    }

    private int signalLogicHigh(int i) {
        if (i == 1) {
            if (this.io == 0) {
                return 1;
            }
            return 4;
        }
        if (i == 2) {
            if (this.s1 == 0) {
                return 1;
            }
            return 4;
        }
        if (this.s0 == 0) {
            return 1;
        }
        return 4;
    }

    private int signalLogicLow(int i) {
        if (i == 1) {
            if (this.io == 1) {
                return 0;
            }
            return 3;
        }
        if (i == 2) {
            if (this.s1 == 1) {
                return 0;
            }
            return 3;
        }
        if (this.s0 == 1) {
            return 0;
        }
        return 3;
    }

    private void opcodeFetch(int x, String address, String opcode) {
        this.opcodeFetchTable(x);
        this.clock(x, 4);
        this.A15A8(x, 4);
        this.AD7AD0(x, 4);
        this.ALE(x, 4);
        this.signalActiveHigh(x, 300, this.signalLogicLow(1), 4);
        this.signalActiveHigh(x, 340, this.signalLogicHigh(2), 4);
        this.signalActiveHigh(x, 380, this.signalLogicHigh(3), 4);
        this.controlSignal(x, 435, 1, 4);
        this.controlSignal(x, 475, 0, 4);
        this.io = 0;
        this.s1 = 1;
        this.s0 = 1;
        String highAddress = address.substring(0, 2);
        String lowAddress = address.substring(2, 4);
        this.g.drawString(highAddress + "   High-Order Memory Address", (x -= 70) + 148, 140);
        this.g.drawString(lowAddress + " Low-Order", x + 85, 180);
        this.g.drawString("Memory Address", x + 76, 200);
        this.g.drawString("Opcode Read " + opcode, x + 225, 180);
        this.g.drawString("Unspecified", x + 390, 140);
        this.g.drawString("Decodes Opcode", x + 373, 170);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 0", x + 210, 295);
        this.g.drawString("S1 = 1", x + 210, 335);
        this.g.drawString("S0 = 1", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 0", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 1", x + 210, 492);
    }

    private void memRead(int x, String address, String opcode) {
        this.memoryReadTable(x);
        this.clock(x, 3);
        this.A15A8(x, 3);
        this.AD7AD0(x, 3);
        this.ALE(x, 3);
        this.signalActiveHigh(x, 300, this.signalLogicLow(1), 3);
        this.signalActiveHigh(x, 340, this.signalLogicHigh(2), 3);
        this.signalActiveHigh(x, 380, this.signalLogicLow(3), 3);
        this.controlSignal(x, 435, 1, 3);
        this.controlSignal(x, 475, 0, 3);
        this.io = 0;
        this.s1 = 1;
        this.s0 = 0;
        String highAddress = address.substring(0, 2);
        String lowAddress = address.substring(2, 4);
        this.g.drawString(highAddress + "   High-Order Memory Address", (x -= 70) + 148, 140);
        this.g.drawString(lowAddress + " Low-Order", x + 85, 180);
        this.g.drawString("Memory Address", x + 76, 200);
        this.g.drawString("Opcode Read " + opcode, x + 225, 180);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 0", x + 210, 295);
        this.g.drawString("S1 = 1", x + 210, 335);
        this.g.drawString("S0 = 0", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 0", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 1", x + 210, 492);
    }

    private void memWrite(int x, String address, String opcode) {
        this.memoryWriteTable(x);
        this.clock(x, 3);
        this.A15A8(x, 3);
        this.AD7AD0(x, 3);
        this.ALE(x, 3);
        this.signalActiveHigh(x, 300, this.signalLogicLow(1), 3);
        this.signalActiveHigh(x, 340, this.signalLogicLow(2), 3);
        this.signalActiveHigh(x, 380, this.signalLogicHigh(3), 3);
        this.controlSignal(x, 435, 0, 3);
        this.controlSignal(x, 475, 1, 3);
        this.io = 0;
        this.s1 = 0;
        this.s0 = 1;
        String highAddress = address.substring(0, 2);
        String lowAddress = address.substring(2, 4);
        this.g.drawString(highAddress + "   High-Order Memory Address", (x -= 70) + 148, 140);
        this.g.drawString(lowAddress + " Low-Order", x + 85, 180);
        this.g.drawString("Memory Address", x + 76, 200);
        this.g.drawString("Opcode Write " + opcode, x + 225, 180);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 0", x + 210, 295);
        this.g.drawString("S1 = 0", x + 210, 335);
        this.g.drawString("S0 = 1", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 1", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 0", x + 210, 492);
    }

    private void ioRead(int x, String address, String opcode) {
        this.ioReadTable(x);
        this.clock(x, 3);
        this.A15A8(x, 3);
        this.AD7AD0(x, 3);
        this.ALE(x, 3);
        this.signalActiveHigh(x, 300, this.signalLogicHigh(1), 3);
        this.signalActiveHigh(x, 340, this.signalLogicHigh(2), 3);
        this.signalActiveHigh(x, 380, this.signalLogicLow(3), 3);
        this.controlSignal(x, 435, 1, 3);
        this.controlSignal(x, 475, 0, 3);
        this.io = 1;
        this.s1 = 1;
        this.s0 = 0;
        String highAddress = address.substring(0, 2);
        this.g.drawString("         Port Address " + highAddress, (x -= 70) + 148, 140);
        this.g.drawString("Port Address " + highAddress, x + 80, 180);
        this.g.drawString("   Input Data " + opcode, x + 225, 180);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 1", x + 210, 295);
        this.g.drawString("S1 = 1", x + 210, 335);
        this.g.drawString("S0 = 0", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 0", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 1", x + 210, 492);
    }

    private void ioWrite(int x, String address, String opcode) {
        this.ioWriteTable(x);
        this.clock(x, 3);
        this.A15A8(x, 3);
        this.AD7AD0(x, 3);
        this.ALE(x, 3);
        this.signalActiveHigh(x, 300, this.signalLogicHigh(1), 3);
        this.signalActiveHigh(x, 340, this.signalLogicLow(2), 3);
        this.signalActiveHigh(x, 380, this.signalLogicHigh(3), 3);
        this.controlSignal(x, 435, 0, 3);
        this.controlSignal(x, 475, 1, 3);
        this.io = 1;
        this.s1 = 0;
        this.s0 = 1;
        String highAddress = address.substring(0, 2);
        this.g.drawString("        Port Address " + highAddress, (x -= 70) + 148, 140);
        this.g.drawString("Port Address " + highAddress, x + 80, 180);
        this.g.drawString(" Output data " + opcode, x + 225, 180);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 1", x + 210, 295);
        this.g.drawString("S1 = 0", x + 210, 335);
        this.g.drawString("S0 = 1", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 1", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 0", x + 210, 492);
    }

    private void opcodeFetch6State(int x, String address, String opcode) {
        this.opcodeFetchTable6state(x);
        this.clock(x, 6);
        this.A15A8(x, 6);
        this.AD7AD0(x, 6);
        this.ALE(x, 6);
        this.signalActiveHigh(x, 300, this.signalLogicHigh(1), 6);
        this.signalActiveHigh(x, 340, this.signalLogicHigh(2), 6);
        this.signalActiveHigh(x, 380, this.signalLogicHigh(3), 6);
        this.controlSignal(x, 435, 0, 6);
        this.controlSignal(x, 475, 0, 6);
        this.io = 1;
        this.s1 = 1;
        this.s0 = 1;
        String highAddress = address.substring(0, 2);
        String lowAddress = address.substring(2, 4);
        this.g.drawString(highAddress + "   High-Order Memory Address", (x -= 70) + 148, 140);
        this.g.drawString("Decodes Opcode & the next memory address", x + 390, 140);
        this.g.drawString(lowAddress + " Low-Order", x + 85, 180);
        this.g.drawString("Memory Address", x + 76, 200);
        this.g.drawString("Opcode Read " + opcode, x + 225, 180);
        this.g.drawString("ALE = 1", x + 80, 230);
        this.g.drawString("ALE = 0", x + 210, 230);
        this.g.drawLine(x + 232, 283, x + 238, 283);
        this.g.drawString("IO / M = 1", x + 210, 295);
        this.g.drawString("S1 = 1", x + 210, 335);
        this.g.drawString("S0 = 1", x + 210, 375);
        this.g.drawLine(x + 211, 438, x + 225, 438);
        this.g.drawString("RD = 1", x + 210, 450);
        this.g.drawLine(x + 209, 480, x + 227, 480);
        this.g.drawString("WR = 1", x + 210, 492);
    }

    private void busIdle(int x) {
        this.busIdleTable(x);
        this.clock(x, 1);
        int y = 125;
        this.g.setColor(Color.yellow);
        this.g.drawLine(x, y, x + 100, y);
        this.g.drawLine(x, y + 20, x + 100, y + 20);
        this.g.setColor(new Color(255, 255, 170));
        y = 165;
        for (int i = 0; i < 100; i += 6) {
            this.g.drawLine(x + i, y + 10, x + 2 + i, y + 10);
        }
        y = 235;
        this.g.setColor(Color.blue);
        this.g.drawLine(x, y, x + 100, y);
        if (this.io == 1) {
            this.signalActiveHigh(x, 300, 4, 1);
        } else {
            this.signalActiveLow(x, 300, 4, 1);
        }
        if (this.s1 == 1) {
            this.signalActiveHigh(x, 340, 4, 1);
        } else {
            this.signalActiveLow(x, 340, 4, 1);
        }
        if (this.s0 == 1) {
            this.signalActiveHigh(x, 380, 4, 1);
        } else {
            this.signalActiveLow(x, 380, 4, 1);
        }
        y = 435;
        this.g.setColor(Color.RED);
        this.g.drawLine(x, y, x + 100, y);
        this.g.drawLine(x, y += 40, x + 100, y);
        this.g.setColor(Color.WHITE);
    }

    private void cycleDecoder(char choice, String address, String opcode) {
        if (choice == 'F') {
            this.opcodeFetch(this.x, address, opcode);
            this.x += 400;
        } else if (choice == 'S') {
            this.opcodeFetch6State(this.x, address, opcode);
            this.x += 600;
        } else if (choice == 'R') {
            this.memRead(this.x, address, opcode);
            this.x += 300;
        } else if (choice == 'W') {
            this.memWrite(this.x, address, opcode);
            this.x += 300;
        } else if (choice == 'I') {
            this.ioRead(this.x, address, opcode);
            this.x += 300;
        } else if (choice == 'O') {
            this.ioWrite(this.x, address, opcode);
            this.x += 300;
        } else if (choice == 'B') {
            this.busIdle(this.x);
            this.x += 100;
        } else if (choice == 'H') {
            this.memRead(this.x, this.o.engine.Dec2Hex(this.o.matrix.SP - 1), opcode);
            this.x += 300;
        } else if (choice == 'P') {
            this.memRead(this.x, this.o.engine.Dec2Hex(this.o.matrix.SP - 2), opcode);
            this.x += 300;
        }
    }

    public void memoryCycleDecoder(Assembler o, String address) {
        this.o = o;
        this.addressDec = o.engine.Hex2Dec(address);
        this.code = o.matrix.tstates(o.matrix.memory[this.addressDec]);
    }
}

