/*
 * Decompiled with CFR 0.152.
 */
package j51;

import j51.CpuUsage;
import j51.J51Panel;
import j51.intel.MCS51;
import j51.intel.MCS51Performance;
import j51.intel.ResetListener;
import j51.swing.JFactory;
import j51.swing.JHexWord;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JInfo
extends J51Panel
implements MCS51Performance,
ResetListener {
    JFormattedTextField oscillator = new JFormattedTextField(new DecimalFormat("###,###,##0"));
    JFormattedTextField clock = new JFormattedTextField(new DecimalFormat("###,###,##0"));
    SpinnerNumberModel cycleModel = new SpinnerNumberModel(1, 1, 16, 1);
    JSpinner cycle = new JSpinner(this.cycleModel);
    JHexWord reset;
    JTextField elapsed;
    CpuUsage min;
    CpuUsage max;
    CpuUsage avg;
    CpuUsage cur;
    private int minCpuUsage;
    private int maxCpuUsage;
    private int avgCpuUsage;

    public JInfo() {
        super("Information");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.oscillator.setColumns(15);
        this.clock.setColumns(15);
        this.reset = new JHexWord(true);
        this.elapsed = new JTextField(30);
        this.min = new CpuUsage("Min", Color.yellow);
        this.max = new CpuUsage("Max", Color.red);
        this.avg = new CpuUsage("Avg", Color.green);
        this.cur = new CpuUsage("Cur", Color.blue);
        this.min.setUsage(0);
        this.max.setUsage(100);
        this.avg.setUsage(50);
        this.cur.setUsage(25);
        JFactory.setBox(this.oscillator);
        JFactory.setBox(this.clock);
        JFactory.setBox(this.cycle);
        JFactory.setBox(this.reset);
        this.oscillator.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = JInfo.this.oscillator.getValue();
                int n = 0;
                if (object instanceof Number) {
                    n = ((Number)object).intValue();
                }
                JInfo.this.cpu.setOscillator(n);
            }
        });
        this.cycle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JInfo.this.cpu.machineCycle((Integer)JInfo.this.cycle.getValue());
            }
        });
        this.oscillator.setToolTipText("Selected oscillator in Hz");
        this.cycle.setToolTipText("Machina cycle in oscillator clock");
        this.clock.setToolTipText("Current clock counter");
        this.clock.setEditable(false);
        this.oscillator.setHorizontalAlignment(4);
        this.clock.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 3;
        this.add((Component)this.cur, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.min, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.max, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.avg, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Oscillator"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.oscillator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Cycle"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.cycle, gridBagConstraints);
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Clock"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.clock, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Reset at"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.reset, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 16;
        this.add((Component)new JLabel("Elapsed"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.elapsed, gridBagConstraints);
    }

    @Override
    public void reset(MCS51 mCS51) {
        this.minCpuUsage = 100;
        this.maxCpuUsage = 0;
        this.avgCpuUsage = 0;
        this.updateUsage(0);
    }

    private void updateUsage(int n) {
        this.min.setUsage(this.minCpuUsage);
        this.max.setUsage(this.maxCpuUsage);
        this.avg.setUsage(this.avgCpuUsage);
        this.cur.setUsage(n);
    }

    @Override
    public void setCpu(MCS51 mCS51) {
        super.setCpu(mCS51);
        this.reset(mCS51);
        mCS51.addPerformanceListener(this);
        mCS51.addResetListener(this);
    }

    @Override
    public void cpuPerformance(int n, int n2) {
        this.avgCpuUsage = (n + this.avgCpuUsage) / 2;
        if (n < this.minCpuUsage) {
            this.minCpuUsage = n;
        }
        if (n > this.maxCpuUsage) {
            this.maxCpuUsage = n;
        }
        this.updateUsage(n);
    }

    @Override
    public void setEmulation(boolean bl) {
        this.oscillator.setEditable(!bl);
        this.cycle.setEnabled(!bl);
        this.reset.setEditable(!bl);
    }

    public long updateClock(StringBuffer stringBuffer, String string, long l, long l2) {
        long l3 = l / l2;
        if (l3 > 0L) {
            stringBuffer.append(l3 + " " + string + " ");
            l -= l2 * l3;
        }
        return l;
    }

    public void updateClock() {
        long l = this.cpu.clock();
        this.clock.setValue(l);
        l *= 1000000L;
        l /= (long)this.cpu.getOscillator();
        StringBuffer stringBuffer = new StringBuffer();
        l = this.updateClock(stringBuffer, "day", l, 86400000000L);
        l = this.updateClock(stringBuffer, "hour", l, 3600000000L);
        l = this.updateClock(stringBuffer, "min", l, 60000000L);
        l = this.updateClock(stringBuffer, "sec", l, 1000000L);
        l = this.updateClock(stringBuffer, "ms", l, 1000L);
        l = this.updateClock(stringBuffer, "us", l, 1L);
        this.elapsed.setText(stringBuffer.toString());
    }

    @Override
    public void update(boolean bl) {
        this.oscillator.setValue(this.cpu.getOscillator());
        this.updateClock();
        this.cycle.setValue(this.cpu.machineCycle());
    }
}

