/*
 * Decompiled with CFR 0.152.
 */
package j51;

import j51.J51Panel;
import j51.swing.JHexByte;
import j51.swing.JHexField;
import j51.swing.JHexWord;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class JRegister
extends J51Panel {
    private JLabel la;
    private JLabel lb;
    private JLabel lsp;
    private JLabel lpc;
    private JLabel ldpl;
    private JLabel ldph;
    private JLabel ldptr;
    private JLabel lpsw;
    private JLabel[] lr = new JLabel[8];
    private JHexField a;
    private JHexField b;
    private JHexField pc;
    private JHexField dpl;
    private JHexField dph;
    private JHexField dptr;
    private JHexField sp;
    private JHexField psw;
    private JHexField[] r = new JHexField[8];
    private ActionListener listener = null;

    JRegister() {
        super("Register");
        int n;
        this.la = new JLabel("A");
        this.lb = new JLabel("B");
        this.lsp = new JLabel("SP");
        this.lpc = new JLabel("PC");
        this.ldpl = new JLabel("DPL");
        this.ldph = new JLabel("DPH");
        this.ldptr = new JLabel("DPTR ");
        this.lpsw = new JLabel("PSW");
        for (n = 0; n < 8; ++n) {
            this.lr[n] = new JLabel("R" + n);
        }
        this.a = new JHexByte();
        this.b = new JHexByte();
        this.sp = new JHexByte();
        this.pc = new JHexWord();
        this.dpl = new JHexByte();
        this.dph = new JHexByte();
        this.dptr = new JHexWord();
        this.psw = new JHexByte();
        for (n = 0; n < 8; ++n) {
            this.r[n] = new JHexByte();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.addRegister(this.la, this.a, gridBagConstraints);
        this.addRegister(this.lb, this.b, gridBagConstraints);
        for (int i = 0; i < 8; ++i) {
            this.addRegister(this.lr[i], this.r[i], gridBagConstraints);
            this.r[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JRegister.this.cpu.pc(JRegister.this.pc.getValue());
                        if (JRegister.this.listener != null) {
                            JRegister.this.listener.actionPerformed(new ActionEvent(this, 0, "PC"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this.addRegister(this.lsp, this.sp, gridBagConstraints);
        this.addRegister(this.lpsw, this.psw, gridBagConstraints);
        this.addRegister(this.lpc, this.pc, gridBagConstraints);
        this.addRegister(this.ldpl, this.dpl, gridBagConstraints);
        this.addRegister(this.ldph, this.dph, gridBagConstraints);
        this.addRegister(this.ldptr, this.dptr, gridBagConstraints);
        this.pc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.pc(JRegister.this.pc.getValue());
                    if (JRegister.this.listener != null) {
                        JRegister.this.listener.actionPerformed(new ActionEvent(this, 0, "PC"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.sp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.sp(JRegister.this.sp.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.acc(JRegister.this.a.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.b(JRegister.this.b.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.psw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.psw(JRegister.this.psw.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.dpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.dpl(JRegister.this.dpl.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.dph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.dph(JRegister.this.dph.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.dptr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JRegister.this.cpu.dptr(JRegister.this.dptr.getValue());
                    JRegister.this.fireChangeSfr();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void fireChangeSfr() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "SFR"));
        }
    }

    public void setChangeListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    private void addRegister(JLabel jLabel, JHexField jHexField, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 2;
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jHexField.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        this.add((Component)jHexField, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    @Override
    public void update(boolean bl) {
        this.a.setValue(this.cpu.acc());
        this.b.setValue(this.cpu.b());
        this.sp.setValue(this.cpu.sp());
        this.pc.setValue(this.cpu.pc());
        this.dpl.setValue(this.cpu.dpl());
        this.dph.setValue(this.cpu.dph());
        this.dptr.setValue(this.cpu.dptr());
        this.psw.setValue(this.cpu.psw());
        for (int i = 0; i < 8; ++i) {
            this.r[i].setValue(this.cpu.r(i));
        }
    }

    @Override
    public void setEmulation(boolean bl) {
        this.a.setEditable(!bl);
        this.b.setEditable(!bl);
        this.sp.setEditable(!bl);
        this.pc.setEditable(!bl);
        this.dpl.setEditable(!bl);
        this.dph.setEditable(!bl);
        this.dptr.setEditable(!bl);
        this.psw.setEditable(!bl);
        for (int i = 0; i < 8; ++i) {
            this.r[i].setEditable(!bl);
        }
    }
}

