/*
 * Decompiled with CFR 0.152.
 */
package j51.diseqc;

import j51.diseqc.Motor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Satellite
extends JComponent
implements Motor {
    private String sPos = "";
    private Font font = new Font("Monospaced", 1, 20);
    private ImageIcon sat;
    private int pos;
    private long time = 0L;

    public Satellite() {
        int n = 200;
        int n2 = 80;
        this.sat = this.getIcon("satellite.gif");
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setPosition(0);
    }

    @Override
    public void setPosition(int n) {
        this.pos = n;
        Double d = (double)n / 10.0;
        this.sPos = d == 0.0 ? "00.0" : (n < 0 ? -d.doubleValue() + "E" : d + "W");
        while (this.sPos.length() < 5) {
            this.sPos = " " + this.sPos;
        }
        long l = System.currentTimeMillis();
        if (l > this.time) {
            this.time = l + 100L;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.sat != null) {
            int n3 = dimension.width - 36;
            n2 = this.pos / 30;
            if (n2 < 0) {
                n2 = -n2;
            }
            this.pos = this.pos < 0 ? 900 - this.pos : 900 - this.pos;
            n = this.pos * n3 / 1800;
            graphics.drawImage(this.sat.getImage(), n, 6 + n2, this.sat.getImageObserver());
        }
        graphics.setColor(Color.red);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = (dimension.width - fontMetrics.charWidth('W') * this.sPos.length()) / 2;
        n2 = dimension.height - 3;
        graphics.drawString(this.sPos, n, n2);
    }

    public ImageIcon getIcon(String string) {
        URL uRL = Satellite.class.getResource("images/" + string);
        if (uRL == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public static void main(String[] stringArray) {
        final Satellite satellite = new Satellite();
        JFrame jFrame = new JFrame("Test Satellite");
        jFrame.setContentPane(satellite);
        jFrame.pack();
        jFrame.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 900; i >= -900; i -= 9) {
                    satellite.setPosition(i);
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        thread.start();
    }
}

