/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.ResetListener;
import j51.intel.SfrWriteListener;
import j51.swing.JBitField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class BytePort
extends JBitField
implements SfrWriteListener,
MCS51Peripheral,
ResetListener {
    private MCS51 cpu;
    private int sfr = -1;
    private int disableMask;

    public BytePort(String string) {
        super(string, false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BytePort.this.cpu.addRunQueue(new Runnable(){

                    @Override
                    public void run() {
                        BytePort.this.cpu.sfr(BytePort.this.sfr, BytePort.this.getValue());
                    }
                });
            }
        });
    }

    @Override
    public void reset(MCS51 mCS51) {
        this.setValue(0);
    }

    public void setSfr(int n) {
        this.sfr = n;
    }

    public int getSfr() {
        return this.sfr;
    }

    public void setDisableMask(int n) {
        for (int i = 0; i < 8; ++i) {
            if ((n & 1 << i) == 0) continue;
            this.setDisabled(i, true);
        }
    }

    @Override
    public void sfrWrite(int n, int n2) {
        this.setValue(n2);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        if (this.sfr != -1) {
            mCS51.addSfrWriteListener(this.sfr, this);
            mCS51.addUpdatableComponent(this);
        }
        mCS51.addResetListener(this);
    }
}

