/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.VolatileMemory;
import j51.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Timer;

public class PersistentMemory
extends VolatileMemory {
    private static Logger log = Logger.getLogger(PersistentMemory.class);
    private Timer timer = null;
    private boolean loaded = false;

    public PersistentMemory(String string, String string2, int n) {
        super(string, string2, n);
        this.load();
    }

    @Override
    public void write(int n, int n2) {
        byte by = (byte)(n2 & 0xFF);
        if (this.readDirect(n) != n2) {
            if (this.timer == null) {
                this.timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PersistentMemory.this.timer.stop();
                        PersistentMemory.this.save();
                    }
                });
                this.timer.start();
            } else {
                this.timer.restart();
            }
        }
        super.write(n, n2);
    }

    private synchronized void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.getName()));
            for (int i = 0; i < this.getSize(); ++i) {
                byte by = (byte)this.readDirect(i);
                fileOutputStream.write(by);
            }
            fileOutputStream.close();
            log.info(this.getName() + " saved " + this.getSize() + " bytes");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.getName()));
            for (int i = 0; i < this.getSize(); ++i) {
                byte[] byArray = new byte[1];
                fileInputStream.read(byArray);
                this.writeDirect(i, byArray[0]);
            }
            fileInputStream.close();
            log.info(this.getName() + " loaded " + this.getSize() + " bytes");
            this.loaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSize(int n) {
        if (this.getSize() != n) {
            super.setSize(n);
            this.load();
        }
    }
}

