/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.Memory;
import j51.intel.MemoryByte;
import j51.intel.MemoryReadListener;
import j51.intel.MemoryWriteListener;
import j51.util.FastArray;
import j51.util.Hex;
import j51.util.Logger;

public class VolatileMemory
implements Memory {
    private static Logger log = Logger.getLogger(VolatileMemory.class);
    protected String name = "";
    protected MemoryByte[] memory = new MemoryByte[0];
    private boolean writeListener;
    private int size = 0;

    public VolatileMemory() {
        this(0);
    }

    public VolatileMemory(int n) {
        this("Memory", n);
    }

    public VolatileMemory(String string, int n) {
        this(string, "memory", n);
    }

    public VolatileMemory(String string, String string2, int n) {
        this.name = string + "." + n + "." + string2;
        this.setLimit(65536);
        this.setSize(n);
        this.writeListener = true;
    }

    @Override
    public boolean getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setWriteListener(boolean bl) {
        this.writeListener = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setLimit(int n) {
        if (n < this.memory.length) {
            return;
        }
        this.memory = new MemoryByte[n];
        int n2 = this.memory.length;
        while (--n2 >= 0) {
            this.memory[n2] = new MemoryByte();
        }
    }

    @Override
    public void setSize(int n) {
        this.setLimit(n);
        if (this.size != n) {
            this.setPresent(0, n);
            log.fine(this.name + " Resize from " + this.size + " to " + n);
            this.size = n;
        }
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public void setPresent(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.memory[i].present = true;
        }
    }

    @Override
    public boolean isPresent(int n) {
        return this.memory[n].present;
    }

    private final void checkAddress(int n, String string) {
        if (!this.isPresent(n)) {
            throw new Error(this.name + string + " AT 0x" + Hex.bin2word(n) + " out of range, Max 0x" + Hex.bin2word(this.size));
        }
    }

    @Override
    public final int readDirect(int n) {
        this.checkAddress(n, "Read direct");
        return this.memory[n].value & 0xFF;
    }

    @Override
    public final int read(int n) {
        this.checkAddress(n, "Read");
        MemoryByte memoryByte = this.memory[n];
        int n2 = memoryByte.value;
        if (memoryByte.mr != null) {
            if (!memoryByte.readBusy) {
                memoryByte.readBusy = true;
                int n3 = memoryByte.mr.size();
                while (--n3 >= 0) {
                    n2 = memoryByte.mr.get(n3).readMemory(n, n2);
                }
                memoryByte.readBusy = false;
            } else {
                log.fine("Read busy at " + Hex.bin2word(n) + " Memory " + this);
            }
        }
        return n2 & 0xFF;
    }

    @Override
    public final void writeDirect(int n, int n2) {
        this.checkAddress(n, "Write direct");
        this.memory[n].value = n2;
    }

    @Override
    public void write(int n, int n2) {
        this.checkAddress(n, "Write");
        MemoryByte memoryByte = this.memory[n];
        int n3 = memoryByte.value;
        memoryByte.value = n2;
        if (this.writeListener && memoryByte.mw != null) {
            if (!memoryByte.writeBusy) {
                memoryByte.writeBusy = true;
                int n4 = memoryByte.mw.size();
                while (--n4 >= 0) {
                    memoryByte.mw.get(n4).writeMemory(n, n2, n3);
                }
                memoryByte.writeBusy = false;
            } else {
                log.fine("Write busy at " + Hex.bin2word(n) + " Memory " + this);
            }
        }
    }

    @Override
    public void addMemoryReadListener(int n, MemoryReadListener memoryReadListener) {
        MemoryByte memoryByte = this.memory[n];
        memoryByte.present = true;
        if (memoryByte.mr == null) {
            memoryByte.mr = new FastArray();
        }
        memoryByte.mr.add(memoryReadListener);
    }

    @Override
    public void addMemoryWriteListener(int n, MemoryWriteListener memoryWriteListener) {
        MemoryByte memoryByte = this.memory[n];
        memoryByte.present = true;
        if (memoryByte.mw == null) {
            memoryByte.mw = new FastArray();
        }
        memoryByte.mw.add(memoryWriteListener);
    }

    public void setName(int n, String string) {
        this.memory[n].setName(string);
    }

    public String getName(int n) {
        return this.memory[n].getName();
    }

    protected MemoryByte getMemory(int n) {
        return this.memory[n];
    }

    protected void setMemory(int n, MemoryByte memoryByte) {
        this.memory[n] = memoryByte;
    }

    public String toString() {
        return this.name;
    }
}

