/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(ASN1Set s) {
        int i = 0;
        while (i != s.size()) {
            Attribute a = Attribute.getInstance(s.getObjectAt(i));
            this.attributes.put(a.getAttrType(), a);
            ++i;
        }
    }

    public AttributeTable(DEREncodableVector v) {
        int i = 0;
        while (i != v.size()) {
            Attribute a = Attribute.getInstance(v.get(i));
            this.attributes.put(a.getAttrType(), a);
            ++i;
        }
    }

    public AttributeTable(Hashtable attrs) {
        this.attributes = new Hashtable(attrs);
    }

    public Attribute get(DERObjectIdentifier oid) {
        return (Attribute)this.attributes.get(oid);
    }

    public Hashtable toHashtable() {
        return new Hashtable(this.attributes);
    }
}

