/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] args) {
        EqualsAndHashCodeTest test = new EqualsAndHashCodeTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        byte[] data = new byte[]{0, 1, 0, 1, 0, 0, 1};
        DERObject[] values = new DERObject[]{new BERConstructedOctetString(data), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(64, data), new DERBitString(data), new DERBMPString("hello world"), new DERBoolean(true), new DERBoolean(false), new DEREnumerated(100), new DERGeneralizedTime(new Date()), new DERGeneralString("hello world"), new DERIA5String("hello"), new DERInteger(1000), new DERNull(), new DERNumericString("123456"), new DERObjectIdentifier("1.1.1.10000.1"), new DEROctetString(data), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(data), new DERUnknownTag(63, data), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world")};
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            int i = 0;
            while (i != values.length) {
                aOut.writeObject(values[i]);
                ++i;
            }
            DERObject[] readValues = new DERObject[values.length];
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            int i2 = 0;
            while (i2 != values.length) {
                DERObject o = aIn.readObject();
                if (!o.equals(values[i2])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + o);
                }
                if (o.hashCode() != values[i2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + o);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

