/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.asn1.misc.IDEACBCPar;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.misc.NetscapeRevocationURL;
import org.bouncycastle.asn1.misc.VerisignCzagExtension;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MiscTest
implements Test {
    public String getName() {
        return "Misc";
    }

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        MiscTest test = new MiscTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        byte[] testIv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] values = new ASN1Encodable[]{new CAST5CBCParameters(testIv, 128), new NetscapeCertType(32), new VerisignCzagExtension(new DERIA5String("hello")), new IDEACBCPar(testIv), new NetscapeRevocationURL(new DERIA5String("http://test"))};
        byte[] data = Base64.decode("MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            int i = 0;
            while (i != values.length) {
                aOut.writeObject(values[i]);
                ++i;
            }
            DERObject[] readValues = new DERObject[values.length];
            if (!this.isSameAs(bOut.toByteArray(), data)) {
                return new SimpleTestResult(false, this.getName() + ": Failed data check");
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            int i2 = 0;
            while (i2 != values.length) {
                DERObject o = aIn.readObject();
                if (!values[i2].equals(o)) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + o);
                }
                if (o.hashCode() != values[i2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + o);
                }
                ++i2;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
    }
}

