/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Encodable {
    ASN1Sequence seq;

    public GeneralNames(ASN1Sequence seq) {
        this.seq = seq;
    }

    public GeneralNames(GeneralName name) {
        this.seq = new DERSequence(name);
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GeneralNames getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public GeneralName[] getNames() {
        GeneralName[] names = new GeneralName[this.seq.size()];
        int i = 0;
        while (i != this.seq.size()) {
            names[i] = GeneralName.getInstance(this.seq.getObjectAt(i));
            ++i;
        }
        return names;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

