/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public abstract class X509NameEntryConverter {
    protected boolean canBePrintable(String str) {
        int i = str.length() - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (str.charAt(i) > '\u007f') {
                return false;
            }
            if (!('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9')) {
                switch (ch) {
                    case ' ': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case ':': 
                    case '=': 
                    case '?': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            --i;
        }
        return true;
    }

    protected boolean canBeUTF8(String str) {
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) > '\u00ff') {
                return false;
            }
            --i;
        }
        return true;
    }

    protected DERObject convertHexEncoded(String str, int off) throws IOException {
        str = str.toLowerCase();
        byte[] data = new byte[str.length() / 2];
        int index = 0;
        while (index != data.length) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
            } else {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
            }
            ++index;
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(data));
        return aIn.readObject();
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

