/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        DSAParameters dsaParams = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = dsaParams.getQ();
        BigInteger p = dsaParams.getP();
        BigInteger g = dsaParams.getG();
        do {
            x = new BigInteger(160, random);
        } while (x.equals(ZERO) || x.compareTo(q) >= 0);
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }
}

