/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BlockCipherVectorTest
implements Test {
    BlockCipher engine;
    int id;
    byte[] input;
    byte[] output;
    CipherParameters param;

    public BlockCipherVectorTest(int id, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Vector Test " + this.id;
    }

    private boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TestResult perform() {
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        int len1 = cipher.processBytes(this.input, 0, this.input.length, out, 0);
        try {
            cipher.doFinal(out, len1);
        }
        catch (CryptoException e) {
            return new SimpleTestResult(false, this.getName() + ": failed - exception " + e.toString());
        }
        if (!this.isEqualArray(out, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        int len2 = cipher.processBytes(this.output, 0, this.output.length, out, 0);
        try {
            cipher.doFinal(out, len2);
        }
        catch (CryptoException e) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal - exception " + e.toString());
        }
        if (!this.isEqualArray(this.input, out)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal got " + new String(Hex.encode(out)));
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }
}

