/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MD5DigestTest
implements Test {
    private static String resVec1;
    private static String resVec2;
    private static String resVec3;
    private static String resVec4;
    private static String testVec1;
    private static String testVec2;
    private static String testVec3;
    private static String testVec4;

    static {
        testVec1 = "";
        resVec1 = "d41d8cd98f00b204e9800998ecf8427e";
        testVec2 = "61";
        resVec2 = "0cc175b9c0f1b6a831c399e269772661";
        testVec3 = "616263";
        resVec3 = "900150983cd24fb0d6963f7d28e17f72";
        testVec4 = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
        resVec4 = "c3fcd3d76192e4007dfb496cca67e13b";
    }

    public String getName() {
        return "MD5";
    }

    public static void main(String[] args) {
        MD5DigestTest test = new MD5DigestTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        MD5Digest digest = new MD5Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        digest.doFinal(resBuf, 0);
        String resStr = new String(Hex.encode(resBuf));
        if (!resVec1.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        byte[] bytes = Hex.decode(testVec2);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec2.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec3);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec3.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length / 2);
        MD5Digest d = new MD5Digest(digest);
        digest.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        d.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        d.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

