/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.CorruptHeaderException;
import helliker.id3.NoMPEGFramesException;
import helliker.id3.XingVBRHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class MPEGAudioFrameHeader
implements Serializable {
    private final int HEADER_SIZE = 4;
    private final int MAX_TRIES = 9;
    public static final int MONO_MODE = 3;
    public static final int MPEG_L_1 = 3;
    public static final int MPEG_L_2 = 2;
    public static final int MPEG_L_3 = 1;
    public static final int MPEG_V_1 = 3;
    public static final int MPEG_V_2 = 2;
    public static final int MPEG_V_25 = 0;
    private final String TAG_START = "ID3";
    private int bitRate;
    private final int[][] bitrateTable = new int[][]{{-2, -2, -2, -2, -2}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private final String[] channelLabels;
    private int channelMode;
    private boolean copyrighted;
    private boolean crced;
    private int emphasis;
    private final String[] emphasisLabels;
    private int frameLength;
    private int layer;
    private final String[] layerLabels;
    private long location;
    private File mp3 = null;
    private boolean original;
    private boolean padding;
    private boolean privateBit;
    private int sampleRate;
    private final int[][] sampleTable = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
    private final int[] slotLength;
    private int version;
    private final String[] versionLabels = new String[]{"MPEG Version 2.5", null, "MPEG Version 2.0", "MPEG Version 1.0"};
    private XingVBRHeader xingHead = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MPEGAudioFrameHeader(File mp3, int offset) throws NoMPEGFramesException, FileNotFoundException, IOException, CorruptHeaderException {
        this.layerLabels = new String[]{null, "Layer III", "Layer II", "Layer I"};
        this.channelLabels = new String[]{"Stereo", "Joint Stereo (STEREO)", "Dual Channel (STEREO)", "Single Channel (MONO)"};
        this.emphasisLabels = new String[]{"none", "50/15 ms", null, "CCIT J.17"};
        this.slotLength = new int[]{-1, 1, 1, 4};
        this.mp3 = mp3;
        this.version = -1;
        this.layer = -1;
        this.bitRate = -1;
        this.sampleRate = -1;
        this.channelMode = -1;
        this.copyrighted = false;
        this.crced = false;
        this.original = false;
        this.emphasis = -1;
        this.location = -1L;
        this.padding = false;
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(mp3, "r");
            this.location = this.findOffset(in, offset, 9);
            if (this.location == -1L) {
                throw new NoMPEGFramesException();
            }
            this.readHeader(in, this.location);
            this.xingHead = new XingVBRHeader(in, this.location, this.layer, this.version, this.sampleRate, this.channelMode);
            Object var5_4 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public MPEGAudioFrameHeader(File mp3) throws NoMPEGFramesException, FileNotFoundException, IOException, CorruptHeaderException {
        this(mp3, 0);
    }

    private void findBitRate(int bitrateIndex) {
        int ind = -1;
        if (this.version == 3) {
            if (this.layer == 3) {
                ind = 0;
            } else if (this.layer == 2) {
                ind = 1;
            } else if (this.layer == 1) {
                ind = 2;
            }
        } else if (this.version == 2 || this.version == 0) {
            if (this.layer == 3) {
                ind = 3;
            } else if (this.layer == 2 || this.layer == 1) {
                ind = 4;
            }
        }
        if (ind != -1 && bitrateIndex >= 0 && bitrateIndex <= 15) {
            this.bitRate = this.bitrateTable[bitrateIndex][ind];
        }
    }

    private long findOffset(RandomAccessFile in, long offset, int maxTries) throws CorruptHeaderException, IOException {
        byte[] b;
        String s;
        long loc = -1L;
        in.seek(offset);
        long new_offset = offset;
        if (offset == 0L && (s = new String(b = new byte[]{in.readByte(), in.readByte(), in.readByte()})).equals("ID3")) {
            in.seek(in.getFilePointer() + 3L);
            byte[] b2 = new byte[]{in.readByte(), in.readByte(), in.readByte(), in.readByte()};
            new_offset = BinaryParser.convertToSynchsafeInt(b2);
        }
        in.seek(new_offset);
        boolean curTry = true;
        while (loc == -1L) {
            byte test = in.readByte();
            if (!BinaryParser.matchPattern(test, "11111111")) continue;
            test = in.readByte();
            if (BinaryParser.matchPattern(test, "111xxxxx") && !BinaryParser.matchPattern(test, "xxxxx00x")) {
                test = in.readByte();
                if (!BinaryParser.matchPattern(test, "1111xxxx") && !BinaryParser.matchPattern(test, "xxxx11xx")) {
                    test = in.readByte();
                    if (!BinaryParser.matchPattern(test, "xxxxxx10")) {
                        loc = in.getFilePointer() - 4L;
                        continue;
                    }
                    in.seek(in.getFilePointer() - 3L);
                    continue;
                }
                in.seek(in.getFilePointer() - 2L);
                continue;
            }
            in.seek(in.getFilePointer() - 1L);
        }
        return loc;
    }

    private void findSampleRate(int sampleIndex) {
        int ind = -1;
        switch (this.version) {
            case 3: {
                ind = 0;
                break;
            }
            case 2: {
                ind = 1;
                break;
            }
            case 0: {
                ind = 2;
            }
        }
        if (ind != -1 && sampleIndex >= 0 && sampleIndex <= 3) {
            this.sampleRate = this.sampleTable[sampleIndex][ind];
        }
    }

    public int getBitRate() {
        int br = 0;
        br = this.xingHead.headerExists() ? this.xingHead.getAvgBitrate() : this.bitRate;
        return br;
    }

    public String getChannelMode() {
        String str = null;
        if (this.channelMode >= 0 && this.channelMode < this.channelLabels.length) {
            str = this.channelLabels[this.channelMode];
        }
        return str;
    }

    public String getEmphasis() {
        String str = null;
        if (this.emphasis >= 0 && this.emphasis < this.emphasisLabels.length) {
            str = this.emphasisLabels[this.emphasis];
        }
        return str;
    }

    public int getFrameLength() {
        int length = -1;
        int padAmount = 0;
        if (this.padding) {
            padAmount = this.slotLength[this.layer];
        }
        length = this.layer == 3 ? (12 * (this.bitRate * 1000) / this.sampleRate + padAmount) * 4 : 144 * (this.bitRate * 1000) / this.sampleRate + padAmount;
        return length;
    }

    public String getLayer() {
        String str = null;
        if (this.layer >= 0 && this.layer < this.layerLabels.length) {
            str = this.layerLabels[this.layer];
        }
        return str;
    }

    public long getLocation() {
        return this.location;
    }

    public int getNumFrames() {
        int num = 0;
        num = this.xingHead.headerExists() ? this.xingHead.getNumFrames() : (int)(this.mp3.length() - this.location) / this.getFrameLength();
        return num;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getVBRPlayingTime() {
        return this.xingHead.getPlayingTime();
    }

    public String getVersion() {
        String str = null;
        if (this.version >= 0 && this.version < this.versionLabels.length) {
            str = this.versionLabels[this.version];
        }
        return str;
    }

    public boolean hasPadding() {
        return this.padding;
    }

    public boolean isCopyrighted() {
        return this.copyrighted;
    }

    public boolean isMP3() {
        return this.layer == 1;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public boolean isProtected() {
        return this.crced;
    }

    public boolean isVBR() {
        return this.xingHead.headerExists();
    }

    public boolean privateBitSet() {
        return this.privateBit;
    }

    private void readHeader(RandomAccessFile raf, long location) throws IOException, CorruptHeaderException {
        byte[] head = new byte[4];
        raf.seek(location);
        if (raf.read(head) != 4) {
            throw new CorruptHeaderException("Error reading MPEG frame header.");
        }
        this.version = BinaryParser.convertToDecimal(head[1], 3, 4);
        this.layer = BinaryParser.convertToDecimal(head[1], 1, 2);
        this.findBitRate(BinaryParser.convertToDecimal(head[2], 4, 7));
        this.findSampleRate(BinaryParser.convertToDecimal(head[2], 2, 3));
        this.padding = BinaryParser.bitSet(head[2], 1);
        this.privateBit = BinaryParser.bitSet(head[2], 0);
        this.channelMode = BinaryParser.convertToDecimal(head[3], 6, 7);
        this.copyrighted = BinaryParser.bitSet(head[3], 3);
        this.crced = !BinaryParser.bitSet(head[1], 0);
        this.original = BinaryParser.bitSet(head[3], 2);
        this.emphasis = BinaryParser.convertToDecimal(head[3], 0, 1);
    }

    public String toString() {
        String str = new String();
        str = this.getVersion() + " " + this.getLayer() + "\nBitRate:\t\t\t" + this.getBitRate() + "kbps\nSampleRate:\t\t\t" + this.getSampleRate() + "Hz\nChannelMode:\t\t\t" + this.getChannelMode() + "\nCopyrighted:\t\t\t" + this.isCopyrighted() + "\nOriginal:\t\t\t" + this.isOriginal() + "\nCRC:\t\t\t\t" + this.isProtected() + "\nEmphasis:\t\t\t" + this.getEmphasis() + "\nOffset:\t\t\t\t" + this.getLocation() + "\nPrivateBit:\t\t\t" + this.privateBitSet() + "\nPadding:\t\t\t" + this.hasPadding() + "\nFrameLength:\t\t\t" + this.getFrameLength() + "\nVBR:\t\t\t\t" + this.isVBR() + "\nNumFrames:\t\t\t\t" + this.getNumFrames();
        if (this.isVBR()) {
            str = str + "\n" + this.xingHead.toString();
        }
        return str;
    }
}

