/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.Router;
import ants.p2p.query.QueryMessage;
import org.apache.log4j.Logger;

class RouterWatchDog
extends Thread {
    static Logger _logger = Logger.getLogger((String)RouterWatchDog.class.getName());
    Router r = null;
    boolean terminate = false;

    public RouterWatchDog(Router r) {
        this.r = r;
        this.setPriority(1);
    }

    public void terminate() {
        this.terminate = true;
    }

    public void run() {
        long init = System.currentTimeMillis();
        while (!this.terminate) {
            try {
                RouterWatchDog.sleep(5000L);
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
            long elapsed = System.currentTimeMillis() - init;
            if (elapsed > Router.routeTimeout && !this.terminate) {
                _logger.info((Object)"Routing stopped...");
                for (int x = 0; this.r.st != null && x < this.r.st.length; ++x) {
                    try {
                        if (this.r.st[x] == null) continue;
                        this.r.st[x].interruptSending();
                        continue;
                    }
                    catch (ThreadDeath td) {
                        _logger.info((Object)"Routing timed out: message killed");
                    }
                }
                try {
                    if (this.r != null) {
                        this.r.interrupt();
                    }
                }
                catch (ThreadDeath td) {
                    _logger.info((Object)"Routing timed out: message killed");
                }
                try {
                    while (this.r.isAlive()) {
                        this.r.join(5000L);
                        _logger.warn((Object)("[" + Ant.beingRoutedMessages + "]Router waiting for " + this.r.m + "  routing = " + this.r.routingMessages));
                        if (!(this.r.m instanceof QueryMessage)) continue;
                        _logger.info((Object)(((QueryMessage)this.r.m).getQuery() + "   " + this.r.m.getType()));
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                Ant.decBeingRoutedMessages();
                return;
            }
            _logger.debug((Object)("[" + Ant.beingRoutedMessages + "]Router idle for " + this.r.m + "  routing = " + this.r.routingMessages));
        }
        Ant.decBeingRoutedMessages();
    }
}

