/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.filesharing.InterruptedDownload;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.DownloadAntPanel;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryFileTupleComparator;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryManager;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.query.security.AsymmetricProvider;
import ants.p2p.security.EndpointSecurityManager;
import ants.p2p.utils.indexer.BackgroundEngine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoresumeEngine
extends Thread
implements PropertyChangeListener {
    MultipleSourcesDownloadManager msdm;
    InterruptedDownload interruptedDownload;
    WarriorAnt n;
    DownloadAntPanel dap;
    ArrayList currentSupernodeSet = new ArrayList();
    boolean terminate = false;
    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    QueryMessage currentQuery = null;
    QueryMessage[] currentSupernodeQueries = new QueryMessage[0];
    List secureConnectionRequired = new ArrayList();
    static int secureConnectionToTrace = 1000;
    public int sleepRate = 180000 + (int)(System.currentTimeMillis() % 30L * 1000L);
    static Logger _logger = Logger.getLogger((String)AutoresumeEngine.class.getName());

    public AutoresumeEngine(MultipleSourcesDownloadManager msdm, DownloadAntPanel dap) {
        this.msdm = msdm;
        this.n = msdm.n;
        this.dap = dap;
        this.interruptedDownload = null;
        this.n.propertyChangeSupport.addPropertyChangeListener(this);
        this.pcs.addPropertyChangeListener(dap);
        this.setMultipleSourcesDownloadManager(msdm);
        this.setPriority(1);
    }

    public AutoresumeEngine(InterruptedDownload interruptedDownload, WarriorAnt n, DownloadAntPanel dap) {
        this.msdm = null;
        this.interruptedDownload = interruptedDownload;
        this.n = n;
        this.dap = dap;
        this.n.propertyChangeSupport.addPropertyChangeListener(this);
        this.pcs.addPropertyChangeListener(dap);
        this.setInterruptedDownload(interruptedDownload);
        this.setPriority(1);
    }

    public void deactivate() {
        if (this.n != null) {
            this.n.propertyChangeSupport.removePropertyChangeListener(this);
        }
        this.terminate = true;
        if (this.msdm != null) {
            _logger.info((Object)("Autoresume Engine deactivated for file: " + this.msdm.getFileHash()));
            this.msdm = null;
        } else if (this.interruptedDownload != null) {
            _logger.info((Object)("Autoresume Engine deactivated for file: " + this.interruptedDownload.getFileHash()));
            this.interruptedDownload = null;
        }
    }

    public boolean deactivated() {
        return this.terminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(System.currentTimeMillis() % 60L * 1000L);
            while (!this.n.isDisconnected() && !this.terminate) {
                AutoresumeEngine autoresumeEngine = this;
                synchronized (autoresumeEngine) {
                    Message query;
                    int x;
                    MessageWrapper[] queryWrappers;
                    ArrayList supernodesSubset;
                    PropertyChangeEvent pce;
                    ArrayList resultSet;
                    QueryManager queryManager;
                    AsymmetricProvider ap;
                    QueryHashItem qsi;
                    if (this.interruptedDownload != null) {
                        if (this.interruptedDownload.ae != this) {
                            this.terminate = true;
                        }
                        if (DownloadAntPanel.maxConcurrentDownloads == 0 || this.dap.getActiveDownloadsNumber() < DownloadAntPanel.maxConcurrentDownloads) {
                            _logger.info((Object)(this + "Autoresume is running for file (interrupted): " + this.interruptedDownload.getFileHash()));
                            qsi = new QueryHashItem(null, this.interruptedDownload.getFileHash(), QueryHashItem.ANTS_HASH, this.interruptedDownload.getChunkHashes() == null);
                            ap = new AsymmetricProvider(false);
                            queryManager = new QueryManager(qsi, this.n);
                            resultSet = queryManager.resultSet;
                            if (resultSet.size() > 0) {
                                this.currentSupernodeQueries = new QueryMessage[1];
                                this.currentSupernodeQueries[0] = new QueryMessage(qsi, ap.getPublicHeader());
                                _logger.info((Object)"Analyzing local results...");
                                pce = new PropertyChangeEvent(this, "queryCompleted", this.currentSupernodeQueries[0], queryManager.resultSet);
                                this.processCurrentEvent(pce);
                                _logger.info((Object)"Ricevuta parte di query file");
                            }
                            if (BackgroundEngine.getInstance().getSupernodeList().size() > 0) {
                                supernodesSubset = new ArrayList();
                                this.currentSupernodeSet.retainAll(new ArrayList(BackgroundEngine.getInstance().getSupernodeList().keySet()));
                                if (this.currentSupernodeSet.size() > 0) {
                                    supernodesSubset = new ArrayList(this.currentSupernodeSet.subList(0, Math.min(5, this.currentSupernodeSet.size())));
                                    this.currentSupernodeSet.removeAll(supernodesSubset);
                                } else {
                                    this.currentSupernodeSet = new ArrayList(BackgroundEngine.getInstance().getSupernodeList().keySet());
                                    Collections.shuffle(this.currentSupernodeSet);
                                    supernodesSubset = new ArrayList(this.currentSupernodeSet.subList(0, Math.min(5, this.currentSupernodeSet.size())));
                                    this.currentSupernodeSet.remove(supernodesSubset);
                                }
                                queryWrappers = this.n.doSupernodeQuery(qsi, ap.getPublicHeader(), supernodesSubset);
                                this.currentSupernodeQueries = new QueryMessage[queryWrappers.length];
                                for (x = 0; x < queryWrappers.length; ++x) {
                                    if (queryWrappers[x].getMessage() == null || !(queryWrappers[x].getMessage() instanceof QueryMessage)) continue;
                                    this.currentSupernodeQueries[x] = (QueryMessage)queryWrappers[x].getMessage();
                                }
                            } else {
                                query = this.n.doQuery(qsi, ap.getPublicHeader()).getMessage();
                                if (query != null && query instanceof QueryMessage) {
                                    this.currentQuery = (QueryMessage)query;
                                }
                            }
                        }
                    } else if (this.msdm != null) {
                        if (this.msdm.ae != this) {
                            this.terminate = true;
                        }
                        if (this.msdm.getPeersNumber() < MultipleSourcesDownloadManager.MaxSources) {
                            _logger.info((Object)(this + "Autoresume is running for file (downloading): " + this.msdm.getFileHash()));
                            qsi = new QueryHashItem(null, this.msdm.getFileHash(), QueryHashItem.ANTS_HASH, this.msdm.getChunkHashes() == null);
                            ap = new AsymmetricProvider(false);
                            queryManager = new QueryManager(qsi, this.n);
                            resultSet = queryManager.resultSet;
                            if (resultSet.size() > 0) {
                                this.currentSupernodeQueries = new QueryMessage[1];
                                this.currentSupernodeQueries[0] = new QueryMessage(qsi, ap.getPublicHeader());
                                _logger.info((Object)"Analyzing local results...");
                                pce = new PropertyChangeEvent(this, "queryCompleted", this.currentSupernodeQueries[0], queryManager.resultSet);
                                this.processCurrentEvent(pce);
                                _logger.info((Object)"Ricevuta parte di query file");
                            }
                            if (BackgroundEngine.getInstance().getSupernodeList().size() > 0) {
                                supernodesSubset = new ArrayList();
                                this.currentSupernodeSet.retainAll(new ArrayList(BackgroundEngine.getInstance().getSupernodeList().keySet()));
                                if (this.currentSupernodeSet.size() > 0) {
                                    supernodesSubset = new ArrayList(this.currentSupernodeSet.subList(0, Math.min(5, this.currentSupernodeSet.size())));
                                    this.currentSupernodeSet.removeAll(supernodesSubset);
                                } else {
                                    this.currentSupernodeSet = new ArrayList(BackgroundEngine.getInstance().getSupernodeList().keySet());
                                    Collections.shuffle(this.currentSupernodeSet);
                                    supernodesSubset = new ArrayList(this.currentSupernodeSet.subList(0, Math.min(5, this.currentSupernodeSet.size())));
                                    this.currentSupernodeSet.removeAll(supernodesSubset);
                                }
                                queryWrappers = this.n.doSupernodeQuery(qsi, ap.getPublicHeader(), supernodesSubset);
                                this.currentSupernodeQueries = new QueryMessage[queryWrappers.length];
                                for (x = 0; x < queryWrappers.length; ++x) {
                                    if (queryWrappers[x].getMessage() == null || !(queryWrappers[x].getMessage() instanceof QueryMessage)) continue;
                                    this.currentSupernodeQueries[x] = (QueryMessage)queryWrappers[x].getMessage();
                                }
                            } else {
                                query = this.n.doQuery(qsi, ap.getPublicHeader()).getMessage();
                                if (query != null && query instanceof QueryMessage) {
                                    this.currentQuery = (QueryMessage)query;
                                }
                            }
                        }
                    } else {
                        this.terminate = true;
                    }
                }
                AutoresumeEngine.sleep(this.sleepRate);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Autoresume Engine Exception", (Throwable)e);
        }
        if (this.interruptedDownload != null) {
            this.interruptedDownload.ae = null;
        } else if (this.msdm != null) {
            this.msdm.ae = null;
        }
        this.n.propertyChangeSupport.removePropertyChangeListener(this);
        this.n = null;
        this.terminate = true;
        _logger.info((Object)(this + " AutoresumeEngine DEACTIVATED"));
    }

    private boolean isMySupernodeQuery(QueryMessage query) {
        for (int x = 0; x < this.currentSupernodeQueries.length; ++x) {
            if (this.currentSupernodeQueries[x] == null || this.currentSupernodeQueries[x].getLocalQueryId() != query.getLocalQueryId()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCurrentEvent(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("queryCompleted")) {
            QueryMessage eventQuerySource = (QueryMessage)e.getOldValue();
            if (this.currentQuery != null && eventQuerySource.getLocalQueryId() == this.currentQuery.getLocalQueryId() || this.isMySupernodeQuery(eventQuerySource)) {
                ArrayList resultset = this.mergeQueryResults((ArrayList)e.getNewValue());
                block6: for (int x = 0; x < resultset.size(); ++x) {
                    if (this.msdm != null) {
                        if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) break;
                    }
                    FileTupleGroup ftg = (FileTupleGroup)resultset.get(x);
                    _logger.info((Object)("Autoresume query completed for file: " + ftg.getHash()));
                    Object[] tuples = ftg.tuples.toArray();
                    Arrays.sort(tuples, new QueryFileTupleComparator());
                    for (int y = 0; y < tuples.length; ++y) {
                        QueryFileTuple qft;
                        EndpointSecurityManager esm;
                        if (this.msdm != null) {
                            if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) continue block6;
                        }
                        if ((esm = this.n.getOutputSecureConnectionManager((qft = (QueryFileTuple)tuples[y]).getOwnerID())) != null) {
                            _logger.info((Object)("Secure connection " + esm + " adding peer " + qft.getOwnerID().substring(0, 10)));
                            this.pcs.firePropertyChange("addSourcePeer", this, qft);
                            continue;
                        }
                        _logger.info((Object)("Secure connection " + esm + "... creating " + qft.getOwnerID().substring(0, 10)));
                        this.n.createSecureConnection(qft.getOwnerID(), false);
                        List list = this.secureConnectionRequired;
                        synchronized (list) {
                            if (!this.secureConnectionRequired.contains(qft)) {
                                if (this.secureConnectionRequired.size() > secureConnectionToTrace) {
                                    this.secureConnectionRequired.remove(0);
                                }
                                this.secureConnectionRequired.add(qft);
                            }
                            continue;
                        }
                    }
                }
            }
        }
        if (e.getPropertyName().equals("secureConnectionCreated")) {
            List list = this.secureConnectionRequired;
            synchronized (list) {
                for (int x = 0; x < this.secureConnectionRequired.size(); ++x) {
                    QueryFileTuple qft;
                    if (this.msdm != null) {
                        if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) break;
                    }
                    if (!(qft = (QueryFileTuple)this.secureConnectionRequired.get(x)).getOwnerID().equals(((SecurityResponseMessage)e.getNewValue()).getSource())) continue;
                    _logger.info((Object)("Autoresume secure connection created file: " + qft.getFileHash()));
                    this.secureConnectionRequired.remove(x);
                    this.pcs.firePropertyChange("addSourcePeer", this, qft);
                    return;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        final PropertyChangeEvent event = e;
        Thread processor = new Thread(){

            public void run() {
                AutoresumeEngine.this.processCurrentEvent(event);
            }
        };
        processor.setPriority(1);
        processor.start();
    }

    public ArrayList mergeQueryResults(ArrayList resultSet) {
        ArrayList<FileTupleGroup> tupleGroups = new ArrayList<FileTupleGroup>();
        for (int x = 0; x < resultSet.size(); ++x) {
            QueryRemoteFileTuple qrft;
            FileTupleGroup ftg;
            FileTupleGroup ftg2;
            if (resultSet.get(x) instanceof QueryCompletedFileTuple) {
                if (tupleGroups.contains((QueryCompletedFileTuple)resultSet.get(x))) {
                    ftg2 = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryCompletedFileTuple)resultSet.get(x)));
                    if (!ftg2.tuples.contains(resultSet.get(x))) {
                        ftg2.tuples.add(resultSet.get(x));
                        continue;
                    }
                    ftg2.tuples.remove(resultSet.get(x));
                    ftg2.tuples.add(resultSet.get(x));
                    continue;
                }
                QueryCompletedFileTuple qft = (QueryCompletedFileTuple)resultSet.get(x);
                ftg = new FileTupleGroup(qft.getFileHash(), qft.getSize());
                ftg.tuples.add(qft);
                tupleGroups.add(ftg);
                continue;
            }
            if (resultSet.get(x) instanceof QueryPartialFileTuple) {
                if (tupleGroups.contains((QueryPartialFileTuple)resultSet.get(x))) {
                    ftg2 = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryPartialFileTuple)resultSet.get(x)));
                    if (!ftg2.tuples.contains(resultSet.get(x))) {
                        ftg2.tuples.add(resultSet.get(x));
                        continue;
                    }
                    ftg2.tuples.remove(resultSet.get(x));
                    ftg2.tuples.add(resultSet.get(x));
                    continue;
                }
                QueryPartialFileTuple qpft = (QueryPartialFileTuple)resultSet.get(x);
                ftg = new FileTupleGroup(qpft.getFileHash(), qpft.getSize());
                ftg.tuples.add(qpft);
                tupleGroups.add(ftg);
                continue;
            }
            if (!(resultSet.get(x) instanceof QueryRemoteFileTuple)) continue;
            if (!tupleGroups.contains((QueryRemoteFileTuple)resultSet.get(x)) && !this.n.getIdent().equals(((QueryRemoteFileTuple)resultSet.get(x)).getOwnerID())) {
                qrft = (QueryRemoteFileTuple)resultSet.get(x);
                ftg = new FileTupleGroup(qrft.getFileHash(), qrft.getSize());
                ftg.tuples.add(qrft);
                tupleGroups.add(ftg);
                continue;
            }
            if (this.n.getIdent().equals(((QueryRemoteFileTuple)resultSet.get(x)).getOwnerID())) continue;
            qrft = (QueryRemoteFileTuple)resultSet.get(x);
            ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf(qrft));
            if (ftg.tuples.contains(resultSet.get(x)) && ftg.tuples.get(ftg.tuples.indexOf(resultSet.get(x))) instanceof QueryRemoteFileTuple) {
                QueryRemoteFileTuple oldQrft = (QueryRemoteFileTuple)ftg.tuples.get(ftg.tuples.indexOf(resultSet.get(x)));
                if (oldQrft.getLastTimeSeen() >= qrft.getLastTimeSeen()) continue;
                ftg.tuples.set(ftg.tuples.indexOf(resultSet.get(x)), qrft);
                continue;
            }
            if (ftg.tuples.contains(resultSet.get(x))) continue;
            ftg.tuples.add(qrft);
        }
        return tupleGroups;
    }

    public void setInterruptedDownload(InterruptedDownload interruptedDownload) {
        this.interruptedDownload = interruptedDownload;
        if (this.msdm != null) {
            this.msdm.ae = null;
        }
        this.msdm = null;
        this.interruptedDownload.addAutoresumeEngine(this);
    }

    public void setMultipleSourcesDownloadManager(MultipleSourcesDownloadManager msdm) {
        this.msdm = msdm;
        if (this.interruptedDownload != null) {
            this.interruptedDownload.ae = null;
        }
        this.interruptedDownload = null;
        this.msdm.addAutoresumeEngine(this);
    }
}

