/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.Ant;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.log4j.Logger;

class FileInfosPullerThread
extends Thread
implements PropertyChangeListener {
    long initTime;
    MultipleSourcesDownloadManager caller;
    WarriorAnt n;
    String fileHash;
    String peerId;
    boolean getChunkHashes;
    boolean terminate = false;
    static Logger _logger = Logger.getLogger((String)FileInfosPullerThread.class.getName());

    FileInfosPullerThread(MultipleSourcesDownloadManager caller, WarriorAnt n, String fileHash, String peerId, boolean getChunkHashes) {
        this.n = n;
        this.caller = caller;
        this.fileHash = fileHash;
        this.peerId = peerId;
        this.getChunkHashes = getChunkHashes;
        this.caller.propertyChangeSupport.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this.initTime = System.currentTimeMillis();
        try {
            this.n.pullFileInfos(this.fileHash, this.peerId, this.getChunkHashes);
            this.initTime = System.currentTimeMillis();
            while (!this.terminate) {
                FileInfosPullerThread.sleep(5000L);
                long elapsed = System.currentTimeMillis() - this.initTime;
                if (this.caller.interrupt) throw new Exception("Infos pull failed: " + this.fileHash.substring(0, 10) + " " + this.peerId.substring(0, 10));
                if (elapsed <= Ant.messageTimeout * (long)Ant.maxRetransmissions) continue;
                throw new Exception("Infos pull failed: " + this.fileHash.substring(0, 10) + " " + this.peerId.substring(0, 10));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            boolean[] blArray = this.caller.inServiceBlockGroups;
            // MONITORENTER : this.caller.inServiceBlockGroups
            List list = this.caller.synchronizedInServicePeerList;
            // MONITORENTER : list
            this.n.propertyChangeSupport.firePropertyChange("infosPullerThreadRequestError", null, this);
            // MONITOREXIT : list
            // MONITOREXIT : blArray
        }
        this.caller.propertyChangeSupport.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("fileInfosPullCompleteThread") && e.getNewValue().equals(this.peerId)) {
            this.terminate = true;
            _logger.info((Object)("Puller thread completed: " + this.fileHash));
        } else if (e.getPropertyName().equals("fileInfosPullErrorThread") && e.getNewValue().equals(this.peerId)) {
            this.terminate = true;
            _logger.info((Object)("Infos puller thread terminated: " + this.fileHash));
        }
    }
}

