/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.filesharing.AutoresumeEngine;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.utils.indexer.BackgroundEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class InterruptedDownload {
    String fileName;
    String fileHash;
    String ed2kFileHash;
    Object[] chunkHashes;
    String extendedInfos;
    long assignedCoprime;
    long byteDownloaded;
    long fileSize;
    int blockSize;
    boolean[] downloadedBlockGroups;
    AutoresumeEngine ae;
    static Logger _logger = Logger.getLogger((String)InterruptedDownload.class.getName());

    public InterruptedDownload(MultipleSourcesDownloadManager store) {
        this.fileName = store.getFileName();
        this.fileHash = store.getFileHash();
        this.ed2kFileHash = store.getED2KFileHash();
        this.chunkHashes = store.chunkHashes;
        this.byteDownloaded = store.getByteDownloaded();
        this.fileSize = store.getFileSize();
        this.blockSize = store.getBlockSize();
        this.extendedInfos = store.getExtendedInfos();
        this.assignedCoprime = store.assignedCoprime;
        this.downloadedBlockGroups = store.getDownloadedBlockGroups();
        if (this.chunkHashes != null) {
            BackgroundEngine.getInstance().addPartialFile(this);
        }
    }

    public boolean[] getDownloadedBlockGroups() {
        return this.downloadedBlockGroups;
    }

    public InterruptedDownload(File store) throws Exception {
        ObjectInputStream ois = null;
        try {
            this.fileName = store.getName();
            if (store.exists()) {
                ois = new ObjectInputStream(new FileInputStream(store));
                this.downloadedBlockGroups = (boolean[])ois.readObject();
                this.fileName = (String)ois.readObject();
                this.fileHash = (String)ois.readObject();
                this.ed2kFileHash = (String)ois.readObject();
                this.chunkHashes = (Object[])ois.readObject();
                this.byteDownloaded = (Long)ois.readObject();
                this.fileSize = (Long)ois.readObject();
                this.blockSize = (Integer)ois.readObject();
                this.assignedCoprime = (Long)ois.readObject();
                this.extendedInfos = (String)ois.readObject();
                ois.close();
                if (this.blockSize != WarriorAnt.blockSizeInDownload) {
                    throw new Exception("Failed loading InterruptedDownload .mul file: incompatible blocksize " + this.fileName);
                }
            } else {
                throw new Exception("Failed loading InterruptedDownload .mul file: fiile not found " + this.fileName);
            }
            BackgroundEngine.getInstance().addPartialFile(this);
        }
        catch (Exception e) {
            ois.close();
            _logger.error((Object)("Failed loading InterruptedDownload .mul file: " + store.getName() + " chuncks preserved!"), (Throwable)e);
            throw new Exception("Failed loading InterruptedDownload .mul file: " + store.getName() + " chuncks preserved!", e);
        }
    }

    public int getAvaiablePreviewIndexes() {
        int x = 0;
        while (this.downloadedBlockGroups[x]) {
            ++x;
        }
        return x;
    }

    public String getPercentage() {
        int den = this.downloadedBlockGroups.length;
        int num = 0;
        for (int x = 0; x < this.downloadedBlockGroups.length; ++x) {
            if (!this.downloadedBlockGroups[x]) continue;
            ++num;
        }
        double perc = (double)num * 1.0 / (double)den * 100.0;
        return (int)perc + "%";
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public String getED2KFileHash() {
        return this.ed2kFileHash;
    }

    public Object[] getChunkHashes() {
        return this.chunkHashes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getByteDownloaded() {
        return this.byteDownloaded;
    }

    public void removeInterrupted() {
        for (int x = 0; x < this.getDownloadedBlockGroups().length; ++x) {
            if (!this.getDownloadedBlockGroups()[x]) continue;
            try {
                File f = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.getFileHash() + "." + x);
                f.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            File f = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + this.getFileHash() + ".mul");
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BackgroundEngine.getInstance().removePartialFile(this.getFileHash());
    }

    public String toString() {
        String result = this.getPercentage();
        while (result.length() < 8) {
            result = result + " ";
        }
        result = result + " " + this.sizeToString(this.getFileSize()) + " ";
        while (result.length() < 25) {
            result = result + " ";
        }
        result = result + " " + this.getFileHash() + " ";
        result = result + "     ";
        result = result + this.getFileName();
        return result;
    }

    public String sizeToString(double dSize) {
        int index;
        int x;
        double currentSize = dSize;
        dSize /= Math.pow(2.0, 20.0);
        for (x = 1; dSize > 1.0 && x < 5; dSize /= Math.pow(2.0, 10.0), ++x) {
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 4) {
            suffix = " Tib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 40.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public void addAutoresumeEngine(AutoresumeEngine ae) {
        if (this.ae != null && !this.ae.deactivated()) {
            this.ae.deactivate();
        }
        this.ae = ae;
        if (this.ae != null && !this.ae.isAlive()) {
            this.ae.start();
            while (!this.ae.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public AutoresumeEngine getAutoresumeEngine() {
        return this.ae;
    }

    public void deactivateAutoresumeEngine() {
        if (this.ae != null && !this.ae.deactivated()) {
            this.ae.deactivate();
            this.ae = null;
        }
    }

    public boolean isAutoresumeActive() {
        return this.ae != null && !this.ae.deactivated();
    }
}

