/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.gui.StartUp;
import ants.p2p.utils.indexer.FileInfos;
import ants.p2p.utils.indexer.FileSize;
import java.io.File;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import ji.JI;
import org.apache.log4j.Logger;

public class SharedFilesTableModel
extends AbstractTableModel {
    static Logger _logger = Logger.getLogger((String)StartUp.class.getName());
    ArrayList sharedFiles = new ArrayList();
    private String[] columnNames = new String[]{JI.i("File Name"), JI.i("File Hash"), JI.i("File Size"), JI.i("File Infos"), JI.i("Comment")};

    public SharedFilesTableModel(ArrayList sharedFiles) {
        this.sharedFiles = sharedFiles;
    }

    public ArrayList getSharedFiles() {
        return this.sharedFiles;
    }

    public void setSharedFiles(ArrayList sharedFiles) {
        this.sharedFiles = sharedFiles;
        this.fireTableRowsUpdated(0, this.sharedFiles.size());
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4;
    }

    public int getRowCount() {
        if (this.sharedFiles != null) {
            return this.sharedFiles.size();
        }
        return 0;
    }

    public Object getValueAt(int row, int col) {
        FileInfos fi = (FileInfos)this.sharedFiles.get(row);
        switch (col) {
            case 0: {
                return new File(fi.getName()).getName();
            }
            case 1: {
                return fi.getHash();
            }
            case 2: {
                return new FileSize(fi.getSize());
            }
            case 3: {
                return fi.getExtendedInfos();
            }
            case 4: {
                return fi.getComment();
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public Class getColumnClass(int col) {
        try {
            switch (col) {
                case 0: {
                    return Class.forName("java.lang.String");
                }
                case 1: {
                    return Class.forName("java.lang.String");
                }
                case 2: {
                    return Class.forName("ants.p2p.utils.indexer.FileSize");
                }
                case 3: {
                    return Class.forName("java.lang.String");
                }
                case 4: {
                    return Class.forName("java.lang.String");
                }
            }
            return null;
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot resolve class", (Throwable)e);
            return null;
        }
    }
}

