/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.ChunkHashes;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.utils.indexer.DigestManager;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import ji.JI;

public class QueryCompletedFileTuple
extends QueryFileTuple {
    Object fileName;
    Object fileHash;
    Object ed2kFileHash;
    Object chunkHashes;
    Object fileLength;
    Object ownerID;
    Object ownerIP;
    Object freeSlots;
    Object connectionType;
    Object extendedInfos;
    Object comment;

    public QueryCompletedFileTuple(String sessionKey, String fileName, String fileHash, String ed2kFileHash, Object[] chunkHashes, Long fileLength, String ownerID, String ownerIP, Integer freeSlots, String connectionType, String extendedInfos, String comment) {
        super(sessionKey);
        this.fileHash = fileHash;
        this.ed2kFileHash = ed2kFileHash;
        this.chunkHashes = new ChunkHashes(chunkHashes);
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.ownerID = ownerID;
        this.ownerIP = ownerIP;
        this.freeSlots = freeSlots;
        this.connectionType = "Masked";
        this.extendedInfos = extendedInfos;
        this.comment = comment;
    }

    public String getFileName() {
        if (this.fileName instanceof String) {
            return (String)this.fileName;
        }
        return null;
    }

    public String getFileHash() {
        if (this.fileHash instanceof String) {
            return (String)this.fileHash;
        }
        return null;
    }

    public String getED2KFileHash() {
        if (this.ed2kFileHash instanceof String) {
            return (String)this.ed2kFileHash;
        }
        return null;
    }

    public ChunkHashes getChunkHashes() {
        if (this.chunkHashes instanceof ChunkHashes) {
            return (ChunkHashes)this.chunkHashes;
        }
        return null;
    }

    public Long getSize() {
        if (this.fileLength instanceof Long) {
            return (Long)this.fileLength;
        }
        return null;
    }

    public String getOwnerID() {
        if (this.ownerID instanceof String) {
            return (String)this.ownerID;
        }
        return null;
    }

    public String getOwnerIP() {
        if (this.ownerID instanceof String) {
            return (String)this.ownerIP;
        }
        return null;
    }

    public Integer getFreeSlots() {
        if (this.freeSlots instanceof Integer) {
            return (Integer)this.freeSlots;
        }
        return null;
    }

    public String getConnectionType() {
        if (this.connectionType instanceof String) {
            return (String)this.connectionType;
        }
        return null;
    }

    public String getExtendedInfos() {
        if (this.extendedInfos instanceof String) {
            return (String)this.extendedInfos;
        }
        return null;
    }

    public String getComment() {
        if (this.comment instanceof String) {
            return (String)this.comment;
        }
        return null;
    }

    public void encrypt(Cipher c) throws Exception {
        this.fileName = new SealedObject((Serializable)((Object)((String)this.fileName)), c);
        this.fileHash = new SealedObject((Serializable)((Object)((String)this.fileHash)), c);
        this.ed2kFileHash = new SealedObject((Serializable)((Object)((String)this.ed2kFileHash)), c);
        this.chunkHashes = new SealedObject((ChunkHashes)this.chunkHashes, c);
        this.fileLength = new SealedObject((Long)this.fileLength, c);
        this.freeSlots = new SealedObject((Integer)this.freeSlots, c);
        this.connectionType = new SealedObject((Serializable)((Object)((String)this.connectionType)), c);
        this.extendedInfos = new SealedObject((Serializable)((Object)((String)this.extendedInfos)), c);
        this.comment = new SealedObject((Serializable)((Object)((String)this.comment)), c);
    }

    public void decrypt(Cipher c) throws Exception {
        this.fileName = (String)((SealedObject)this.fileName).getObject(c);
        this.fileHash = (String)((SealedObject)this.fileHash).getObject(c);
        this.ed2kFileHash = (String)((SealedObject)this.ed2kFileHash).getObject(c);
        this.chunkHashes = (ChunkHashes)((SealedObject)this.chunkHashes).getObject(c);
        this.fileLength = (Long)((SealedObject)this.fileLength).getObject(c);
        this.freeSlots = (Integer)((SealedObject)this.freeSlots).getObject(c);
        this.connectionType = (String)((SealedObject)this.connectionType).getObject(c);
        this.extendedInfos = (String)((SealedObject)this.extendedInfos).getObject(c);
        this.comment = (String)((SealedObject)this.comment).getObject(c);
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getFileHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryCompletedFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryPartialFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryRemoteFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        return o == this;
    }

    public String toString() {
        String result = JI.i("Owner ID") + ": " + (this.getOwnerIP().equals("") ? this.getOwnerID().substring(0, 10) : this.getOwnerIP()) + "   " + JI.i("Free Slots") + ": ";
        String freeSlots = this.getFreeSlots() + "";
        while (freeSlots.length() < 10) {
            freeSlots = freeSlots + " ";
        }
        result = result + freeSlots + "[100%]";
        result = result + "  " + this.getFileName() + "    [" + this.comment + "]";
        return result;
    }

    public boolean checkHashesValidity() {
        if (this.getChunkHashes().getChunkHashes() == null) {
            return true;
        }
        DigestManager dm = new DigestManager();
        try {
            String computedHash = dm.getDigest(this.getChunkHashes().getChunkHashes());
            return computedHash.equals(this.getFileHash());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

