/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.FrameAnt;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileListItem;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryHttpServerItem;
import ants.p2p.query.QueryInetAddressItem;
import ants.p2p.query.QueryItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryNode;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.query.QueryStringItem;
import ants.p2p.query.QuerySupernodeItem;
import ants.p2p.query.QuerySupernodeTuple;
import ants.p2p.query.QueryTuple;
import ants.p2p.query.ServerInfo;
import ants.p2p.query.security.AsymmetricProvider;
import ants.p2p.utils.encoding.StringHash;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.FileInfos;
import ants.p2p.utils.indexer.RemoteFileInfos;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class QueryManager {
    public static int resultSize = 50;
    static int maxLocalResultsToReturn = 50;
    static int maxRemoteResultsToReturn = 50;
    static Logger _logger = Logger.getLogger((String)QueryManager.class.getName());
    WarriorAnt caller;
    QueryMessage queryMessage;
    public ArrayList resultSet = new ArrayList();
    private boolean onlyRemote;

    public QueryManager(QueryNode query, WarriorAnt caller) throws Exception {
        if (query instanceof QueryHttpServerItem) {
            this.resultSet = new ArrayList();
            Enumeration keys = BackgroundEngine.getInstance().getHttpServersList().keys();
            while (keys.hasMoreElements()) {
                String httpServer = (String)keys.nextElement();
                HttpServerInfo curSI = (HttpServerInfo)BackgroundEngine.getInstance().getHttpServersList().get(httpServer);
                this.resultSet.add(curSI);
            }
        } else {
            this.onlyRemote = true;
            this.caller = caller;
            this.resultSet = this.process(query);
            ArrayList<QueryRemoteFileTuple> processedResultSet = new ArrayList<QueryRemoteFileTuple>();
            if (this.resultSet != null) {
                for (int x = 0; x < this.resultSet.size(); ++x) {
                    BackgroundEngine be = BackgroundEngine.getInstance();
                    RemoteFileInfos rfi = (RemoteFileInfos)be.remoteFilesIndexHash.get((String)this.resultSet.get(x));
                    if (rfi == null || !rfi.hasSources(BackgroundEngine.remoteIndexedDocumentsTimeout)) continue;
                    Enumeration sources = rfi.getOwners().keys();
                    while (sources.hasMoreElements()) {
                        String curSource = (String)sources.nextElement();
                        Long lastTimeSeen = (Long)rfi.getOwners().get(curSource);
                        QueryRemoteFileTuple qpt = new QueryRemoteFileTuple(null, rfi.getName(), rfi.getHash(), rfi.getED2KFileHash(), new Long(rfi.getSize()), curSource, caller.getLocalInetAddress(), rfi.getExtendedInfos(), lastTimeSeen);
                        processedResultSet.add(qpt);
                    }
                }
                this.resultSet = processedResultSet;
            } else {
                this.resultSet = new ArrayList();
            }
        }
    }

    public QueryManager(QueryMessage queryMessage, WarriorAnt caller) throws Exception {
        this.onlyRemote = false;
        this.caller = caller;
        this.queryMessage = queryMessage;
        if (this.queryMessage.tuples.size() < resultSize) {
            this.resultSet = this.process(queryMessage.query);
            queryMessage.getPublicHeader().generateSessionKey();
            if (this.queryMessage.getQuery() instanceof QuerySupernodeItem) {
                AsymmetricProvider ap = new AsymmetricProvider(false);
                QueryMessage qm = new QueryMessage(new QueryFileListItem(null), ap.getPublicHeader());
                if (WarriorAnt.isSupernode()) {
                    QuerySupernodeTuple qt = new QuerySupernodeTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), new Long(System.currentTimeMillis()), new Long(BackgroundEngine.getInstance().getTotalRemoteSharedSize() + BackgroundEngine.getInstance().getTotalLocalSharedSize()), qm, this.caller.getIdent(), this.caller.getLocalInetAddress());
                    qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                    queryMessage.tuples.add(qt);
                }
                Enumeration keys = BackgroundEngine.getInstance().getSupernodeList().keys();
                int counter = 0;
                while (keys.hasMoreElements() && (WarriorAnt.isSupernode() && counter++ < 5 || counter++ < 3)) {
                    String superNode = (String)keys.nextElement();
                    QuerySupernodeTuple curQueryTuple = (QuerySupernodeTuple)BackgroundEngine.getInstance().getSupernodeList().get(superNode);
                    QuerySupernodeTuple qst = new QuerySupernodeTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), curQueryTuple.getSeenOn(), curQueryTuple.getTotalShareDimension(), curQueryTuple.getQueryMessage(), curQueryTuple.getOwnerID(), curQueryTuple.getOwnerIP());
                    qst.encrypt(queryMessage.getPublicHeader().getEncCipher());
                    queryMessage.tuples.add(qst);
                }
                queryMessage.getPublicHeader().invalidateSessionKey();
            } else if (this.queryMessage.getQuery() instanceof QueryInetAddressItem) {
                if (this.resultSet != null) {
                    for (int x = 0; x < this.resultSet.size() && this.queryMessage.tuples.size() < resultSize; ++x) {
                        ServerInfo si = new ServerInfo(queryMessage.getPublicHeader().getEncryptedSessionKey(), FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().getLocalStringAddress(), new Integer(caller.getServerPort()), WarriorAnt.ConnectionType);
                        si.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(si);
                    }
                    queryMessage.getPublicHeader().invalidateSessionKey();
                }
            } else if (this.queryMessage.getQuery() instanceof QueryHttpServerItem) {
                if (this.resultSet != null) {
                    for (int x = 0; x < this.resultSet.size() && this.queryMessage.tuples.size() < resultSize; ++x) {
                        HttpServerInfo si = new HttpServerInfo(queryMessage.getPublicHeader().getEncryptedSessionKey(), caller.getHttpServerHomePage(), caller.getHttpServerDescription(), caller.getIdent(), this.caller.getLocalInetAddress(), new Long(System.currentTimeMillis()));
                        si.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(si);
                    }
                    Enumeration keys = BackgroundEngine.getInstance().getHttpServersList().keys();
                    int counter = 0;
                    while (keys.hasMoreElements() && (WarriorAnt.isSupernode() && counter++ < Integer.MAX_VALUE || counter++ < 10)) {
                        String httpServer = (String)keys.nextElement();
                        HttpServerInfo curSI = (HttpServerInfo)BackgroundEngine.getInstance().getHttpServersList().get(httpServer);
                        HttpServerInfo si = new HttpServerInfo(queryMessage.getPublicHeader().getEncryptedSessionKey(), curSI.getHomePage(), curSI.getDescription(), curSI.getOwnerId(), curSI.getOwnerIp(), curSI.getSeenOn());
                        si.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(si);
                    }
                    queryMessage.getPublicHeader().invalidateSessionKey();
                }
            } else if (this.queryMessage.getQuery() instanceof QueryHashItem) {
                QueryHashItem qHashItem = (QueryHashItem)this.queryMessage.getQuery();
                if (this.resultSet != null) {
                    BackgroundEngine be;
                    RemoteFileInfos rfi;
                    if (this.resultSet.size() > 1 && this.resultSet.get(0).equals("CompleteFileHash") && this.resultSet.get(1) != null) {
                        QueryCompletedFileTuple qt = new QueryCompletedFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), new File((String)this.resultSet.get(1)).getName(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getHash(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getED2KHash(), qHashItem.getChunkHashes ? ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getChunckHashes() : null, new Long(((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getSize()), caller.getIdent(), caller.getLocalInetAddress(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getExtendedInfos(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(1))).getComment());
                        qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(qt);
                    } else if (this.resultSet.size() > 1 && this.resultSet.get(0).equals("PartialFileHash") && this.resultSet.get(1) != null) {
                        BackgroundEngine be2 = BackgroundEngine.getInstance();
                        QueryPartialFileTuple qpt = be2.getPartialFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), (String)this.resultSet.get(1), qHashItem.type, caller.getIdent(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, qHashItem.getChunkHashes);
                        qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(qpt);
                    } else if (queryMessage.getType() == 0 && this.resultSet.size() > 1 && this.resultSet.get(0).equals("RemoteFileHash") && this.resultSet.get(1) != null && (rfi = (be = BackgroundEngine.getInstance()).getRemoteFile((String)this.resultSet.get(1), qHashItem.type)) != null && rfi.hasSources(BackgroundEngine.remoteIndexedDocumentsTimeout)) {
                        Enumeration sources = rfi.getOwners().keys();
                        while (sources.hasMoreElements()) {
                            String curSource = (String)sources.nextElement();
                            if (curSource.equals(queryMessage.getSource())) continue;
                            Long lastTimeSeen = (Long)rfi.getOwners().get(curSource);
                            QueryRemoteFileTuple qt = new QueryRemoteFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), rfi.getName(), rfi.getHash(), rfi.getED2KFileHash(), new Long(rfi.getSize()), curSource, caller.getLocalInetAddress(), rfi.getExtendedInfos(), lastTimeSeen);
                            qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                            queryMessage.tuples.add(qt);
                        }
                    }
                    queryMessage.getPublicHeader().invalidateSessionKey();
                }
            } else if (this.queryMessage.getQuery() instanceof QueryRandomItem) {
                if (this.resultSet != null) {
                    for (int x = 0; x < this.resultSet.size(); ++x) {
                        if (this.resultSet.get(x) instanceof FileInfos) {
                            FileInfos fi = (FileInfos)this.resultSet.get(x);
                            QueryCompletedFileTuple qt = new QueryCompletedFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), new File(fi.getName()).getName(), fi.getHash(), fi.getED2KHash(), null, new Long(fi.getSize()), caller.getIdent(), caller.getLocalInetAddress(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, fi.getExtendedInfos(), fi.getComment());
                            qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                            queryMessage.tuples.add(qt);
                            continue;
                        }
                        if (this.resultSet.get(x) instanceof StringHash) {
                            BackgroundEngine be = BackgroundEngine.getInstance();
                            QueryPartialFileTuple qpt = be.getPartialFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), ((StringHash)this.resultSet.get(x)).getHash(), QueryHashItem.ANTS_HASH, caller.getIdent(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, false);
                            qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                            queryMessage.tuples.add(qpt);
                            continue;
                        }
                        if (this.resultSet.get(x) != null || this.resultSet.size() <= x + 1) continue;
                        int y = ++x;
                        while (y < this.resultSet.size()) {
                            RemoteFileInfos rfi = (RemoteFileInfos)this.resultSet.get(y);
                            if (rfi != null && rfi.hasSources(BackgroundEngine.remoteIndexedDocumentsTimeout)) {
                                Enumeration sources = rfi.getOwners().keys();
                                while (sources.hasMoreElements()) {
                                    String curSource = (String)sources.nextElement();
                                    if (curSource.equals(queryMessage.getSource())) continue;
                                    Long lastTimeSeen = (Long)rfi.getOwners().get(curSource);
                                    QueryRemoteFileTuple qpt = new QueryRemoteFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), rfi.getName(), rfi.getHash(), rfi.getED2KFileHash(), new Long(rfi.getSize()), curSource, caller.getLocalInetAddress(), rfi.getExtendedInfos(), lastTimeSeen);
                                    qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                                    queryMessage.tuples.add(qpt);
                                }
                            }
                            ++y;
                            ++x;
                        }
                    }
                    queryMessage.getPublicHeader().invalidateSessionKey();
                }
            } else if (this.resultSet != null) {
                for (int x = 0; x < this.resultSet.size() && queryMessage.tuples.size() < resultSize; ++x) {
                    if (this.resultSet.get(x) instanceof String) {
                        QueryCompletedFileTuple qt = new QueryCompletedFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), new File((String)this.resultSet.get(x)).getName(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(x))).getHash(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(x))).getED2KHash(), null, new Long(((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(x))).getSize()), caller.getIdent(), caller.getLocalInetAddress(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(x))).getExtendedInfos(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(this.resultSet.get(x))).getComment());
                        qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(qt);
                        continue;
                    }
                    if (this.resultSet.get(x) instanceof StringHash) {
                        BackgroundEngine be = BackgroundEngine.getInstance();
                        QueryPartialFileTuple qpt = be.getPartialFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), ((StringHash)this.resultSet.get(x)).getHash(), QueryHashItem.ANTS_HASH, caller.getIdent(), new Integer(WarriorAnt.maxPullRequestsToServe - caller.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, false);
                        qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                        queryMessage.tuples.add(qpt);
                        continue;
                    }
                    if (this.resultSet.get(x) != null || this.resultSet.size() <= x + 1) continue;
                    int y = ++x;
                    while (y < this.resultSet.size() && this.queryMessage.tuples.size() < resultSize) {
                        BackgroundEngine be = BackgroundEngine.getInstance();
                        RemoteFileInfos rfi = (RemoteFileInfos)be.remoteFilesIndexHash.get((String)this.resultSet.get(y));
                        if (rfi != null && rfi.hasSources(BackgroundEngine.remoteIndexedDocumentsTimeout)) {
                            Enumeration sources = rfi.getOwners().keys();
                            while (sources.hasMoreElements()) {
                                String curSource = (String)sources.nextElement();
                                if (curSource.equals(queryMessage.getSource())) continue;
                                Long lastTimeSeen = (Long)rfi.getOwners().get(curSource);
                                QueryRemoteFileTuple qpt = new QueryRemoteFileTuple(queryMessage.getPublicHeader().getEncryptedSessionKey(), rfi.getName(), rfi.getHash(), rfi.getED2KFileHash(), new Long(rfi.getSize()), curSource, caller.getLocalInetAddress(), rfi.getExtendedInfos(), lastTimeSeen);
                                qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
                                queryMessage.tuples.add(qpt);
                            }
                        }
                        ++y;
                        ++x;
                    }
                }
                queryMessage.getPublicHeader().invalidateSessionKey();
            }
        }
    }

    public QueryManager(WarriorAnt caller, QueryMessage queryMessage) throws Exception {
        this.caller = caller;
        AsymmetricProvider ap = new AsymmetricProvider(false);
        this.queryMessage = queryMessage;
        ArrayList<QueryTuple> decryptedRs = new ArrayList<QueryTuple>();
        this.resultSet = queryMessage.getTuples();
        if (this.queryMessage.getQuery() instanceof QuerySupernodeItem) {
            if (this.resultSet != null) {
                Cipher decCipher = null;
                for (int x = 0; x < this.resultSet.size(); ++x) {
                    QuerySupernodeTuple qst = (QuerySupernodeTuple)this.resultSet.get(x);
                    if (decCipher == null) {
                        decCipher = ap.getDecCipher(qst.getEncryptedSessionKey());
                    }
                    qst.decrypt(decCipher);
                    decryptedRs.add(qst);
                }
            }
            this.resultSet = decryptedRs;
        } else if (this.queryMessage.getQuery() instanceof QueryHttpServerItem) {
            if (this.resultSet != null) {
                Cipher decCipher = null;
                for (int x = 0; x < this.resultSet.size(); ++x) {
                    HttpServerInfo si = (HttpServerInfo)this.resultSet.get(x);
                    if (decCipher == null) {
                        decCipher = ap.getDecCipher(si.getEncryptedSessionKey());
                    }
                    si.decrypt(decCipher);
                    if (si.getOwnerId().equals(this.caller.getIdent())) continue;
                    decryptedRs.add(si);
                }
            }
            this.resultSet = decryptedRs;
        } else if (this.queryMessage.getQuery() instanceof QueryInetAddressItem) {
            if (this.resultSet != null) {
                Cipher decCipher = null;
                for (int x = 0; x < this.resultSet.size(); ++x) {
                    ServerInfo si = (ServerInfo)this.resultSet.get(x);
                    if (decCipher == null) {
                        decCipher = ap.getDecCipher(si.getEncryptedSessionKey());
                    }
                    si.decrypt(decCipher);
                    si.sessionKey = "";
                    decryptedRs.add(si);
                }
            }
            this.resultSet = decryptedRs;
        } else {
            if (this.resultSet != null) {
                Cipher decCipher = null;
                for (int x = 0; x < this.resultSet.size(); ++x) {
                    if (this.resultSet.get(x) instanceof QueryCompletedFileTuple) {
                        QueryCompletedFileTuple qft = (QueryCompletedFileTuple)this.resultSet.get(x);
                        if (decCipher == null) {
                            decCipher = ap.getDecCipher(qft.getEncryptedSessionKey());
                        }
                        qft.decrypt(decCipher);
                        if (!qft.checkHashesValidity()) continue;
                        decryptedRs.add(qft);
                        continue;
                    }
                    if (this.resultSet.get(x) instanceof QueryPartialFileTuple) {
                        QueryPartialFileTuple qpft = (QueryPartialFileTuple)this.resultSet.get(x);
                        if (decCipher == null) {
                            decCipher = ap.getDecCipher(qpft.getEncryptedSessionKey());
                        }
                        qpft.decrypt(decCipher);
                        if (!qpft.checkHashesValidity()) continue;
                        decryptedRs.add(qpft);
                        continue;
                    }
                    if (this.resultSet.get(x) instanceof QueryRemoteFileTuple) {
                        QueryRemoteFileTuple qrft = (QueryRemoteFileTuple)this.resultSet.get(x);
                        if (decCipher == null) {
                            decCipher = ap.getDecCipher(qrft.getEncryptedSessionKey());
                        }
                        qrft.decrypt(decCipher);
                        if (qrft.getOwnerID().equals(this.caller.getIdent()) || !qrft.checkHashesValidity()) continue;
                        decryptedRs.add(qrft);
                        continue;
                    }
                    if (!(this.resultSet.get(x) instanceof HttpServerInfo)) continue;
                    HttpServerInfo si = (HttpServerInfo)this.resultSet.get(x);
                    if (decCipher == null) {
                        decCipher = ap.getDecCipher(si.getEncryptedSessionKey());
                    }
                    si.decrypt(decCipher);
                    if (si.getOwnerId().equals(this.caller.getIdent())) continue;
                    decryptedRs.add(si);
                }
            }
            this.resultSet = decryptedRs;
        }
    }

    public QueryMessage getQueryMessage() {
        return this.queryMessage;
    }

    public ArrayList process(QueryNode qn) {
        if (qn instanceof QueryItem) {
            return this.process((QueryItem)qn);
        }
        return null;
    }

    public ArrayList process(QueryItem qn) {
        if (qn instanceof QueryStringItem) {
            return this.process((QueryStringItem)qn);
        }
        if (qn instanceof QueryHashItem) {
            return this.process((QueryHashItem)qn);
        }
        if (qn instanceof QueryRandomItem) {
            return this.process((QueryRandomItem)qn);
        }
        if (qn instanceof QueryInetAddressItem) {
            return this.process((QueryInetAddressItem)qn);
        }
        if (qn instanceof QueryHttpServerItem) {
            return this.process((QueryHttpServerItem)qn);
        }
        if (qn instanceof QueryFileListItem) {
            return this.process((QueryFileListItem)qn);
        }
        return null;
    }

    public ArrayList process(QueryRandomItem qh) {
        ArrayList<Object> elements = new ArrayList();
        BackgroundEngine be = BackgroundEngine.getInstance();
        if (be != null) {
            int startIndex;
            int remainingLocalSpace = maxLocalResultsToReturn;
            if (be.sharedFilesIndexName.size() <= remainingLocalSpace) {
                elements = new ArrayList(be.sharedFilesIndexName.values());
            } else {
                int startIndex2 = (int)Math.floor(Math.random() * (double)(be.sharedFilesIndexName.size() - remainingLocalSpace));
                elements = new ArrayList(be.sharedFilesIndexName.values());
                elements = new ArrayList<Object>(elements.subList(startIndex2, startIndex2 + remainingLocalSpace));
            }
            ArrayList partialHashes = be.getPartialFilesHashes();
            if (partialHashes.size() <= (remainingLocalSpace -= elements.size())) {
                elements.addAll(partialHashes);
            } else if (remainingLocalSpace > 0) {
                startIndex = (int)Math.floor(Math.random() * (double)(partialHashes.size() - remainingLocalSpace));
                elements.addAll(partialHashes.subList(startIndex, startIndex + remainingLocalSpace));
            }
            elements.add(null);
            if (be.remoteFilesIndexHash.size() <= maxRemoteResultsToReturn) {
                elements.addAll(new ArrayList(be.remoteFilesIndexHash.values()));
            } else {
                startIndex = (int)Math.floor(Math.random() * (double)(be.remoteFilesIndexHash.size() - maxRemoteResultsToReturn));
                elements.addAll(new ArrayList(be.remoteFilesIndexHash.values()).subList(startIndex, startIndex + maxRemoteResultsToReturn));
            }
        }
        return elements;
    }

    public ArrayList process(QueryStringItem qn) {
        String itemLower = qn.item.toLowerCase();
        ArrayList elements = new ArrayList();
        BackgroundEngine be = BackgroundEngine.getInstance();
        if (be != null) {
            if (!this.onlyRemote) {
                elements = be.search(itemLower, qn.content);
                elements.add(null);
            }
            elements.addAll(be.searchRemoteFiles(itemLower, this.onlyRemote));
            return elements;
        }
        return new ArrayList();
    }

    public ArrayList process(QueryFileListItem qfli) {
        ArrayList elements = new ArrayList();
        BackgroundEngine be = BackgroundEngine.getInstance();
        if (be != null) {
            elements.addAll(be.getCompleteFileList());
            return elements;
        }
        return new ArrayList();
    }

    public ArrayList process(QueryHashItem qh) {
        String hash = qh.hash;
        String type = qh.type;
        ArrayList<String> elements = new ArrayList<String>();
        BackgroundEngine be = BackgroundEngine.getInstance();
        if (be != null && hash != null && type != null) {
            if (type.equals(QueryHashItem.ANTS_HASH)) {
                if (be.sharedFilesIndexHash.get(hash) != null && !this.onlyRemote) {
                    FileInfos elemInfo = (FileInfos)be.sharedFilesIndexHash.get(hash);
                    elements.add("CompleteFileHash");
                    elements.add(elemInfo.getName());
                } else if (be.getPartialFile(hash, QueryHashItem.ANTS_HASH) != null && !this.onlyRemote) {
                    Object partialFile = be.getPartialFile(hash, QueryHashItem.ANTS_HASH);
                    elements.add("PartialFileHash");
                    elements.add(hash);
                } else if (be.getRemoteFile(hash, QueryHashItem.ANTS_HASH) != null) {
                    RemoteFileInfos rfi = be.getRemoteFile(hash, QueryHashItem.ANTS_HASH);
                    elements.add("RemoteFileHash");
                    elements.add(hash);
                }
            } else if (type.equals(QueryHashItem.ED2K_HASH)) {
                if (be.sharedFilesIndexED2KHash.get(hash) != null && !this.onlyRemote) {
                    FileInfos elemInfo = (FileInfos)be.sharedFilesIndexED2KHash.get(hash);
                    elements.add("CompleteFileHash");
                    elements.add(elemInfo.getName());
                } else if (be.getPartialFile(hash, QueryHashItem.ED2K_HASH) != null && !this.onlyRemote) {
                    Object partialFile = be.getPartialFile(hash, QueryHashItem.ED2K_HASH);
                    elements.add("PartialFileHash");
                    elements.add(hash);
                } else if (be.getRemoteFile(hash, QueryHashItem.ED2K_HASH) != null) {
                    RemoteFileInfos rfi = be.getRemoteFile(hash, QueryHashItem.ED2K_HASH);
                    elements.add("RemoteFileHash");
                    elements.add(hash);
                }
            }
        }
        return elements;
    }

    public ArrayList process(QueryInetAddressItem qh) {
        ArrayList<Boolean> elements = new ArrayList<Boolean>();
        if (this.caller.getNeighbours().size() < WarriorAnt.maxNeighbours) {
            try {
                elements.add(new Boolean(true));
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }
        return elements;
    }

    public ArrayList process(QueryHttpServerItem qh) {
        ArrayList<Boolean> elements = new ArrayList<Boolean>();
        QueryManager queryManager = this;
        if (queryManager.caller.isHttpEnabled()) {
            try {
                elements.add(new Boolean(true));
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }
        return elements;
    }
}

