/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.ChunkHashes;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import ji.JI;

public class QueryRemoteFileTuple
extends QueryFileTuple {
    Object fileName;
    Object fileHash;
    Object ed2kFileHash;
    Object fileLength;
    Object ownerID;
    Object ownerIP;
    Object extendedInfos;
    Object lastTimeSeen;

    public QueryRemoteFileTuple(String sessionKey, String fileName, String fileHash, String ed2kFileHash, Long fileLength, String ownerID, String ownerIP, String extendedInfos, Long lastTimeSeen) {
        super(sessionKey);
        this.fileHash = fileHash;
        this.ed2kFileHash = ed2kFileHash;
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.ownerID = ownerID;
        this.ownerIP = ownerIP;
        this.extendedInfos = extendedInfos;
        this.lastTimeSeen = lastTimeSeen;
    }

    public String getFileName() {
        if (this.fileName instanceof String) {
            return (String)this.fileName;
        }
        return null;
    }

    public String getFileHash() {
        if (this.fileHash instanceof String) {
            return (String)this.fileHash;
        }
        return null;
    }

    public String getED2KFileHash() {
        if (this.ed2kFileHash instanceof String) {
            return (String)this.ed2kFileHash;
        }
        return null;
    }

    public ChunkHashes getChunkHashes() {
        return null;
    }

    public Long getSize() {
        if (this.fileLength instanceof Long) {
            return (Long)this.fileLength;
        }
        return null;
    }

    public String getExtendedInfos() {
        if (this.extendedInfos instanceof String) {
            return (String)this.extendedInfos;
        }
        return null;
    }

    public Long getLastTimeSeen() {
        if (this.lastTimeSeen instanceof Long) {
            return (Long)this.lastTimeSeen;
        }
        return null;
    }

    public void resetLastTimeSeen() {
        if (this.lastTimeSeen instanceof Long) {
            this.lastTimeSeen = new Long(System.currentTimeMillis());
        }
    }

    public String getOwnerID() {
        if (this.ownerID instanceof String) {
            return (String)this.ownerID;
        }
        return null;
    }

    public String getOwnerIP() {
        if (this.ownerIP instanceof String) {
            return (String)this.ownerIP;
        }
        return null;
    }

    public Integer getFreeSlots() {
        return null;
    }

    public String getConnectionType() {
        return null;
    }

    public void encrypt(Cipher c) throws Exception {
        this.fileName = new SealedObject((Serializable)((Object)((String)this.fileName)), c);
        this.fileHash = new SealedObject((Serializable)((Object)((String)this.fileHash)), c);
        this.ed2kFileHash = new SealedObject((Serializable)((Object)((String)this.ed2kFileHash)), c);
        this.fileLength = new SealedObject((Long)this.fileLength, c);
        this.extendedInfos = new SealedObject((Serializable)((Object)((String)this.extendedInfos)), c);
    }

    public void decrypt(Cipher c) throws Exception {
        this.fileName = (String)((SealedObject)this.fileName).getObject(c);
        this.fileHash = (String)((SealedObject)this.fileHash).getObject(c);
        this.ed2kFileHash = (String)((SealedObject)this.ed2kFileHash).getObject(c);
        this.fileLength = (Long)((SealedObject)this.fileLength).getObject(c);
        this.extendedInfos = (String)((SealedObject)this.extendedInfos).getObject(c);
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getFileHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryCompletedFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryPartialFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryRemoteFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        return o == this;
    }

    public String toString() {
        String result = JI.i("Owner ID") + ": " + (this.getOwnerIP().equals("") ? this.getOwnerID().substring(0, 10) : this.getOwnerIP()) + "   " + JI.i("Getting infos from remote source");
        result = result + "     " + this.getFileName();
        return result;
    }

    public boolean checkHashesValidity() {
        return true;
    }
}

