/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security;

import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EndpointSecurityManager
extends Thread
implements Comparable {
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    public static final int DHKeyExchangeBits = 512;
    public static final int MinDHKeyExchangeBits = 512;
    public static final long inactivityTimeout = 1800000L;
    public static final long refreshInterval = 60000L;
    static Logger _logger = Logger.getLogger((String)EndpointSecurityManager.class.getName());
    DHParameterSpec dhParamSpec;
    KeyPair requirerKpair;
    KeyAgreement requirerKeyAgree;
    KeyPair peerKpair;
    KeyAgreement peerKeyAgree;
    PublicKey requirerPubKey;
    PublicKey peerPubKey;
    Message securityMessage;
    long lastTimeUsed = System.currentTimeMillis();
    boolean isRequirer;
    private WarriorAnt n;
    private String peerId;
    private String requirerId;
    private byte[] sharedSecret;
    private byte[] aesKey;
    private Cipher requirerCipherEnc;
    private Cipher requirerCipherDec;
    private Cipher peerCipherEnc;
    private Cipher peerCipherDec;
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    private BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private BigInteger skip1024Base = BigInteger.valueOf(2L);

    public EndpointSecurityManager(WarriorAnt n, String peerId) throws Exception {
        this.isRequirer = true;
        this.requirerId = n.getIdent();
        this.peerId = peerId;
        this.n = n;
        this.sendSecurityRequest();
        this.start();
    }

    public EndpointSecurityManager(WarriorAnt n, SecurityRequestMessage srm) throws Exception {
        this.isRequirer = false;
        this.requirerId = srm.getSource();
        this.peerId = n.getIdent();
        this.n = n;
        this.securityMessage = new Message(srm);
        this.processSecurityRequestMessage(srm);
        this.start();
    }

    public int compareTo(Object o) {
        if (o instanceof EndpointSecurityManager) {
            long compare = this.getLastTimeUsed() - ((EndpointSecurityManager)o).getLastTimeUsed();
            if (compare > 0L) {
                return -1;
            }
            if (compare < 0L) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void resetLastTimeUsed() {
        this.lastTimeUsed = 0L;
    }

    public void setLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public void run() {
        try {
            while (!this.n.isDisconnected() && System.currentTimeMillis() - this.getLastTimeUsed() < 1800000L) {
                EndpointSecurityManager.sleep(60000L);
                _logger.info((Object)("Secure connection with " + this.getPeerId().substring(0, 10) + " has " + (System.currentTimeMillis() - this.getLastTimeUsed()) / 1000L + " inactivity seconds (timout at " + 1800L + ")"));
                if (!(this.isRequirer ? !this.n.outputSecureConnections.contains(this) : !this.n.inputSecureConnections.contains(this))) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isRequirer()) {
            this.n.removeOutputSecureConnection(this.getPeerId());
            this.n.propertyChangeSupport.firePropertyChange("removedOutputSecureConnection", null, this.getPeerId());
        } else {
            this.n.removeInputSecureConnection(this.getPeerId());
        }
    }

    public String getPeerId() {
        if (this.isRequirer()) {
            return this.peerId;
        }
        return this.requirerId;
    }

    public boolean isRequirer() {
        return this.isRequirer;
    }

    private void generateDHParameters() throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.isRequirer()) {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
            paramGen.init(512);
            AlgorithmParameters params = paramGen.generateParameters();
            this.dhParamSpec = (DHParameterSpec)params.getParameterSpec(DHParameterSpec.class);
            KeyPairGenerator requirerKpairGen = KeyPairGenerator.getInstance("DH");
            requirerKpairGen.initialize(this.dhParamSpec);
            this.requirerKpair = requirerKpairGen.generateKeyPair();
            this.requirerKeyAgree = KeyAgreement.getInstance("DH");
            this.requirerKeyAgree.init(this.requirerKpair.getPrivate());
            this.requirerPubKey = this.requirerKpair.getPublic();
        } else {
            this.dhParamSpec = new DHParameterSpec(this.skip1024Modulus, this.skip1024Base);
            KeyPairGenerator peerKpairGen = KeyPairGenerator.getInstance("DH");
            peerKpairGen.initialize(this.dhParamSpec);
            this.peerKpair = peerKpairGen.generateKeyPair();
            this.peerKeyAgree = KeyAgreement.getInstance("DH");
            this.peerKeyAgree.init(this.peerKpair.getPrivate());
            this.peerPubKey = this.peerKpair.getPublic();
        }
    }

    public void sendSecurityRequest() throws Exception {
        if (!this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        try {
            this.generateDHParameters();
            this.requirerCipherEnc = Cipher.getInstance(cipher);
            this.requirerCipherDec = Cipher.getInstance(cipher);
            SecurityRequestMessage srm = new SecurityRequestMessage(this.dhParamSpec.getG(), this.dhParamSpec.getP(), this.requirerPubKey);
            MessageWrapper wm = this.n.sendMessage(srm, this.peerId, false, false);
            this.securityMessage = new Message(wm);
            this.n.pendingSecureRequest.add(this);
            Object[] collection = this.n.pendingSecureRequest.toArray();
            Arrays.sort(collection);
            this.n.pendingSecureRequest = new ArrayList<Object>(Arrays.asList(collection));
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            this.lastTimeUsed = 0L;
        }
    }

    public Message getSecurityMessage() {
        return this.securityMessage;
    }

    public void processSecurityResponseMessage(SecurityResponseMessage srm) throws Exception {
        if (!this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        try {
            this.peerPubKey = srm.getPeerPubkey();
            if (this.peerPubKey.getEncoded().length * 8 < 512) {
                throw new InvalidAlgorithmParameterException("Endpoint security Error: key size < 512");
            }
            KeyFactory serverKeyFac = KeyFactory.getInstance("DH");
            this.requirerKeyAgree.doPhase(this.peerPubKey, true);
            this.sharedSecret = this.requirerKeyAgree.generateSecret();
            this.aesKey = new byte[16];
            for (int x = 0; x < this.aesKey.length; ++x) {
                this.aesKey[x] = this.sharedSecret[x];
            }
            SecretKeySpec serverKeySpec = new SecretKeySpec(this.aesKey, cipher);
            this.requirerCipherEnc.init(1, serverKeySpec);
            this.requirerCipherDec.init(2, serverKeySpec);
            this.n.pendingSecureRequest.remove(this);
            this.n.myMessages.remove(this.getSecurityMessage());
            this.n.outputSecureConnections.add(this);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            this.lastTimeUsed = 0L;
        }
    }

    public Cipher getCipherEnc() {
        this.setLastTimeUsed();
        if (this.isRequirer()) {
            return this.requirerCipherEnc;
        }
        return this.peerCipherEnc;
    }

    public Cipher getCipherDec() {
        this.setLastTimeUsed();
        if (this.isRequirer()) {
            return this.requirerCipherDec;
        }
        return this.peerCipherDec;
    }

    public void processSecurityRequestMessage(SecurityRequestMessage srm) throws Exception {
        if (this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        boolean found = false;
        for (int x = this.n.inputSecureConnections.size() - 1; x >= 0; --x) {
            EndpointSecurityManager esm = (EndpointSecurityManager)this.n.inputSecureConnections.get(x);
            if (esm.getPeerId().equals(this.getPeerId()) && esm.getSecurityMessage().equals(srm)) {
                _logger.debug((Object)("Keep current " + esm.getPeerId() + " " + esm.getSecurityMessage().getAck_Id()));
                _logger.debug((Object)(this.peerId + " " + srm.getAck_Id()));
                found = true;
            } else if (esm.getPeerId().equals(this.getPeerId()) && !esm.getSecurityMessage().equals(srm)) {
                _logger.debug((Object)("Remove old " + esm.getPeerId() + " " + esm.getSecurityMessage().getAck_Id()));
                _logger.debug((Object)(this.peerId + " " + srm.getAck_Id()));
                this.n.inputSecureConnections.remove(x);
            }
            if (!found) continue;
            return;
        }
        this.peerCipherEnc = Cipher.getInstance(cipher);
        this.peerCipherDec = Cipher.getInstance(cipher);
        this.skip1024Base = srm.getP();
        this.skip1024Modulus = srm.getG();
        this.generateDHParameters();
        this.requirerPubKey = srm.getRequirerPubkey();
        SecurityResponseMessage answer = new SecurityResponseMessage(this.peerPubKey, new Message(srm));
        MessageWrapper wm = this.n.sendMessage(answer, this.requirerId, false, false);
        KeyFactory peerKeyFac = KeyFactory.getInstance("DH");
        this.peerKeyAgree.doPhase(this.requirerPubKey, true);
        this.sharedSecret = this.peerKeyAgree.generateSecret();
        this.aesKey = new byte[16];
        for (int x = 0; x < this.aesKey.length; ++x) {
            this.aesKey[x] = this.sharedSecret[x];
        }
        SecretKeySpec clientKeySpec = new SecretKeySpec(this.aesKey, cipher);
        this.peerCipherEnc.init(1, clientKeySpec);
        this.peerCipherDec.init(2, clientKeySpec);
        this.n.inputSecureConnections.add(this);
        Object[] collection = this.n.inputSecureConnections.toArray();
        Arrays.sort(collection);
        this.n.inputSecureConnections = new ArrayList<Object>(Arrays.asList(collection));
    }
}

