/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.NeighbourAnt;
import ants.p2p.security.sockets.SecureServer;
import ants.p2p.security.sockets.SecureServerSocketThread;
import ants.p2p.utils.addresses.InetAddressWatchdog;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

class NewClientHandler
extends Thread {
    Socket localSocket;
    SecureServer caller;
    static Logger _logger = Logger.getLogger((String)NewClientHandler.class.getName());

    public NewClientHandler(SecureServer caller, Socket localSocket) {
        this.localSocket = localSocket;
        this.caller = caller;
        this.setPriority(5);
    }

    public void run() {
        block8: {
            try {
                String remoteAddress = this.localSocket.getInetAddress().getHostAddress();
                if (!InetAddressWatchdog.getInstance().allowedAddress(InetAddress.getByName(remoteAddress).getHostAddress())) {
                    this.localSocket.close();
                    throw new Exception("Address is not allowed: " + remoteAddress);
                }
                if (this.caller.n.getNeighboursNumber() < this.caller.n.getMaxNeighbours()) {
                    this.localSocket.setKeepAlive(true);
                    SecureServerSocketThread serverSocketThread = new SecureServerSocketThread(this.localSocket);
                    if (serverSocketThread.isNewVersionDetected()) {
                        this.caller.n.getPropertyChangeSupport().firePropertyChange("newANtsVersionDetected", null, serverSocketThread.getNewerVersion());
                    }
                    if (!this.localSocket.isClosed()) {
                        SecureServer secureServer = this.caller;
                        _logger.info((Object)(this.caller.serverSocket.getInetAddress().getHostAddress() + ": Local time elapsed: " + serverSocketThread.getTimeElapsed() + "[Thresold: " + secureServer.n.getRateThresold() + "]"));
                        NeighbourAnt na = new NeighbourAnt(this.caller.n, this.localSocket.getInetAddress() + "", this.localSocket.getPort(), serverSocketThread.getRemoteServerPort(), serverSocketThread.getCipherEnc(), serverSocketThread.getCipherDec(), serverSocketThread.getSocket(), false, serverSocketThread.getTimeElapsed());
                        try {
                            this.caller.n.addNeighbour(na);
                            na.start();
                        }
                        catch (Exception e) {
                            na.terminate();
                            na.setFailure();
                            na.start();
                            throw new Exception(e);
                        }
                        _logger.info((Object)(this.caller.n.getShortId() + " :Server added neighbour..."));
                        break block8;
                    }
                    _logger.info((Object)(this.caller.n.getShortId() + " :Rejected connection..."));
                    break block8;
                }
                this.localSocket.close();
                _logger.info((Object)(this.caller.n.getShortId() + " :Rejected neighbour..."));
            }
            catch (Exception e) {
                _logger.error((Object)("New client handler: " + this.caller.serverSocket.getLocalPort() + " "), (Throwable)e);
            }
        }
    }
}

