/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.utils.addresses.InetAddressWatchdog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLProvider {
    private static void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: " + "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:0.9.3) Gecko/20010801" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (replyStr.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through " + host + ":" + port + ".  Proxy returns \"" + replyStr + "\"");
        }
    }

    public static Socket getSSLSecuredSocket(String remoteAddress, int remotePort, boolean proxied) throws Exception {
        Socket socket;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = null;
        sc = SSLContext.getInstance("TLSv1");
        sc.init(null, trustAllCerts, new SecureRandom());
        if (!InetAddressWatchdog.getInstance().allowedAddress(InetAddress.getByName(remoteAddress).getHostAddress())) {
            throw new Exception("Address is not allowed: " + remoteAddress);
        }
        if (proxied) {
            String tunnelHost = System.getProperty("https.proxyHost");
            int tunnelPort = Integer.getInteger("https.proxyPort");
            Socket tunnel = new Socket(tunnelHost, tunnelPort);
            tunnel.setKeepAlive(true);
            tunnel.setSoTimeout(5000);
            SSLProvider.doTunnelHandshake(tunnel, InetAddress.getByName(remoteAddress).getHostAddress(), remotePort);
            socket = sc.getSocketFactory().createSocket(tunnel, InetAddress.getByName(remoteAddress).getHostAddress(), remotePort, true);
        } else {
            Socket raw = new Socket(InetAddress.getByName(remoteAddress), remotePort);
            raw.setKeepAlive(true);
            raw.setSoTimeout(5000);
            socket = sc.getSocketFactory().createSocket(raw, InetAddress.getByName(remoteAddress).getHostAddress(), remotePort, true);
        }
        socket.setKeepAlive(true);
        socket.setSoTimeout(5000);
        return socket;
    }
}

