/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.indexer;

import ants.p2p.query.QueryFileListUploaderThread;
import ants.p2p.query.QuerySupernodeTuple;
import ants.p2p.utils.indexer.BackgroundEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class SupernodeEngine
extends Thread {
    BackgroundEngine caller;
    static Logger _logger = Logger.getLogger((String)SupernodeEngine.class.getName());

    public SupernodeEngine(BackgroundEngine caller) {
        this.caller = caller;
        this.setPriority(1);
    }

    public void refreshSuperNodeList() {
        String supNode;
        for (int x = this.caller.lastUsedSuperNodes.size() - 1; x >= 0; --x) {
            supNode = (String)this.caller.lastUsedSuperNodes.get(x);
            if (this.caller.wa.existRouteTo(supNode) && this.caller.supernodeList.containsKey(supNode)) continue;
            this.caller.lastTimeUploadedFileList.remove(supNode);
            this.caller.setLastUploadedList(supNode, null);
            this.caller.lastUsedSuperNodes.remove(supNode);
            this.caller.supernodeList.remove(supNode);
        }
        Enumeration keys = this.caller.supernodeList.keys();
        while (keys.hasMoreElements()) {
            supNode = (String)keys.nextElement();
            if (this.caller.wa.existRouteTo(supNode)) continue;
            this.caller.lastTimeUploadedFileList.remove(supNode);
            this.caller.setLastUploadedList(supNode, null);
            this.caller.lastUsedSuperNodes.remove(supNode);
            this.caller.supernodeList.remove(supNode);
        }
    }

    public void run() {
        try {
            SupernodeEngine.sleep((long)Math.floor(Math.random() * 1000.0 * 60.0 * 3.0));
        }
        catch (InterruptedException ex1) {
            // empty catch block
        }
        boolean counter = false;
        while (!this.caller.terminate) {
            try {
                _logger.info((Object)"Looking for supernodes...");
                if (this.caller.wa != null) {
                    this.caller.wa.doSupernodeQuery();
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"", (Throwable)ex);
            }
            try {
                SupernodeEngine.sleep(120000L);
                this.refreshSuperNodeList();
                if (BackgroundEngine.getInstance().isUploadingFileList()) {
                    _logger.info((Object)"Uploading file list...");
                    continue;
                }
                for (int g = 0; g < this.caller.lastUsedSuperNodes.size(); ++g) {
                    QueryFileListUploaderThread qflut;
                    QuerySupernodeTuple qst;
                    long idleUploadingList = System.currentTimeMillis() - (Long)this.caller.lastTimeUploadedFileList.get(this.caller.lastUsedSuperNodes.get(g));
                    if (idleUploadingList > (long)BackgroundEngine.remoteIndexedDocumentsTimeout) {
                        this.caller.setLastUploadedList((String)this.caller.lastUsedSuperNodes.get(g), null);
                        qst = (QuerySupernodeTuple)this.caller.supernodeList.get(this.caller.lastUsedSuperNodes.get(g));
                        qflut = new QueryFileListUploaderThread(this.caller.wa, qst.getQueryMessage(), (String)this.caller.lastUsedSuperNodes.get(g));
                        this.caller.lastTimeUploadedFileList.put(this.caller.lastUsedSuperNodes.get(g), new Long(System.currentTimeMillis()));
                        BackgroundEngine.getInstance().uploadingFileList();
                        qflut.start();
                        continue;
                    }
                    if (!this.caller.forceUploadingLists) continue;
                    qst = (QuerySupernodeTuple)this.caller.supernodeList.get(this.caller.lastUsedSuperNodes.get(g));
                    qflut = new QueryFileListUploaderThread(this.caller.wa, qst.getQueryMessage(), (String)this.caller.lastUsedSuperNodes.get(g));
                    this.caller.lastTimeUploadedFileList.put(this.caller.lastUsedSuperNodes.get(g), new Long(System.currentTimeMillis()));
                    BackgroundEngine.getInstance().uploadingFileList();
                    qflut.start();
                }
                this.caller.forceUploadingLists = false;
                if (this.caller.supernodeList.size() <= 0 || this.caller.lastUsedSuperNodes.size() >= this.caller.uploadListToSupernodes || this.caller.lastUsedSuperNodes.size() >= this.caller.supernodeList.size()) continue;
                ArrayList supNodes = new ArrayList(this.caller.supernodeList.keySet());
                Collections.shuffle(supNodes);
                supNodes.removeAll(this.caller.lastUsedSuperNodes);
                String dest = (String)supNodes.remove(0);
                while (supNodes.size() > 0 && this.caller.lastUsedSuperNodes.contains(dest)) {
                    dest = (String)supNodes.remove(0);
                }
                if (this.caller.lastUsedSuperNodes.contains(dest)) continue;
                this.caller.setLastUploadedList(dest, null);
                QuerySupernodeTuple qst = (QuerySupernodeTuple)this.caller.supernodeList.get(dest);
                QueryFileListUploaderThread qflut = new QueryFileListUploaderThread(this.caller.wa, qst.getQueryMessage(), dest);
                this.caller.lastUsedSuperNodes.add(dest);
                this.caller.lastTimeUploadedFileList.put(dest, new Long(System.currentTimeMillis()));
                BackgroundEngine.getInstance().uploadingFileList();
                qflut.start();
            }
            catch (Exception ex2) {
                _logger.error((Object)"", (Throwable)ex2);
            }
        }
    }
}

