/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import ants.p2p.Ant;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.ConnectionAntPanel;
import ants.p2p.query.ServerInfo;
import ants.p2p.utils.addresses.InetAddressEngine;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootstrapServerManager {
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final File bootstrapServers = new File(WarriorAnt.workingPath + "gwebcacheservers.dat");
    private static final Log LOG = LogFactory.getLog((Class)BootstrapServerManager.class);
    private static final BootstrapServerManager INSTANCE = new BootstrapServerManager();
    public static final int CACHE_OFF = 0;
    public static final int FETCH_SCHEDULED = 1;
    public static final int FETCH_IN_PROGRESS = 2;
    public static final int FETCHED_TOO_MANY = 3;
    public static final int NO_CACHES_LEFT = 4;
    private static final int MAX_RESPONSES = 20;
    private static final int MAX_CACHES = 2;
    private static final int ENDPOINTS_TO_ADD = 50;
    private static final int MAX_BOOTSTRAP_SERVERS = 1000;
    public static int MAX_HOSTS_PER_REQUEST = 5;
    public static int UPDATE_DELAY_MSEC = 3600000;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private Random _rand = new Random();
    private volatile boolean _hostFetchInProgress = false;
    private volatile int _lastIndex = 0;
    private volatile int _responsesAdded = 0;

    public static BootstrapServerManager instance() {
        return INSTANCE;
    }

    protected BootstrapServerManager() {
        if (bootstrapServers.exists()) {
            try {
                XMLDecoder ois = new XMLDecoder(new FileInputStream(bootstrapServers));
                Object servers = ois.readObject();
                if (servers != null) {
                    this.SERVERS.clear();
                    this.SERVERS.addAll((List)servers);
                }
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.propertyChangeSupport.addPropertyChangeListener(InetAddressEngine.getInstance());
    }

    private void storeServers() {
        try {
            XMLEncoder oos = new XMLEncoder(new FileOutputStream(bootstrapServers));
            oos.writeObject(this.SERVERS);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addBootstrapServer(BootstrapServer server) {
        if (server == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains(server)) {
            this.SERVERS.add(server);
            if (this.SERVERS.size() > 1000) {
                this.removeServer((BootstrapServer)this.SERVERS.get(0));
            }
            this.storeServers();
        }
    }

    public synchronized void bootstrapServersAdded() {
        this.addDefaultsIfNeeded();
        Collections.shuffle(this.SERVERS);
    }

    public synchronized void resetData() {
        this._lastIndex = 0;
        this._responsesAdded = 0;
        Collections.shuffle(this.SERVERS);
    }

    public boolean isEndpointFetchInProgress() {
        return this._hostFetchInProgress;
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized int fetchEndpointsAsync() {
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            if (this._responsesAdded >= 20 && this._lastIndex >= 2) {
                return 3;
            }
            if (this._lastIndex >= this.size()) {
                return 4;
            }
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
            return 1;
        }
        return 2;
    }

    public synchronized int fetchEndpointsAsyncV2() {
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            if (this._responsesAdded >= 20 && this._lastIndex >= 2) {
                return 3;
            }
            if (this._lastIndex >= this.size()) {
                return 4;
            }
            this._hostFetchInProgress = true;
            this.requestAsync(new V2HostsRequest(), "GWebCache hostfile v2");
            return 1;
        }
        return 2;
    }

    public synchronized void sendUpdatesAsync(ServerInfo myIP) {
        if (myIP == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        try {
            if (ConnectionAntPanel.isInternetPublicAddress(myIP.getAddress())) {
                this.requestAsync(new UpdateRequest(myIP), "GWebCache update");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void sendUpdatesAsyncV2(ServerInfo myIP) {
        if (myIP == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        try {
            if (ConnectionAntPanel.isInternetPublicAddress(myIP.getAddress())) {
                this.requestAsync(new V2UpdateRequest(myIP), "GWebCache update v2");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
        Collections.shuffle(this.SERVERS);
    }

    private void requestAsync(final GWebCacheRequest request, String threadName) {
        if (request == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BootstrapServerManager.this.requestBlocking(request);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    request.done();
                }
            }
        };
        runner.setName(threadName);
        runner.setDaemon(true);
        runner.start();
    }

    private void requestBlocking(GWebCacheRequest request) {
        BootstrapServer e;
        if (request == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        ArrayList<BootstrapServer> alreadyContacted = new ArrayList<BootstrapServer>();
        for (int i = 0; request.needsMoreData() && i < MAX_HOSTS_PER_REQUEST && (e = request.nextServer()) != null; ++i) {
            if (alreadyContacted.contains(e)) continue;
            this.requestFromOneHost(request, e);
            alreadyContacted.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFromOneHost(GWebCacheRequest request, BootstrapServer server) {
        GetMethod get;
        if (request == null) {
            throw new NullPointerException("null cache in request to one host");
        }
        if (server == null) {
            throw new NullPointerException("null server in request to one host");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("requesting: " + request + " from " + server));
        }
        BufferedReader in = null;
        String urlString = server.getURLString();
        String connectTo = urlString + "?client=" + Ant.getApplicationName() + "&version=" + URLEncoder.encode(Ant.getVersion()) + "&" + request.parameters();
        try {
            get = new GetMethod(connectTo);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn((Object)"Invalid server", (Throwable)iae);
            request.handleError(server);
            return;
        }
        get.addRequestHeader("Cache-Control", "no-cache");
        get.addRequestHeader("User-Agent", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:0.9.3) Gecko/20010801");
        get.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        get.setFollowRedirects(false);
        HttpClient client = HttpClientManager.getNewClient(30000, 10000);
        if (Ant.proxied) {
            String tunnelHost = System.getProperty("https.proxyHost");
            int tunnelPort = Integer.getInteger("https.proxyPort");
            client.getHostConfiguration().setProxy(tunnelHost, tunnelPort);
        }
        try {
            String line;
            HttpClientManager.executeMethodRedirecting(client, (HttpMethod)get);
            InputStream is = get.getResponseBodyAsStream();
            if (is == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid server: " + server));
                }
                request.handleError(server);
                return;
            }
            in = new BufferedReader(new InputStreamReader(is));
            if (get.getStatusCode() < 200 || get.getStatusCode() >= 300) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid status code: " + get.getStatusCode()));
                }
                throw new IOException("no 2XX ok.");
            }
            boolean firstLine = true;
            boolean errors = false;
            while ((line = in.readLine()) != null) {
                if (firstLine && BootstrapServer.startsWithIgnoreCase(line, "ERROR")) {
                    request.handleError(server);
                    errors = true;
                } else {
                    boolean retVal = request.handleResponseData(server, line);
                    if (!errors) {
                        errors = !retVal;
                    }
                }
                firstLine = false;
            }
            if (!errors) {
                this._lastConnectable = server;
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Exception while handling server", (Throwable)ioe);
            request.handleError(server);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
                get.abort();
            }
        }
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized void removeServer(BootstrapServer server) {
        this.SERVERS.remove(server);
        this._lastIndex = Math.max(0, this._lastIndex - 1);
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse;
        private ServerInfo myIP;

        protected UpdateRequest(ServerInfo myIP) {
            this.gotResponse = false;
            this.myIP = myIP;
        }

        protected String parameters() {
            String urlPart = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                urlPart = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURLString());
            }
            String ipPart = null;
            if (this.myIP != null) {
                ipPart = "ip=" + this.myIP.getAddress().getHostAddress() + ":" + this.myIP.getPort();
            }
            if (urlPart == null && ipPart == null) {
                return "";
            }
            if (urlPart != null && ipPart == null) {
                return urlPart;
            }
            if (urlPart == null && ipPart != null) {
                return ipPart;
            }
            return ipPart + "&" + urlPart;
        }

        protected boolean handleResponseData(BootstrapServer server, String line) {
            if (BootstrapServer.startsWithIgnoreCase(line, "OK")) {
                this.gotResponse = true;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "update request";
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses;

        private UrlfileRequest() {
            this.responses = 0;
        }

        protected String parameters() {
            return "urlfile=1";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleResponseData(BootstrapServer server, String line) {
            try {
                BootstrapServer e = new BootstrapServer(line);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(e);
                }
                ++this.responses;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added bootstrap host: " + e));
                }
            }
            catch (ParseException error) {
                this.handleError(server);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 50;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "urlfile request";
        }
    }

    private final class V2HostsRequest
    extends GWebCacheRequest {
        private int responses;

        private V2HostsRequest() {
            this.responses = 0;
        }

        protected String parameters() {
            return "get=1&net=" + Ant.getNetName();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean handleResponseData(BootstrapServer server, String completeLine) {
            try {
                String[] splittedLine = completeLine.split("[|]");
                if (splittedLine[0].equalsIgnoreCase("H")) {
                    String line = splittedLine[1];
                    ServerInfo si = null;
                    int DEFAULT = 443;
                    int j = line.indexOf(":");
                    if (j < 0) {
                        si = new ServerInfo("", line, new Integer(443), "");
                    } else {
                        if (j == 0) {
                            throw new IllegalArgumentException();
                        }
                        if (j == line.length() - 1) {
                            si = new ServerInfo("", line.substring(0, j), new Integer(443), "");
                        } else {
                            String hostname = line.substring(0, j);
                            int port = 443;
                            try {
                                port = Integer.parseInt(line.substring(j + 1));
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException();
                            }
                            if (port < 0 || port > 65535) {
                                throw new IllegalArgumentException("invalid port");
                            }
                            si = new ServerInfo("", hostname, new Integer(port), "");
                        }
                    }
                    ArrayList<ServerInfo> al = new ArrayList<ServerInfo>();
                    al.add(si);
                    BootstrapServerManager.instance().propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, al);
                    ++this.responses;
                    BootstrapServerManager.this._responsesAdded++;
                    return true;
                }
                if (!splittedLine[0].equalsIgnoreCase("U")) return true;
            }
            catch (IllegalArgumentException bad) {
                this.handleError(server);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 50;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BootstrapServer nextServer() {
            BootstrapServer e = null;
            V2HostsRequest v2HostsRequest = this;
            synchronized (v2HostsRequest) {
                if (BootstrapServerManager.this._lastIndex >= BootstrapServerManager.this.SERVERS.size()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Used up all servers, last: " + BootstrapServerManager.this._lastIndex));
                    }
                } else {
                    e = (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this._lastIndex);
                    BootstrapServerManager.this._lastIndex++;
                }
            }
            return e;
        }

        public String toString() {
            return "hostfile request";
        }
    }

    private final class V2UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse;
        private ServerInfo myIP;

        protected V2UpdateRequest(ServerInfo myIP) {
            this.gotResponse = false;
            this.myIP = myIP;
        }

        protected String parameters() {
            String urlPart = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                urlPart = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURLString());
            }
            String ipPart = null;
            if (this.myIP != null) {
                ipPart = "ip=" + this.myIP.getAddress().getHostAddress() + ":" + this.myIP.getPort();
            }
            if (urlPart == null && ipPart == null) {
                return "";
            }
            if (urlPart != null && ipPart == null) {
                return "update=1&net=" + Ant.getNetName() + "&" + urlPart;
            }
            if (urlPart == null && ipPart != null) {
                return "update=1&net=" + Ant.getNetName() + "&" + ipPart;
            }
            return "update=1&net=" + Ant.getNetName() + "&" + ipPart + "&" + urlPart;
        }

        protected boolean handleResponseData(BootstrapServer server, String line) {
            if (BootstrapServer.startsWithIgnoreCase(line, "I|update|OK")) {
                this.gotResponse = true;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "update request";
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses;

        private HostfileRequest() {
            this.responses = 0;
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected boolean handleResponseData(BootstrapServer server, String line) {
            try {
                ServerInfo si = null;
                int DEFAULT = 443;
                int j = line.indexOf(":");
                if (j < 0) {
                    si = new ServerInfo("", line, new Integer(443), "");
                } else {
                    if (j == 0) {
                        throw new IllegalArgumentException();
                    }
                    if (j == line.length() - 1) {
                        si = new ServerInfo("", line.substring(0, j), new Integer(443), "");
                    } else {
                        String hostname = line.substring(0, j);
                        int port = 443;
                        try {
                            port = Integer.parseInt(line.substring(j + 1));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException();
                        }
                        if (port < 0 || port > 65535) {
                            throw new IllegalArgumentException("invalid port");
                        }
                        si = new ServerInfo("", hostname, new Integer(port), "");
                    }
                }
                ArrayList<ServerInfo> al = new ArrayList<ServerInfo>();
                al.add(si);
                BootstrapServerManager.instance().propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, al);
                ++this.responses;
                BootstrapServerManager.this._responsesAdded++;
            }
            catch (IllegalArgumentException bad) {
                this.handleError(server);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 50;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BootstrapServer nextServer() {
            BootstrapServer e = null;
            HostfileRequest hostfileRequest = this;
            synchronized (hostfileRequest) {
                if (BootstrapServerManager.this._lastIndex >= BootstrapServerManager.this.SERVERS.size()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Used up all servers, last: " + BootstrapServerManager.this._lastIndex));
                    }
                } else {
                    e = (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this._lastIndex);
                    BootstrapServerManager.this._lastIndex++;
                }
            }
            return e;
        }

        public String toString() {
            return "hostfile request";
        }
    }

    private abstract class GWebCacheRequest {
        private GWebCacheRequest() {
        }

        protected abstract String parameters();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleError(BootstrapServer server) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error on server: " + server));
            }
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.removeServer(server);
                if (BootstrapServerManager.this._lastConnectable == server) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract boolean handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected abstract BootstrapServer nextServer();

        protected void done() {
        }
    }
}

