/*
 * Decompiled with CFR 0.152.
 */
package ji;

import ants.p2p.filesharing.WarriorAnt;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class JI {
    private static JI instance = null;
    private Hashtable languages = new Hashtable();
    private static String translationsFile = WarriorAnt.workingPath + "translation.ji";
    private static boolean learn = false;
    private static String currentLanguage = null;
    private static final String naiveLanguage = "English";
    private static String languageServer = "http://antsp2p.sourceforge.net/translation.ji";

    public static void setLearning(boolean learningEnabled) {
        learn = learningEnabled;
    }

    public static void setCurrentLanguage(String language) {
        currentLanguage = language;
        String current = naiveLanguage;
        if (currentLanguage != null) {
            current = currentLanguage;
        }
        if (JI.getInstance().languages.get(current) == null) {
            JI.getInstance().languages.put(current, new Hashtable());
            JI.getInstance().storeTranslations();
        }
    }

    public static String[] getAvaiableLanguages() {
        String[] languageIndex = new String[JI.getInstance().languages.size()];
        Enumeration languageNames = JI.getInstance().languages.keys();
        int x = 0;
        while (languageNames.hasMoreElements()) {
            languageIndex[x++] = (String)languageNames.nextElement();
        }
        return languageIndex;
    }

    public static void setTranslationFile(String file) {
        if (file != null) {
            translationsFile = file;
            JI.getInstance().loadTranslations();
        }
    }

    public static void setTranslation(String phrase, String translatedPhrase, String language) {
        String current = naiveLanguage;
        if (language != null && JI.getInstance().languages.get(current = language) == null) {
            JI.getInstance().languages.put(current, new Hashtable());
            JI.getInstance().storeTranslations();
        }
        ((Hashtable)JI.getInstance().languages.get(current)).put(phrase, translatedPhrase);
        if (learn) {
            JI.getInstance().storeTranslations();
        }
    }

    public static ArrayList getNaivePhrases() {
        Enumeration phrases = ((Hashtable)JI.getInstance().languages.get(naiveLanguage)).keys();
        ArrayList rv = new ArrayList();
        while (phrases.hasMoreElements()) {
            rv.add(phrases.nextElement());
        }
        return rv;
    }

    public static JI getInstance() {
        if (instance == null) {
            instance = new JI();
            return instance;
        }
        return instance;
    }

    public static String i(String phrase) {
        try {
            String current = naiveLanguage;
            if (currentLanguage != null) {
                current = currentLanguage;
            }
            String naive = (String)((Hashtable)JI.getInstance().languages.get(naiveLanguage)).get(phrase);
            String translated = (String)((Hashtable)JI.getInstance().languages.get(current)).get(phrase);
            if (naive == null) {
                ((Hashtable)JI.getInstance().languages.get(naiveLanguage)).put(phrase, phrase);
                if (learn) {
                    JI.getInstance().storeTranslations();
                }
            }
            if (translated == null) {
                ((Hashtable)JI.getInstance().languages.get(current)).put(phrase, phrase);
                if (learn) {
                    JI.getInstance().storeTranslations();
                }
                translated = phrase;
            }
            return translated;
        }
        catch (Exception e) {
            JI.getInstance().downloadTranslationsAndReload();
            return phrase;
        }
    }

    private JI() {
        this.loadTranslations();
    }

    public void downloadTranslationsAndReload() {
        File languages = new File(translationsFile);
        try {
            URL languageURL = new URL(languageServer);
            InputStream is = languageURL.openStream();
            FileOutputStream os = new FileOutputStream(languages);
            byte[] read = new byte[512000];
            int bytesRead = 0;
            do {
                if ((bytesRead = is.read(read)) <= 0) continue;
                ((OutputStream)os).write(read, 0, bytesRead);
            } while (bytesRead > 0);
            is.close();
            ((OutputStream)os).close();
            this.loadTranslations();
        }
        catch (Exception e) {
            System.err.println("Remote languages file not found!");
            if (languages.exists()) {
                try {
                    XMLDecoder loader = new XMLDecoder(new FileInputStream(languages));
                    this.languages = (Hashtable)loader.readObject();
                    loader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.languages.put(naiveLanguage, new Hashtable());
                }
            }
            this.languages.put(naiveLanguage, new Hashtable());
        }
    }

    private void loadTranslations() {
        File languages = new File(translationsFile);
        if (languages.exists()) {
            try {
                XMLDecoder loader = new XMLDecoder(new FileInputStream(languages));
                this.languages = (Hashtable)loader.readObject();
                loader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.downloadTranslationsAndReload();
        }
    }

    private void storeTranslations() {
        File languages = new File(translationsFile);
        try {
            XMLEncoder storer = new XMLEncoder(new FileOutputStream(languages));
            storer.writeObject(this.languages);
            storer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

