/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;
import napkin.RandomValue;
import napkin.RandomValueSource;

public class DrawnBoxGenerator
extends DrawnShapeGenerator {
    private final RandomValue begX;
    private final RandomValue endY;
    private double adjustmentX;
    private double adjustmentY;
    private final RandomValue startAdjust;
    private final RandomValue sizeX;
    private final RandomValue sizeY;
    private int breakSide;
    private final Point2D breakBeg;
    private final Point2D breakEnd;
    private final Shape[] sides;
    private final DrawnShapeGenerator[] gens;
    private final Map generators = new HashMap(3);
    private boolean asX;
    private static boolean DEBUG = false;
    public static final String[] SIDE_NAMES = new String[]{null, "top", "left", "bottom", "right"};
    public static final DrawnBoxGenerator INSTANCE = new DrawnBoxGenerator();
    static /* synthetic */ Class class$napkin$DrawnCubicLineGenerator;
    static /* synthetic */ Class class$napkin$DrawnQuadLineGenerator;

    public DrawnBoxGenerator() {
        this(DrawnCubicLineGenerator.INSTANCE, DrawnQuadLineGenerator.INSTANCE);
    }

    public DrawnBoxGenerator(DrawnCubicLineGenerator cubic, DrawnQuadLineGenerator quad) {
        this.generators.put(class$napkin$DrawnCubicLineGenerator == null ? (class$napkin$DrawnCubicLineGenerator = DrawnBoxGenerator.class$("napkin.DrawnCubicLineGenerator")) : class$napkin$DrawnCubicLineGenerator, cubic);
        this.generators.put(class$napkin$DrawnQuadLineGenerator == null ? (class$napkin$DrawnQuadLineGenerator = DrawnBoxGenerator.class$("napkin.DrawnQuadLineGenerator")) : class$napkin$DrawnQuadLineGenerator, quad);
        this.sides = new Shape[5];
        this.gens = new DrawnShapeGenerator[5];
        for (int i = 1; i < 5; ++i) {
            this.setGenerator(i, class$napkin$DrawnCubicLineGenerator == null ? DrawnBoxGenerator.class$("napkin.DrawnCubicLineGenerator") : class$napkin$DrawnCubicLineGenerator);
        }
        this.begX = new RandomValue(-1.0, 3.0);
        this.endY = new RandomValue(0.0, 2.5);
        this.startAdjust = new RandomValue(5.0);
        this.sizeX = new SideSize(100.0, 2, 4);
        this.sizeY = new SideSize(61.8, 1, 3);
        this.breakSide = -1;
        this.breakBeg = new Point2D.Double(0.0, 0.0);
        this.breakEnd = new Point2D.Double(0.0, 0.0);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath shape = new GeneralPath();
        double xSize = this.sizeX.generate();
        double ySize = this.sizeY.generate();
        double xScale = xSize / 100.0;
        double yScale = ySize / 100.0;
        double xBeg = this.adjustStartOffset(this.begX, xScale);
        double yEnd = this.adjustStartOffset(this.endY, yScale);
        this.adjustmentX = xBeg - this.begX.get();
        this.adjustmentY = yEnd - this.endY.get();
        if (this.asX) {
            NapkinUtil.drawStroke(shape, matrix, xBeg, 0.0, xSize, ySize, Math.PI, this.gens[0]);
            NapkinUtil.drawStroke(shape, matrix, 0.0, ySize, xSize, yEnd, 0.0, this.gens[0]);
            return shape;
        }
        double scale = (xSize - xBeg) / 100.0;
        AffineTransform smat = NapkinUtil.copy(matrix);
        smat.translate(xBeg, 0.0);
        smat.scale(scale, 1.0);
        this.sides[1] = this.addSide(shape, smat, 1, scale);
        scale = xScale;
        smat = NapkinUtil.copy(matrix);
        smat.translate(xSize, ySize);
        smat.rotate(Math.PI);
        smat.scale(scale, 1.0);
        this.sides[3] = this.addSide(shape, smat, 3, scale);
        scale = yScale;
        smat = NapkinUtil.copy(matrix);
        smat.translate(xSize, 0.0);
        smat.rotate(1.5707963267948966);
        smat.scale(scale, 1.0);
        this.sides[4] = this.addSide(shape, smat, 4, scale);
        scale = (ySize - yEnd) / 100.0;
        smat = NapkinUtil.copy(matrix);
        smat.translate(0.0, ySize);
        smat.rotate(-1.5707963267948966);
        smat.scale(scale, 1.0);
        this.sides[2] = this.addSide(shape, smat, 2, scale);
        return shape;
    }

    private Shape addSide(GeneralPath shape, AffineTransform smat, int side, double scale) {
        if (side != this.breakSide) {
            return DrawnBoxGenerator.addLine(shape, smat, this.gens[side]);
        }
        GeneralPath line = new GeneralPath();
        if (side == 3 || side == 2) {
            scale = -scale;
        }
        if (side == 1 || side == 3) {
            this.addWithXBreak(smat, line, scale);
        } else {
            this.addWithYBreak(smat, line, scale);
        }
        shape.append(line, false);
        return line;
    }

    private void addWithXBreak(AffineTransform smat, GeneralPath line, double scale) {
        double xOff = smat.getTranslateX();
        double xSize = this.sizeX.get() - (this.begX.get() + this.adjustmentX);
        if (scale < 0.0) {
            xSize = -xSize;
        }
        double xBeg = this.breakBeg.getX() - xOff;
        double xEnd = this.breakEnd.getX() - xOff;
        this.dumpValues(smat, xBeg, xEnd);
        this.addSegment(line, smat, 0.0, 0.0, xBeg / scale);
        this.addSegment(line, smat, xEnd / scale, 0.0, (xSize - xEnd) / scale);
    }

    private void addWithYBreak(AffineTransform smat, GeneralPath line, double scale) {
        double yOff = smat.getTranslateY();
        double ySize = this.sizeY.get() - (this.endY.get() + this.adjustmentY);
        if (scale < 0.0) {
            ySize = -ySize;
        }
        double yBeg = this.breakBeg.getY() - yOff;
        double yEnd = this.breakEnd.getY() - yOff;
        this.dumpValues(smat, yBeg, yEnd);
        this.addSegment(line, smat, 0.0, 0.0, yBeg / scale);
        this.addSegment(line, smat, yEnd / scale, 0.0, (ySize - yEnd) / scale);
    }

    private void dumpValues(AffineTransform smat, double beg, double end) {
        if (DEBUG) {
            System.out.println();
            NapkinUtil.printPair("translate", smat.getTranslateX(), smat.getTranslateY());
            NapkinUtil.printPair("scale", smat.getScaleX(), smat.getScaleY());
            NapkinUtil.printPair("breakBeg", this.breakBeg.getX(), this.breakBeg.getY());
            NapkinUtil.printPair("breakEnd", this.breakEnd.getX(), this.breakEnd.getY());
            NapkinUtil.printPair("size", this.sizeX.get(), this.sizeY.get());
            NapkinUtil.printPair("adjustment", this.adjustmentX, this.adjustmentY);
            NapkinUtil.printPair("beg/end", this.begX.get(), this.endY.get());
            NapkinUtil.printPair("break beg/end", beg, end);
        }
    }

    private void addSegment(GeneralPath side, AffineTransform smat, double xBeg, double yBeg, double len) {
        if (DEBUG) {
            NapkinUtil.printPair("addSeg (len " + len + ")", xBeg, yBeg);
        }
        if (len > 0.0) {
            AffineTransform mat = NapkinUtil.copy(smat);
            mat.translate(xBeg, yBeg);
            mat.scale(len / 100.0, 1.0);
            DrawnBoxGenerator.addLine(side, mat, this.toGenerator(DrawnBoxGenerator.defaultLineType(len)));
        }
    }

    private double adjustStartOffset(RandomValueSource off, double scale) {
        if (scale >= 1.0) {
            return off.generate();
        }
        double delta = 1.0 - scale;
        double exp = this.startAdjust.generate();
        double adjusted = Math.pow(delta, exp);
        double startScale = 1.0 - adjusted;
        return off.generate() * startScale;
    }

    public RandomValue getBegX() {
        return this.begX;
    }

    public RandomValue getEndY() {
        return this.endY;
    }

    public RandomValue getSizeX() {
        return this.sizeX;
    }

    public RandomValue getSizeY() {
        return this.sizeY;
    }

    public RandomValue getStartAdjust() {
        return this.startAdjust;
    }

    public Shape getSide(int side) {
        return this.sides[side];
    }

    public void setBreak(int side, double begX, double begY, double endX, double endY) {
        this.breakSide = side;
        this.breakBeg.setLocation(begX, begY);
        this.breakEnd.setLocation(endX, endY);
    }

    public void setNoBreak() {
        this.breakSide = -1;
    }

    public void setGenerator(int side, Class type) {
        this.gens[side] = this.toGenerator(type);
    }

    public Class getGenerator(int side) {
        return DrawnBoxGenerator.fromGenerator(this.gens[side]);
    }

    private static Class fromGenerator(DrawnShapeGenerator gen) {
        if (gen == null) {
            return null;
        }
        return gen.getClass();
    }

    private DrawnShapeGenerator toGenerator(Class type) {
        if (type == null) {
            return null;
        }
        DrawnShapeGenerator gen = (DrawnShapeGenerator)this.generators.get(type);
        if (gen == null) {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        return gen;
    }

    public DrawnQuadLineGenerator getQuadGenerator() {
        return (DrawnQuadLineGenerator)this.generators.get(class$napkin$DrawnQuadLineGenerator == null ? (class$napkin$DrawnQuadLineGenerator = DrawnBoxGenerator.class$("napkin.DrawnQuadLineGenerator")) : class$napkin$DrawnQuadLineGenerator);
    }

    public DrawnCubicLineGenerator getCubicGenerator() {
        return (DrawnCubicLineGenerator)this.generators.get(class$napkin$DrawnCubicLineGenerator == null ? (class$napkin$DrawnCubicLineGenerator = DrawnBoxGenerator.class$("napkin.DrawnCubicLineGenerator")) : class$napkin$DrawnCubicLineGenerator);
    }

    public void setAsX(boolean asX) {
        this.asX = asX;
    }

    public boolean isAsX() {
        return this.asX;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SideSize
    extends RandomValue {
        private final int s1;
        private final int s2;

        SideSize(double val, int s1, int s2) {
            super(val);
            this.s1 = s1;
            this.s2 = s2;
            this.setSideType(val);
        }

        public void setMid(double mid) {
            super.setMid(mid);
            this.setSideType(mid);
        }

        private void setSideType(double mid) {
            Class type = DrawnShapeGenerator.defaultLineType(mid);
            DrawnBoxGenerator.this.setGenerator(this.s1, type);
            DrawnBoxGenerator.this.setGenerator(this.s2, type);
        }
    }
}

