/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;
import napkin.RandomValue;
import napkin.RandomValueSource;

public class DrawnCheckGenerator
extends DrawnShapeGenerator {
    private final RandomValueSource widthVal;
    private final RandomValueSource heightVal;
    private final DrawnQuadLineGenerator leftLineGen;
    private final DrawnQuadLineGenerator rightLineGen;
    private final RandomValue midXScale;
    private final RandomValue midYScale;
    private final RandomValue leftXScale;
    private final RandomValue leftYScale;
    private final RandomValue rightXScale;
    private final RandomValue rightYScale;
    public static final DrawnCheckGenerator INSTANCE = new DrawnCheckGenerator();

    public DrawnCheckGenerator() {
        this(10.0);
    }

    public DrawnCheckGenerator(double size) {
        this(new RandomValue(size), new RandomValue(size));
    }

    public DrawnCheckGenerator(RandomValueSource widthVal, RandomValueSource heightVal) {
        this.widthVal = widthVal;
        this.heightVal = heightVal;
        this.leftLineGen = new DrawnQuadLineGenerator();
        this.leftLineGen.getCtlY().setMid(2.0);
        this.leftLineGen.getCtlY().setRange(0.3);
        this.rightLineGen = new DrawnQuadLineGenerator();
        this.rightLineGen.getCtlY().setMid(-2.0);
        this.rightLineGen.getCtlY().setRange(0.3);
        this.leftXScale = new RandomValue(0.5, 0.075);
        this.leftYScale = new RandomValue(0.5, 0.075);
        this.midXScale = new RandomValue(0.5, 0.1);
        this.midYScale = new RandomValue(0.1, 0.05);
        this.rightXScale = new RandomValue(1.1, 0.1);
        this.rightYScale = new RandomValue(0.9, 0.1);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath check = new GeneralPath();
        double lxScale = this.leftXScale.generate();
        double lyScale = this.leftYScale.generate();
        double mxScale = this.midXScale.generate();
        double myScale = this.midYScale.generate();
        double rxScale = this.rightXScale.generate();
        double ryScale = this.rightYScale.generate();
        double boxWidth = this.widthVal.getMid();
        double boxHeight = this.heightVal.getMid();
        double mx = mxScale * boxWidth;
        double my = boxHeight - myScale * boxHeight;
        double lx = mx - lxScale * boxWidth;
        double ly = my - lyScale * boxHeight;
        double rx = mx + rxScale * boxWidth;
        double ry = my - ryScale * boxHeight;
        NapkinUtil.drawStroke(check, matrix, mx, my, lx, ly, -Math.PI, this.leftLineGen);
        NapkinUtil.drawStroke(check, matrix, mx, my, rx, ry, 0.0, this.rightLineGen);
        return check;
    }

    public RandomValue getLeftXScale() {
        return this.leftXScale;
    }

    public RandomValue getLeftYScale() {
        return this.leftYScale;
    }

    public RandomValue getMidXScale() {
        return this.midXScale;
    }

    public RandomValue getMidYScale() {
        return this.midYScale;
    }

    public RandomValue getRightXScale() {
        return this.rightXScale;
    }

    public RandomValue getRightYScale() {
        return this.rightYScale;
    }
}

